/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.eclipse.osgi.util.NLS;

public class TimeFormatHelper {
    public static final String NEGATIVE_TIME_STRING = "--";
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private static final long MILLISECONDS_PER_MINUTE = 60000L;
    private static final long MILLISECONDS_PER_HOUR = 3600000L;
    private static final long HOURS_PER_DAY = 24L;

    public static String formatTime(long timeInMilliseconds) {
        String hoursString;
        if (timeInMilliseconds == -1L) {
            return NEGATIVE_TIME_STRING;
        }
        if (timeInMilliseconds == 0L) {
            return BuildUIMessages.TimeFormatUtil_ZERO_SECONDS;
        }
        if (timeInMilliseconds < 1000L) {
            return timeInMilliseconds == 1L ? BuildUIMessages.TimeFormatUtil_ONE_MILLISECOND : NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_MILLISECONDS, (Object)new Long(timeInMilliseconds));
        }
        long seconds = timeInMilliseconds / 1000L % 60L;
        String secondsString = seconds == 1L ? BuildUIMessages.TimeFormatUtil_ONE_SECOND : NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_SECONDS, (Object)new Long(seconds));
        long minutes = timeInMilliseconds / 60000L % 60L;
        String minutesString = minutes == 1L ? BuildUIMessages.TimeFormatUtil_ONE_MINUTE : NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_MINUTES, (Object)new Long(minutes));
        long hours = timeInMilliseconds / 3600000L;
        String string = hoursString = hours == 1L ? BuildUIMessages.TimeFormatUtil_ONE_HOUR : NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_HOURS, (Object)new Long(hours));
        if (hours > 0L) {
            return NLS.bind((String)BuildUIMessages.TimeFormatUtil_HOURS_MINUTES_SECONDS, (Object[])new Object[]{hoursString, minutesString, secondsString});
        }
        if (minutes > 0L) {
            return NLS.bind((String)BuildUIMessages.TimeFormatUtil_MINUTES_SECONDS, (Object)minutesString, (Object)secondsString);
        }
        return secondsString;
    }

    public static String formatAbbreviatedTime(long timeInMilliseconds) {
        return TimeFormatHelper.formatAbbreviatedTime(timeInMilliseconds, true);
    }

    public static String formatAbbreviatedTime(long timeInMilliseconds, boolean showMilliseconds) {
        if (timeInMilliseconds == -1L) {
            return NEGATIVE_TIME_STRING;
        }
        long timeInSeconds = timeInMilliseconds / 1000L;
        long seconds = timeInSeconds % 60L;
        long timeInMinutes = timeInSeconds / 60L;
        long minutes = timeInMinutes % 60L;
        long timeInHours = timeInMinutes / 60L;
        long hours = timeInHours % 24L;
        String secondsString = seconds < 10L && timeInMilliseconds > 60000L ? "0%d" : "%d";
        String minutesString = minutes < 10L && timeInMilliseconds > 3600000L ? "0%d" : "%d";
        String hoursString = "%d";
        if (timeInMilliseconds < 1000L && showMilliseconds) {
            return NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_MS, (Object)timeInMilliseconds);
        }
        if (timeInMilliseconds < 60000L) {
            return NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_S, (Object)String.format(secondsString, seconds));
        }
        if (timeInMilliseconds < 3600000L) {
            return NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_M_X_S, (Object)String.format(minutesString, minutes), (Object)String.format(secondsString, seconds));
        }
        return NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_H_X_M_X_S, (Object[])new String[]{String.format(hoursString, hours), String.format(minutesString, minutes), String.format(secondsString, seconds)});
    }

    public static String formatStopwatchTime(long timeInMilliseconds) {
        String hoursString;
        long startTimeInSeconds = timeInMilliseconds / 1000L;
        long seconds = startTimeInSeconds % 60L;
        long startTimeInMinutes = startTimeInSeconds / 60L;
        long minutes = startTimeInMinutes % 60L;
        long startTimeInHours = startTimeInMinutes / 60L;
        long hours = startTimeInHours % 24L;
        long startTimeInDays = startTimeInHours / 24L;
        String secondsString = seconds < 10L ? "0%d" : "%d";
        String minutesString = minutes < 10L ? "0%d" : "%d";
        String string = hoursString = hours < 10L ? "0%d" : "%d";
        if (startTimeInDays > 0L) {
            String dayString = startTimeInDays == 1L ? BuildUIMessages.TimeFormatUtil_ONE_DAY : NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_DAYS, (Object)startTimeInDays);
            return NLS.bind((String)BuildUIMessages.TimeFormatUtil_STOPWATCH_TIME_XX_DAYS_XX_XX_XX, (Object[])new Object[]{dayString, String.format(hoursString, hours), String.format(minutesString, minutes), String.format(secondsString, seconds)});
        }
        return NLS.bind((String)BuildUIMessages.TimeFormatUtil_STOPWATCH_TIME_XX_XX_XX, (Object[])new Object[]{String.format(hoursString, hours), String.format(minutesString, minutes), String.format(secondsString, seconds)});
    }

    public static String getDateString(long timeMillis) {
        GregorianCalendar startDate = new GregorianCalendar();
        startDate.setTimeInMillis(timeMillis);
        DateFormat dateFormat = DateFormat.getDateTimeInstance((int)1, (int)2);
        return dateFormat.format(startDate.getTime());
    }

    public static String getReadableTimeDif(Date dateToCompare, long currentTimeInMilliseconds) {
        boolean isPast;
        if (dateToCompare == null) {
            return "";
        }
        long then = dateToCompare.getTime();
        long dif = currentTimeInMilliseconds - then;
        boolean bl = isPast = dif > 0L;
        if (!isPast) {
            dif *= -1L;
        }
        long numHours = TimeFormatHelper.getHours(dif);
        long difMinutes = dif - numHours * 3600000L;
        long numMinutes = TimeFormatHelper.getMinutes(difMinutes);
        long difSeconds = difMinutes - numMinutes * 60000L;
        long numSeconds = TimeFormatHelper.getSeconds(difSeconds);
        return TimeFormatHelper.createString(numHours, numMinutes, numSeconds, isPast, dateToCompare);
    }

    private static String createString(long numHours, long numMinutes, long numSeconds, boolean isPast, Date actualDate) {
        String message = "";
        message = numHours == 0L && numMinutes == 0L && numSeconds == 0L ? BuildUIMessages.TimeFormatUtil_NOW : (isPast ? (numHours > 24L ? NLS.bind((String)BuildUIMessages.TimeFormatUtil_MORE_THAN_X_DAYS_AGO, (Object)DateFormat.getDateTimeInstance().format(actualDate)) : (numHours == 24L ? BuildUIMessages.TimeFormatUtil_24_HOURS_AGO : (numHours > 1L ? (numMinutes > 1L ? NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_HOURS_X_MINUTES_AGO, (Object)new Long(numHours), (Object)new Long(numMinutes)) : (numMinutes == 1L ? NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_HOURS_ONE_MINUTE_AGO, (Object)new Long(numHours)) : NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_HOURS_AGO, (Object)new Long(numHours)))) : (numHours == 1L ? (numMinutes > 1L ? NLS.bind((String)BuildUIMessages.TimeFormatUtil_ONE_HOUR_X_MINUTES_AGO, (Object)new Long(numMinutes)) : (numMinutes == 1L ? BuildUIMessages.TimeFormatUtil_ONE_HOUR_ONE_MINUTE_AGO : BuildUIMessages.TimeFormatUtil_ONE_HOUR_AGO)) : (numMinutes > 1L ? NLS.bind((String)BuildUIMessages.TimeFormatUtil_X_MINUTES_AGO, (Object)new Long(numMinutes)) : (numMinutes == 1L ? BuildUIMessages.TimeFormatUtil_ONE_MINUTE_AGO : BuildUIMessages.TimeFormatUtil_LESS_THAN_ONE_MINUTE_AGO)))))) : (numHours > 24L ? NLS.bind((String)BuildUIMessages.TimeFormatUtil_MORE_THAN_X_DAYS, (Object)DateFormat.getDateTimeInstance().format(actualDate)) : (numHours == 24L ? BuildUIMessages.TimeFormatUtil_IN_24_HOURS : (numHours > 1L ? (numMinutes > 1L ? NLS.bind((String)BuildUIMessages.TimeFormatUtil_IN_X_HOURS_X_MINUTES, (Object)new Long(numHours), (Object)new Long(numMinutes)) : (numMinutes == 1L ? NLS.bind((String)BuildUIMessages.TimeFormatUtil_IN_X_HOURS_ONE_MINUTE, (Object)new Long(numHours)) : NLS.bind((String)BuildUIMessages.TimeFormatUtil_IN_X_HOURS, (Object)new Long(numHours)))) : (numHours == 1L ? (numMinutes > 1L ? NLS.bind((String)BuildUIMessages.TimeFormatUtil_IN_ONE_HOUR_X_MINUTES, (Object)new Long(numMinutes)) : (numMinutes == 1L ? BuildUIMessages.TimeFormatUtil_IN_ONE_HOUR_ONE_MINUTE : BuildUIMessages.TimeFormatUtil_IN_ONE_HOUR)) : (numMinutes > 1L ? NLS.bind((String)BuildUIMessages.TimeFormatUtil_IN_X_MINUTES, (Object)new Long(numMinutes)) : (numMinutes == 1L ? BuildUIMessages.TimeFormatUtil_IN_ONE_MINUTE : BuildUIMessages.TimeFormatUtil_IN_LESS_THAN_ONE_MINUTE)))))));
        return message;
    }

    public static String getReadableTimeDif(Date date) {
        long now = System.currentTimeMillis();
        return TimeFormatHelper.getReadableTimeDif(date, now);
    }

    private static long getSeconds(long dif) {
        return dif / 1000L;
    }

    private static long getMinutes(long dif) {
        return dif / 60000L;
    }

    private static long getHours(long dif) {
        return dif / 3600000L;
    }

    public static int get12HourFrom24HourFormat(int hourIn24HourFormat) {
        if (hourIn24HourFormat == 0) {
            return 12;
        }
        if (hourIn24HourFormat <= 12) {
            return hourIn24HourFormat;
        }
        return hourIn24HourFormat - 12;
    }

    public static String getAmPmFrom24HourFormat(int hourIn24HourFormat) {
        if (hourIn24HourFormat < 12) {
            return BuildUIMessages.BuildScheduleControl_BUILD_TIME_AM;
        }
        return BuildUIMessages.BuildScheduleControl_BUILD_TIME_PM;
    }

    public static boolean getUses24HourFormat(Locale locale) {
        DateFormat format = DateFormat.getTimeInstance((int)3, (Locale)locale);
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleFormat = (SimpleDateFormat)format;
            String pattern = simpleFormat.toPattern();
            return TimeFormatHelper.indexOfUnescaped(pattern, 'a') == -1;
        }
        return true;
    }

    public static boolean getAmPmAppearsFirst(Locale locale) {
        DateFormat format = DateFormat.getTimeInstance((int)3, (Locale)locale);
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleFormat = (SimpleDateFormat)format;
            String pattern = simpleFormat.toPattern();
            int aIndex = TimeFormatHelper.indexOfUnescaped(pattern, 'a');
            int hIndex = TimeFormatHelper.indexOfUnescaped(pattern, 'h');
            if (aIndex == -1 || hIndex == -1) {
                return false;
            }
            return aIndex < hIndex;
        }
        return false;
    }

    private static int indexOfUnescaped(String pattern, char c) {
        int i = 0;
        while (true) {
            if ((i = pattern.indexOf(c, i)) == -1) {
                return -1;
            }
            if (i <= 0 || pattern.charAt(i - 1) != '\'') break;
            ++i;
        }
        return i;
    }
}

