/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import com.ibm.team.build.internal.ui.helper.FileHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class RepositoryFileHelper {
    private static RepositoryFileHelper SINGLETON_REPOSITORY_HELPER = new RepositoryFileHelper();

    public static void saveRepositoryFile(String defaultFileName, IContent content, ITeamRepository teamRepository, Shell shell) {
        ValidationHelper.validateNotEmpty((String)"defaultFileName", (String)defaultFileName);
        ValidationHelper.validateNotNull((String)"content", (Object)content);
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        SINGLETON_REPOSITORY_HELPER.doSaveRepositoryFile(defaultFileName, content, teamRepository, shell);
    }

    protected void doSaveRepositoryFile(String defaultFileName, IContent content, ITeamRepository teamRepository, Shell shell) {
        String fileName = this.promptToSaveFile(defaultFileName, shell);
        if (fileName == null) {
            return;
        }
        this.doOpenSaveRepositoryFile(defaultFileName, fileName, content, teamRepository, null, shell, false);
    }

    protected String promptToSaveFile(String defaultFileName, Shell shell) {
        return FileHelper.promptToSaveFile(defaultFileName, shell);
    }

    public static void openRepositoryFile(String fileName, IContent content, ITeamRepository teamRepository, IWorkbenchPartSite partSite) {
        ValidationHelper.validateNotEmpty((String)"fileName", (String)fileName);
        ValidationHelper.validateNotNull((String)"content", (Object)content);
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        SINGLETON_REPOSITORY_HELPER.doOpenRepositoryFile(fileName, content, teamRepository, partSite);
    }

    protected String getUserPreferredCharacterEncoding() {
        IContentType textContentType = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        return textContentType.getDefaultCharset();
    }

    protected void doOpenRepositoryFile(String fileName, IContent content, ITeamRepository teamRepository, IWorkbenchPartSite partSite) {
        String originalFileName = fileName;
        if (ContentUtil.isTextContentType((String)content.getContentType())) {
            String preferredEncoding = this.getUserPreferredCharacterEncoding();
            String fileEncoding = content.getCharacterEncoding();
            if (preferredEncoding != null && !preferredEncoding.equals(fileEncoding) && Charset.isSupported(fileEncoding)) {
                fileName = String.valueOf(fileName) + "." + fileEncoding;
            }
        }
        try {
            File tmpFile = new File(this.createTempDir(), fileName);
            tmpFile.deleteOnExit();
            fileName = tmpFile.getAbsolutePath();
        }
        catch (IOException exception) {
            BuildUIHelper.showErrorDialog(NLS.bind((String)BuildUIHelperMessages.RepositoryFileHelper_ERROR_CREATING_FILE, (Object)fileName), null, exception);
            return;
        }
        this.doOpenSaveRepositoryFile(originalFileName, fileName, content, teamRepository, partSite, partSite.getShell(), true);
    }

    protected File createTempDir() throws IOException {
        File tmpDir = File.createTempFile("build", null);
        tmpDir.delete();
        if (!tmpDir.mkdir()) {
            throw new IOException(NLS.bind((String)BuildUIHelperMessages.RepositoryFileHelper_COULD_NOT_CREATE_TEMPDIR, (Object)tmpDir.getAbsolutePath()));
        }
        tmpDir.deleteOnExit();
        return tmpDir;
    }

    protected void doOpenSaveRepositoryFile(String originalFileName, final String filePath, final IContent content, final ITeamRepository teamRepository, final IWorkbenchPartSite partSite, Shell shell, final boolean openFile) {
        String jobName = NLS.bind((String)BuildUIHelperMessages.RepositoryFileHelper_RETRIEVING_CONTENT_STATUS_MESSAGE, (Object)new File(originalFileName).getName());
        TeamBuildJob job = new TeamBuildJob(jobName, true, teamRepository){

            public IStatus runProtected(IProgressMonitor monitor) throws Exception {
                File downloadedFile = RepositoryFileHelper.this.doRetrieveFileContent(content, teamRepository, filePath, monitor);
                if (!openFile) {
                    return Status.OK_STATUS;
                }
                final File finalFile = downloadedFile;
                RepositoryFileHelper.this.asyncExec(new Runnable(){

                    public void run() {
                        try {
                            if (ContentUtil.isTextContentType((String)content.getContentType())) {
                                RepositoryFileHelper.this.openTextFileInEditor(finalFile, content.getCharacterEncoding(), partSite);
                            } else {
                                RepositoryFileHelper.this.openFileInEditor(finalFile, partSite);
                            }
                        }
                        catch (CoreException ce) {
                            BuildUIPlugin.log(ce);
                        }
                    }
                });
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == BuildUIPlugin.getDefault();
            }
        };
        this.scheduleJob(job, shell);
    }

    protected void scheduleJob(TeamBuildJob job, Shell shell) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        progressService.showInDialog(shell, (Job)job);
        job.schedule();
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected void openTextFileInEditor(File file, String characterEncoding, IWorkbenchPartSite partSite) throws CoreException {
        BuildUIHelper.openTextFileInEditor(file, characterEncoding, partSite.getPage());
    }

    protected void openFileInEditor(File file, IWorkbenchPartSite partSite) throws CoreException {
        BuildUIHelper.openFileInEditor(file, partSite.getPage());
    }

    protected File doRetrieveFileContent(IContent content, ITeamRepository teamRepository, String filePath, IProgressMonitor monitor) throws TeamRepositoryException {
        return ContentUtil.contentToFile((ITeamRepository)teamRepository, (IContent)content, (IProgressMonitor)monitor, (String)filePath);
    }
}

