/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildAverageData;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import com.ibm.team.build.internal.ui.helper.TimeFormatHelper;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.osgi.util.NLS;

public class BuildResultTimeHelper {
    static {
        new BuildResultTimeHelper();
    }

    private BuildResultTimeHelper() {
    }

    public static String getDurationString(IBuildResult buildResult) {
        long duration = 0L;
        if (buildResult.getState() == BuildState.IN_PROGRESS) {
            long startTime = buildResult.getBuildStartTime();
            long currentTime = System.currentTimeMillis();
            duration = currentTime > startTime ? currentTime - startTime : 0L;
        } else {
            duration = buildResult.getBuildTimeTaken();
        }
        return TimeFormatHelper.formatTime(duration);
    }

    public static String getStartTimeString(IBuildResult buildResult) {
        long buildStartTime = buildResult.getBuildStartTime();
        if (buildStartTime == -1L) {
            return BuildResultEditorMessages.GeneralInfoSummarySection_UNKNOWN;
        }
        return TimeFormatHelper.getDateString(buildStartTime);
    }

    public static String getCompletedTime(IBuildResult buildResult) {
        long startTime = buildResult.getBuildStartTime();
        long timeTaken = buildResult.getBuildTimeTaken();
        if (startTime == -1L || timeTaken == -1L) {
            return BuildResultEditorMessages.GeneralInfoSummarySection_UNKNOWN;
        }
        return TimeFormatHelper.getDateString(startTime + timeTaken);
    }

    public static String getEstimatedCompletionTimeString(IBuildResult result, IBuildResultRecord buildResultRecord) {
        String estimatedCompletion = null;
        long averageTime = 0L;
        IBuildAverageData averageData = buildResultRecord.getBuildAverageData();
        if (averageData != null) {
            averageTime = averageData.getAverageBuildTimeTaken();
            long startTime = result.getBuildStartTime();
            GregorianCalendar startDate = new GregorianCalendar();
            startDate.setTimeInMillis(startTime);
            if (averageTime > 0L) {
                startDate.add(14, (int)averageTime);
                estimatedCompletion = System.currentTimeMillis() - startTime > averageTime ? NLS.bind((String)BuildResultEditorMessages.StatusSection_OVERDUE, (Object)TimeFormatHelper.getReadableTimeDif(startDate.getTime())) : TimeFormatHelper.getReadableTimeDif(startDate.getTime());
            }
        }
        if (estimatedCompletion != null) {
            return estimatedCompletion;
        }
        return "";
    }

    public static String getLastUpdateTimeString(IBuildResultRecord buildResultRecord) {
        Date modifiedDate = new Date(buildResultRecord.getLastModified());
        return TimeFormatHelper.getReadableTimeDif(modifiedDate);
    }

    public static String getProgressPercentString(IBuildResult buildResult, IBuildResultRecord buildResultRecord) {
        int percent = buildResultRecord.getPercentComplete();
        if (percent == -1) {
            return "";
        }
        String percentString = String.valueOf(percent);
        return NLS.bind((String)BuildResultEditorMessages.StatusSection_PROGRESS_PERCENT, (Object)percentString);
    }

    public static String getCompletionString(IBuildResultRecord[] resultRecords) {
        Long[] expectedCompletionTimes = BuildResultTimeHelper.getAllExpectedCompletionTimes(resultRecords);
        int numOverdueBuilds = 0;
        int numUnavailableTimes = 0;
        long latestExpectedCompletion = 0L;
        long now = System.currentTimeMillis();
        Long[] longArray = expectedCompletionTimes;
        int n = expectedCompletionTimes.length;
        int n2 = 0;
        while (n2 < n) {
            Long thisCompletionTime = longArray[n2];
            if (thisCompletionTime == null) {
                ++numUnavailableTimes;
            } else if (thisCompletionTime < now) {
                ++numOverdueBuilds;
            } else if (thisCompletionTime > latestExpectedCompletion) {
                latestExpectedCompletion = thisCompletionTime;
            }
            ++n2;
        }
        String statusString = numOverdueBuilds > 0 ? NLS.bind((String)(numOverdueBuilds == 1 ? BuildUIHelperMessages.BuildResultTimeHelper_OVERDUE_BUILD_ONE : BuildUIHelperMessages.BuildResultTimeHelper_OVERDUE_BUILD_MULTIPLE), (Object)numOverdueBuilds) : (numUnavailableTimes == expectedCompletionTimes.length ? BuildUIHelperMessages.BuildResultTimeHelper_ESTIMATED_COMPLETION_NOT_AVAILABLE : NLS.bind((String)BuildUIHelperMessages.BuildResultTimeHelper_ESTIMATED_COMPLETION_TIME, (Object)TimeFormatHelper.getReadableTimeDif(new Date(latestExpectedCompletion))));
        return statusString;
    }

    private static Long[] getAllExpectedCompletionTimes(IBuildResultRecord[] resultRecords) {
        Long[] expectedCompletionTimes = new Long[resultRecords.length];
        IBuildAverageData data = null;
        int i = 0;
        while (i < resultRecords.length) {
            data = resultRecords[i].getBuildAverageData();
            if (data == null) {
                expectedCompletionTimes[i] = null;
            } else {
                long timeTaken = data.getAverageBuildTimeTaken();
                expectedCompletionTimes[i] = new Long(timeTaken + resultRecords[i].getBuildResult().getBuildStartTime());
            }
            ++i;
        }
        return expectedCompletionTimes;
    }
}

