/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.workitem;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.workitem.WorkItemHelper;
import com.ibm.team.build.internal.ui.editors.result.workitem.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.core.queries.Query;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;

public class WorkItemContributionProvider
extends AbstractBuildResultContributionProvider {
    private ArrayList<IWorkItem> fWorkItems;
    private Query fWorkItemQuery;

    public WorkItemContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        ITeamRepository repository = this.getBuildResultContext().getTeamRepository();
        IWorkItemHandle[] workItemHandles = WorkItemHelper.getFixedInBuild((ITeamRepository)repository, (IBuildResultHandle)this.getBuildResultContext().getBuildResult(), (IProgressMonitor)monitor);
        this.fWorkItems = new ArrayList(workItemHandles.length);
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(IWorkItem.PROJECT_AREA_PROPERTY);
        properties.add(IWorkItem.ID_PROPERTY);
        List items = repository.itemManager().fetchPartialItems(Arrays.asList(workItemHandles), 0, properties, monitor);
        for (Object object : items) {
            if (object == null) continue;
            this.fWorkItems.add((IWorkItem)object);
        }
        this.fWorkItemQuery = this.getWorkItemQuery(this.getBuildResultContext().getBuildResult(), monitor);
    }

    private Query getWorkItemQuery(IBuildResult buildResult, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)buildResult.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
        ArrayList<AttributeExpression> expressions = new ArrayList<AttributeExpression>(this.fWorkItems.size());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.fWorkItems.size());
        for (IWorkItem workItem : this.fWorkItems) {
            IAttribute idAttribute = workItemClient.findAttribute(workItem.getProjectArea(), IWorkItem.ID_PROPERTY, (IProgressMonitor)subMonitor.newChild(1));
            AttributeExpression expression = new AttributeExpression((IAuditableCommon)auditableClient, idAttribute, AttributeOperation.EQUALS, (Object)new Integer(workItem.getId()));
            expressions.add(expression);
        }
        Term expression = new Term(1, expressions.toArray(new Expression[expressions.size()]));
        String queryName = NLS.bind((String)Messages.WorkItemContributionProvider_WORK_ITEMS_INCLUDED, (Object)buildResult.getLabel());
        return new Query(repository, queryName, (Expression)expression);
    }

    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    public String getSummaryText() {
        if (this.fWorkItems.size() > 0) {
            return NLS.bind((String)Messages.WorkItemContributionProvider_SUMMARY_TEXT, (Object)this.fWorkItems.size());
        }
        return Messages.WorkItemContributionProvider_NONE_INCLUDED;
    }

    public boolean isSummaryLink() {
        return this.fWorkItems.size() > 0;
    }

    public void summaryLinkActivated() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            if (this.fWorkItems.size() == 1) {
                WorkItemUI.open((IWorkbenchPage)window.getActivePage(), (Object)this.fWorkItems.get(0));
            } else {
                QueriesUI.showQueryResults((IWorkbenchWindow)window, (Query)this.fWorkItemQuery);
            }
        }
    }

    public AbstractBuildResultPage getBuildResultPage() {
        return null;
    }

    public String[] getExtendedContributionIds() {
        return new String[]{"fixedWorkItems"};
    }

    public String getSummaryTitle() {
        return Messages.WorkItemContributionProvider_SUMMARY_TITLE;
    }
}

