/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.summary;

import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.CreateReleaseDialog;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.summary.AbstractSummarySectionContent;
import com.ibm.team.build.internal.ui.editors.result.summary.BuildResultSummaryPage;
import com.ibm.team.build.internal.ui.editors.result.summary.GeneralInfoSummarySection;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.ide.ui.EditorUtilities;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IDeliverable;
import java.sql.Timestamp;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class ReleaseSection
extends AbstractSummarySectionContent {
    private static final String RELEASE_PAGE_ID = "com.ibm.team.workitem.deliverable";
    private IProjectAreaHandle fReleaseProjectArea;
    protected boolean fShouldCreateRelease;
    private Job fFetchReleaseJob;
    private Job fCreateReleaseJob;
    private BuildResultSummaryPage fSummaryPage;
    private GeneralInfoSummarySection fGeneralInfoSection;
    private Composite fReleaseComposite;
    private CreateReleaseDialog fCreateReleaseDialog;
    protected ImageHyperlink fReleaseHyperlink;
    protected Label fReleaseLabel;

    public ReleaseSection(BuildResultSummaryPage summaryPage, GeneralInfoSummarySection generalInfoSummarySection, IBuildResultRecord buildResultRecord, FormToolkit formToolkit, IEditorSite editorSite, ITeamRepository repository, IManagedForm managedForm) {
        this.fSummaryPage = summaryPage;
        this.fGeneralInfoSection = generalInfoSummarySection;
        this.setFormToolkit(formToolkit);
        this.setEditorSite(editorSite);
        this.setBuildResultRecord(buildResultRecord);
        this.setManagedForm(managedForm);
        this.setTeamRepository(repository);
    }

    public void createContents(Section section) {
        FormToolkit toolkit = this.getFormToolkit();
        section.setText(BuildResultEditorMessages.ReleaseSection_SECTION_TITLE);
        section.setDescription(BuildResultEditorMessages.ReleaseSection_SECTION_DESCRIPTION);
        this.fReleaseComposite = toolkit.createComposite((Composite)section);
        this.fReleaseComposite.setLayout((Layout)new GridLayout(1, false));
        this.fReleaseComposite.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)this.fReleaseComposite);
        this.fetchReleaseInBackground();
    }

    public void dispose() {
        if (this.fFetchReleaseJob != null) {
            this.fFetchReleaseJob.cancel();
        }
        if (this.fCreateReleaseJob != null) {
            this.fCreateReleaseJob.cancel();
        }
    }

    protected MessageDialog getDialog(Shell shell, String title, String message, int type) {
        return new MessageDialog(shell, title, null, message, type, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    protected void postSave() {
        if (this.fShouldCreateRelease) {
            this.createReleaseInBackground();
        }
    }

    private void fetchReleaseInBackground() {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.fReleaseLabel = toolkit.createLabel(this.fReleaseComposite, BuildResultEditorMessages.ReleaseSection_PENDING);
        String jobName = NLS.bind((String)BuildResultEditorMessages.ReleaseSection_FETCHING_RELEASE, (Object)this.getBuildResult().getLabel());
        this.fFetchReleaseJob = new TeamBuildJob(jobName, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ReleaseSection.this.fetchRelease(monitor);
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getSeverity() == 4) {
                    ReleaseSection.this.handleFetchError(status, this.isExpectedStatus(status));
                }
            }
        };
        this.fFetchReleaseJob.schedule();
    }

    protected void handleFetchError(IStatus errorStatus, final boolean isWarningOnly) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!ReleaseSection.this.fReleaseComposite.isDisposed()) {
                    ReleaseSection.this.fReleaseLabel.dispose();
                    FormToolkit toolkit = ReleaseSection.this.getManagedForm().getToolkit();
                    String label = isWarningOnly ? BuildResultEditorMessages.ReleaseSection_WARNING_LABEL : BuildResultEditorMessages.ReleaseSection_ERROR_LABEL;
                    ReleaseSection.this.fReleaseLabel = toolkit.createLabel(ReleaseSection.this.fReleaseComposite, label);
                    ReleaseSection.this.fReleaseComposite.pack(true);
                }
            }
        });
    }

    protected void fetchRelease(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = this.getTeamRepository();
        ITeamAreaHandle teamAreaHandle = this.getBuildResultRecord().getBuildDefinition().getTeamArea();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ITeamArea teamArea = (ITeamArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)teamAreaHandle, 0, (IProgressMonitor)subMonitor.newChild(1));
        this.fReleaseProjectArea = teamArea.getProjectArea();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        final List deliverables = workItemClient.findDeliverablesByArtifact((IItemHandle)this.getBuildResult(), IDeliverable.FULL_PROFILE, (IProgressMonitor)subMonitor.newChild(1));
        if (deliverables.size() > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ReleaseSection.this.handleAsyncReleaseFound((IDeliverable)deliverables.get(0));
                }
            });
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ReleaseSection.this.handleAsyncReleaseNotFound();
                }
            });
        }
    }

    private void createReleaseInBackground() {
        this.fReleaseLabel.dispose();
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.fReleaseLabel = toolkit.createLabel(this.fReleaseComposite, BuildResultEditorMessages.ReleaseSection_CREATING_RELEASE);
        this.fReleaseComposite.pack(true);
        String jobName = NLS.bind((String)BuildResultEditorMessages.ReleaseSection_CREATING_RELEASE_JOB, (Object)this.getBuildResult().getLabel());
        this.fCreateReleaseJob = new TeamBuildJob(jobName, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ReleaseSection.this.createRelease(monitor);
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getSeverity() == 4) {
                    ReleaseSection.this.handleFetchError(status, this.isExpectedStatus(status));
                }
            }
        };
        this.fCreateReleaseJob.schedule();
    }

    protected void createRelease(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = this.getTeamRepository();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        ITeamAreaHandle teamAreaHandle = this.getBuildResultRecord().getBuildDefinition().getTeamArea();
        ITeamArea teamArea = (ITeamArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)teamAreaHandle, 0, (IProgressMonitor)subMonitor.newChild(1));
        this.fReleaseProjectArea = teamArea.getProjectArea();
        final IDeliverable deliverable = workItemClient.createDeliverable(this.fReleaseProjectArea, this.fCreateReleaseDialog.getReleaseName(), (IProgressMonitor)subMonitor.newChild(1));
        deliverable.setArtifact((IItemHandle)this.getBuildResult());
        deliverable.setCreationDate(new Timestamp(System.currentTimeMillis()));
        deliverable.setName(this.fCreateReleaseDialog.getReleaseName());
        deliverable.setHTMLDescription(XMLString.createFromPlainText((String)NLS.bind((String)BuildResultEditorMessages.ReleaseSection_RELEASE_DESCRIPTION, (Object)this.getBuildResultRecord().getBuildDefinition().getId(), (Object)this.getBuildResult().getLabel())));
        deliverable.setFiltered(this.fCreateReleaseDialog.isReleasePrivate());
        workItemClient.saveDeliverable(deliverable, (IProgressMonitor)subMonitor.newChild(1));
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ReleaseSection.this.handleAsyncReleaseFound(deliverable);
            }
        });
    }

    protected void handleAsyncReleaseFound(IDeliverable deliverable) {
        if (!this.fReleaseComposite.isDisposed()) {
            this.fReleaseLabel.dispose();
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            String hyperlinkText = null;
            hyperlinkText = deliverable.isArchived() ? NLS.bind((String)BuildResultEditorMessages.ReleaseSection_RELEASE_LINK_ARCHIVED, (Object)deliverable.getName()) : NLS.bind((String)BuildResultEditorMessages.ReleaseSection_RELEASE_LINK, (Object)deliverable.getName());
            this.fReleaseHyperlink = toolkit.createImageHyperlink(this.fReleaseComposite, 0);
            this.fReleaseHyperlink.setText(hyperlinkText);
            this.fReleaseHyperlink.setImage(BuildUIPlugin.getImage("icons/obj16/release.gif"));
            this.fReleaseHyperlink.addHyperlinkListener(this.getReleaseBrowseHyperlinkListener());
            this.fReleaseHyperlink.setToolTipText(BuildResultEditorMessages.ReleaseSection_LINK_TOOLTIP);
            this.fReleaseComposite.pack(true);
        }
    }

    protected void handleAsyncReleaseNotFound() {
        if (!this.fReleaseComposite.isDisposed()) {
            this.fReleaseLabel.dispose();
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            this.fReleaseHyperlink = toolkit.createImageHyperlink(this.fReleaseComposite, 0);
            this.fReleaseHyperlink.setText(BuildResultEditorMessages.ReleaseSection_CREATE_RELEASE_LINK);
            this.fReleaseHyperlink.setImage(BuildUIPlugin.getImage("icons/elcl16/crt_release.gif"));
            this.fReleaseHyperlink.addHyperlinkListener(this.getReleaseCreationHyperlinkListener());
            this.fReleaseComposite.pack(true);
        }
    }

    protected IHyperlinkListener getReleaseBrowseHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                EditorUtilities.openProjectAreaEditor((IWorkbenchPage)page, (IProjectAreaHandle)ReleaseSection.this.fReleaseProjectArea, (String)ReleaseSection.RELEASE_PAGE_ID);
            }
        };
    }

    protected IHyperlinkListener getReleaseCreationHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                ReleaseSection.this.handleReleaseCreationHyperlinkActivated();
            }
        };
    }

    private void handleReleaseCreationHyperlinkActivated() {
        this.fCreateReleaseDialog = this.getReleaseDialog();
        if (this.fCreateReleaseDialog.open() == 0) {
            this.fShouldCreateRelease = true;
            this.fReleaseHyperlink.dispose();
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            this.fReleaseLabel = toolkit.createLabel(this.fReleaseComposite, NLS.bind((String)BuildResultEditorMessages.ReleaseSection_RELEASE_LINK, (Object)this.fCreateReleaseDialog.getReleaseName()));
            this.fReleaseComposite.pack(true);
            this.fGeneralInfoSection.setDeletionAllowed(false);
            String tag = this.fCreateReleaseDialog.getBuildTag();
            if (tag.trim().length() > 0) {
                String tags = this.fGeneralInfoSection.getTags();
                tags = String.valueOf(tags) + " " + tag;
                this.fGeneralInfoSection.setTags(tags);
            }
            this.fSummaryPage.setDirtyFlag();
        }
    }

    protected CreateReleaseDialog getReleaseDialog() {
        return new CreateReleaseDialog(this.fReleaseComposite.getShell(), this.getBuildResult().getLabel());
    }
}

