/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.summary;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.actions.EditBuildDefinitionActionDelegate;
import com.ibm.team.build.internal.ui.actions.EditBuildEngineActionDelegate;
import com.ibm.team.build.internal.ui.editors.result.BuildDefinitionHistoryHyperlinkListener;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.summary.AbstractSummarySectionContent;
import com.ibm.team.build.internal.ui.editors.result.summary.BuildResultSummaryPage;
import com.ibm.team.build.internal.ui.helper.BuildResultTextHelper;
import com.ibm.team.build.internal.ui.helper.ContributorHelper;
import com.ibm.team.build.internal.ui.helper.StringFormatHelper;
import com.ibm.team.build.internal.ui.tags.TagContentProposalProvider;
import com.ibm.team.build.internal.ui.tags.TagsField;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class GeneralInfoSummarySection
extends AbstractSummarySectionContent {
    private Composite fComposite;
    private Hyperlink fDefinitionHyperlink;
    private Hyperlink fEngineHyperlink;
    private Hyperlink fBuildHistoryHyperlink;
    private Button fDeletionAllowedButton;
    private BuildResultSummaryPage fSummaryPage;
    private TagsField fTagsField;
    private TagContentProposalProvider fTagContentProposalProvider;
    protected boolean fIsTagModified;
    private Text fTagsText;

    public GeneralInfoSummarySection(BuildResultSummaryPage summaryPage, IBuildResultRecord buildResultRecord, FormToolkit formToolkit, IEditorSite editorSite, ITeamRepository repository, IManagedForm managedForm) {
        this.fSummaryPage = summaryPage;
        this.setFormToolkit(formToolkit);
        this.setEditorSite(editorSite);
        this.setBuildResultRecord(buildResultRecord);
        this.setManagedForm(managedForm);
        this.setTeamRepository(repository);
    }

    public void createContents(Section section) {
        FormToolkit toolkit = this.getFormToolkit();
        section.setText(BuildResultEditorMessages.GeneralInfoSummarySection_SECTION_TITLE);
        this.fComposite = toolkit.createComposite((Composite)section);
        this.fComposite.setLayout((Layout)new GridLayout(2, false));
        this.fComposite.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)this.fComposite);
        toolkit.createLabel(this.fComposite, BuildResultEditorMessages.GeneralInfoSummarySection_REQUESTED_BY_TEXT_LABEL);
        Label label = toolkit.createLabel(this.fComposite, this.getRequestor());
        label.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(this.fComposite, BuildResultEditorMessages.GeneralInfoSummarySection_BUILD_DEFINITION_TEXT_LABEL);
        this.fDefinitionHyperlink = toolkit.createHyperlink(this.fComposite, this.getBuildResultRecord().getBuildDefinition().getId(), 0);
        this.fDefinitionHyperlink.setLayoutData((Object)new GridData(32, 4, false, true));
        this.fDefinitionHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                EditBuildDefinitionActionDelegate.run(GeneralInfoSummarySection.this.getBuildResultRecord().getBuildDefinition(), GeneralInfoSummarySection.this.getEditorSite().getPage());
            }
        });
        toolkit.createLabel(this.fComposite, BuildResultEditorMessages.GeneralInfoSummarySection_ENGINE_INTRO_TEXT);
        this.fEngineHyperlink = toolkit.createHyperlink(this.fComposite, this.getBuildEngineText(), 0);
        this.fEngineHyperlink.setLayoutData((Object)new GridData(32, 4, false, true));
        if (this.getBuildResultRecord().getBuildEngine() != null) {
            this.fEngineHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    EditBuildEngineActionDelegate.run(GeneralInfoSummarySection.this.getBuildResultRecord().getBuildEngine(), GeneralInfoSummarySection.this.getEditorSite().getPage());
                }
            });
        } else {
            this.fEngineHyperlink.setForeground(this.fComposite.getShell().getDisplay().getSystemColor(2));
            this.fEngineHyperlink.setUnderlined(false);
            this.fEngineHyperlink.setEnabled(false);
        }
        int count = this.getBuildResultRecord().getBuildCount();
        if (count > 1) {
            toolkit.createLabel(this.fComposite, BuildResultEditorMessages.GeneralInfoSummarySection_BUILD_HISTORY_LABEL);
            this.fBuildHistoryHyperlink = toolkit.createHyperlink(this.fComposite, NLS.bind((String)BuildResultEditorMessages.GeneralInfoSummarySection_HISTORY_LINK_TEXT, (Object)count), 0);
            this.fBuildHistoryHyperlink.setLayoutData((Object)new GridData(32, 4, false, true));
            this.fBuildHistoryHyperlink.addHyperlinkListener((IHyperlinkListener)new BuildDefinitionHistoryHyperlinkListener(this.getBuildResultRecord().getBuildDefinition().getId(), (IBuildDefinitionHandle)this.getBuildResultRecord().getBuildDefinition(), this.getTeamRepository(), this.getEditorSite().getPage()));
        }
        this.fTagsText = this.createTagsField(this.fComposite, toolkit);
        this.fDeletionAllowedButton = toolkit.createButton(this.fComposite, BuildResultEditorMessages.GeneralInfoSummarySection_DELETION_ALLOWED_CHECKBOX_LABEL, 32);
        this.fDeletionAllowedButton.setToolTipText(BuildResultEditorMessages.GeneralInfoSummarySection_DELETION_ALLOWED_CHECKBOX_TOOLTIP);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.fDeletionAllowedButton.setLayoutData((Object)data);
        this.fDeletionAllowedButton.setSelection(this.getBuildResultRecord().getBuildResult().isDeleteAllowed());
        this.fDeletionAllowedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBuildResult buildResult = GeneralInfoSummarySection.this.fSummaryPage.getBuildResultWorkingCopy();
                buildResult.setDeleteAllowed(GeneralInfoSummarySection.this.fDeletionAllowedButton.getSelection());
                GeneralInfoSummarySection.this.fSummaryPage.setDirtyFlag();
            }
        });
    }

    protected void setDeletionAllowed(boolean isAllowed) {
        IBuildResult buildResult = this.fSummaryPage.getBuildResultWorkingCopy();
        buildResult.setDeleteAllowed(isAllowed);
        this.fSummaryPage.setDirtyFlag();
        this.getDeletionAllowedButton().setSelection(isAllowed);
    }

    protected String getTags() {
        return this.fSummaryPage.getBuildResultWorkingCopy().getTags().trim();
    }

    protected void setTags(String tags) {
        IBuildResult buildResult = this.fSummaryPage.getBuildResultWorkingCopy();
        buildResult.setTags(tags.trim());
        this.fTagsText.setText(tags.trim());
        this.fIsTagModified = true;
        this.fSummaryPage.setDirtyFlag();
    }

    protected String getRequestor() {
        String requestor = BuildResultEditorMessages.GeneralInfoSummarySection_UNKNOWN;
        if (this.getBuildResultRecord().isScheduledBuild()) {
            requestor = BuildResultTextHelper.getScheduledBuildRequestorText();
        } else {
            IContributor contributor = this.getBuildResultRecord().getRequestor();
            if (contributor != null) {
                requestor = ContributorHelper.getContributorLabelText(contributor);
            }
        }
        return requestor;
    }

    protected String getBuildEngineText() {
        IBuildEngine engine = this.getBuildResultRecord().getBuildEngine();
        if (engine != null) {
            return engine.getId();
        }
        return BuildResultEditorMessages.GeneralInfoSummarySection_NO_BUILD_ENGINE;
    }

    public void dispose() {
        if (this.fTagsField != null) {
            this.fTagsField.dispose();
        }
    }

    protected String getAppropriateLengthString(String stringToTruncate, Control fontSupplier, int maxLengthInPixels) {
        if (this.getComposite().isDisposed()) {
            return stringToTruncate;
        }
        if (fontSupplier == null || fontSupplier.isDisposed()) {
            fontSupplier = this.getComposite();
        }
        return StringFormatHelper.truncateString(stringToTruncate, fontSupplier, maxLengthInPixels);
    }

    protected Text createTagsField(Composite parent, FormToolkit toolkit) {
        Label label = toolkit.createLabel(parent, BuildResultEditorMessages.GeneralInfoSummarySection_TAGS_LABEL);
        label.setLayoutData((Object)new GridData(16384, 1, false, false));
        Text tagsText = toolkit.createText(parent, this.getBuildResult().getTags());
        tagsText.setLayoutData((Object)new GridData(4, 4, true, true));
        tagsText.addModifyListener(this.createTagsTextModifyListener(tagsText));
        this.setTagContentProposalProvider(this.createTagContentProposalProvider());
        this.setTagsField(new TagsField(tagsText, this.fTagContentProposalProvider));
        return tagsText;
    }

    protected TagContentProposalProvider createTagContentProposalProvider() {
        return new TagContentProposalProvider(this.getTeamRepository(), this.getBuildResultRecord().getProjectArea());
    }

    protected ModifyListener createTagsTextModifyListener(final Text tagsText) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildResult buildResult = GeneralInfoSummarySection.this.fSummaryPage.getBuildResultWorkingCopy();
                buildResult.setTags(tagsText.getText().trim());
                GeneralInfoSummarySection.this.fIsTagModified = true;
                GeneralInfoSummarySection.this.fSummaryPage.setDirtyFlag();
            }
        };
    }

    protected Hyperlink getBuildEngineHyperlink() {
        return this.fEngineHyperlink;
    }

    protected Hyperlink getBuildHistoryHyperlink() {
        return this.fBuildHistoryHyperlink;
    }

    protected Button getDeletionAllowedButton() {
        return this.fDeletionAllowedButton;
    }

    public Composite getComposite() {
        return this.fComposite;
    }

    protected TagsField getTagsField() {
        return this.fTagsField;
    }

    protected void setTagsField(TagsField tagsField) {
        this.fTagsField = tagsField;
    }

    public boolean validate() {
        return this.validateTags();
    }

    private boolean validateTags() {
        String message;
        if (this.fTagContentProposalProvider == null || !this.fIsTagModified) {
            return true;
        }
        String[] newTags = this.fTagContentProposalProvider.getNewTags(this.fSummaryPage.getBuildResultWorkingCopy().getTags());
        if (newTags.length == 0) {
            return true;
        }
        if (newTags.length == 1) {
            message = NLS.bind((String)BuildResultEditorMessages.GeneralInfoSummarySection_CREATE_ONE_TAG_PROMPT, (Object)newTags[0]);
        } else {
            StringBuffer tags = new StringBuffer();
            String[] stringArray = newTags;
            int n = newTags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                tags.append(NLS.bind((String)BuildResultEditorMessages.GeneralInfoSummarySection_TAG_SUBSTRING, (Object)tag, (Object)" "));
                ++n2;
            }
            tags = tags.delete(tags.length() - 2, tags.length());
            message = NLS.bind((String)BuildResultEditorMessages.GeneralInfoSummarySection_CREATE_MULTIPLE_TAGS_PROMPT, (Object)tags);
        }
        return this.showMessageDialog(this.getEditorSite().getShell(), message) == 0;
    }

    protected int showMessageDialog(Shell shell, String message) {
        MessageDialog md = new MessageDialog(shell, BuildResultEditorMessages.GeneralInfoSummarySection_TAG_DIALOG_TITLE, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
        return md.open();
    }

    protected boolean isTagModified() {
        return this.fIsTagModified;
    }

    protected void setTagContentProposalProvider(TagContentProposalProvider tagContentProposalProvider) {
        this.fTagContentProposalProvider = tagContentProposalProvider;
    }

    protected void handleWorkingCopyUpdated() {
        this.addNewTagsIfNecessary();
    }

    protected void addNewTagsIfNecessary() {
        if (this.fTagContentProposalProvider != null) {
            String[] tags = this.fTagContentProposalProvider.getNewTags(this.fSummaryPage.getBuildResultWorkingCopy().getTags());
            this.fTagContentProposalProvider.addTags(tags);
        }
    }
}

