/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.summary;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.summary.ISummaryItemListener;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ContributionSummaryItem {
    private FormToolkit fToolkit;
    protected Composite fSummaryContainer;
    protected Label fImageLabel;
    protected Label fTitleLabel;
    protected Hyperlink fSummaryTextHyperlink;
    private Color fOriginalHyperlinkColor;
    private ISummaryItemListener fSummaryItemListener;
    private boolean fIsExpected;
    private AbstractBuildResultContributionProvider fProvider;
    static int fImageWidthHint = BuildUIPlugin.getImage((String)"icons/obj16/success_ovr.gif").getBounds().width + 1;

    public ContributionSummaryItem(Composite parent, FormToolkit toolkit, AbstractBuildResultContributionProvider provider, boolean expected, ISummaryItemListener listener) {
        this.fToolkit = toolkit;
        this.fProvider = provider;
        this.fSummaryContainer = parent;
        this.fIsExpected = expected;
        this.fSummaryItemListener = listener;
    }

    public String getTitle() {
        return this.fProvider.getSummaryTitle();
    }

    public AbstractBuildResultContributionProvider getProvider() {
        return this.fProvider;
    }

    protected void createContents() {
        if (this.fSummaryContainer == null || this.fSummaryContainer.isDisposed()) {
            return;
        }
        if (this.fIsExpected) {
            this.createSummaryItemContents();
        } else {
            Runnable createSummaryItemContentsRunnable = new Runnable(){

                public void run() {
                    if (ContributionSummaryItem.this.fProvider.isContributionPresent() && !ContributionSummaryItem.this.fProvider.shouldHideSummary()) {
                        ContributionSummaryItem.this.createSummaryItemContents();
                    } else {
                        ContributionSummaryItem.this.fSummaryItemListener.summaryItemDone();
                    }
                }
            };
            this.runAfterProviderInitialization(createSummaryItemContentsRunnable, BuildResultEditorMessages.ContributionSummaryItem_CREATE_ASYNC_CONTRIBUTION_ITEM_JOB_TITLE);
        }
    }

    protected void createSummaryItemContents() {
        this.fTitleLabel = this.fToolkit.createLabel(this.fSummaryContainer, this.getTitle());
        this.fImageLabel = this.fToolkit.createLabel(this.fSummaryContainer, "");
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 0x1000008;
        layoutData.widthHint = fImageWidthHint;
        this.fImageLabel.setLayoutData((Object)layoutData);
        this.fSummaryTextHyperlink = this.fToolkit.createHyperlink(this.fSummaryContainer, "", 0);
        this.fSummaryTextHyperlink.setLayoutData((Object)new GridData(32, 4, false, true));
        this.fSummaryItemListener.summaryItemDone();
        if (this.fProvider.isInitialized()) {
            this.addSummaryText();
        } else {
            this.setSummaryLabelText(BuildResultEditorMessages.BuildResultSummaryPage_PENDING_LABEL);
            Runnable addSummaryTextRunnable = new Runnable(){

                public void run() {
                    ContributionSummaryItem.this.addSummaryText();
                }
            };
            this.runAfterProviderInitialization(addSummaryTextRunnable, BuildResultEditorMessages.ContributionSummaryItem_UPDATE_SUMMARY_JOB_TITLE);
        }
    }

    protected void runAfterProviderInitialization(final Runnable runnable, String description) {
        if (this.fProvider.isInitialized()) {
            runnable.run();
            return;
        }
        TeamBuildJob job = new TeamBuildJob(description, false){

            protected IStatus runProtected(IProgressMonitor monitor) {
                ContributionSummaryItem.this.fProvider.waitForInitialization();
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (!(this).ContributionSummaryItem.this.fSummaryContainer.isDisposed()) {
                            runnable.run();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void setSummaryHyperlinkText(String text) {
        if (!this.fSummaryTextHyperlink.isEnabled()) {
            this.fSummaryTextHyperlink.setEnabled(true);
            this.fSummaryTextHyperlink.setUnderlined(true);
            this.fSummaryTextHyperlink.setForeground(this.fOriginalHyperlinkColor);
        }
        this.fSummaryTextHyperlink.setText(text);
    }

    protected void setSummaryLabelText(String text) {
        if (this.fSummaryTextHyperlink.isEnabled()) {
            this.fOriginalHyperlinkColor = this.fSummaryTextHyperlink.getForeground();
            this.fSummaryTextHyperlink.setForeground(this.fTitleLabel.getForeground());
            this.fSummaryTextHyperlink.setEnabled(false);
            this.fSummaryTextHyperlink.setUnderlined(false);
        }
        this.fSummaryTextHyperlink.setText(text);
    }

    protected void addSummaryText() {
        if (!this.fProvider.initializationSucceeded()) {
            Exception exception = this.fProvider.getInitializationError();
            if (TeamBuildJobHelper.isExpectedException(exception)) {
                this.setSummaryLabelText(NLS.bind((String)BuildResultEditorMessages.ContributionSummaryItem_CONTRIBUTION_PROVIDER_ERROR, (Object)TeamBuildJobHelper.getStatusMessage(exception)));
            } else {
                this.setSummaryLabelText(BuildResultEditorMessages.ContributionSummaryItem_CONTRIBUTION_PROVIDER_UNEXPECTED_ERROR);
            }
        } else {
            Image image = this.getStatusImage();
            if (image != null) {
                this.fImageLabel.setImage(image);
                ((GridData)this.fImageLabel.getLayoutData()).widthHint = image.getBounds().width;
            }
            if (this.fIsExpected && !this.fProvider.isContributionPresent()) {
                this.setSummaryLabelText(BuildResultEditorMessages.ContributionSummaryItem_MISSING_CONTRIBUTION);
            } else if (this.fProvider.isSummaryLink()) {
                this.setSummaryHyperlinkText(this.fProvider.getSummaryText());
                this.fSummaryTextHyperlink.addHyperlinkListener(this.getHyperlinkListener());
            } else {
                this.setSummaryLabelText(this.fProvider.getSummaryText());
            }
        }
    }

    protected IHyperlinkListener getHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ContributionSummaryItem.this.fProvider.summaryLinkActivated();
            }
        };
    }

    private Image getStatusImage() {
        if (this.fIsExpected && !this.fProvider.isContributionPresent()) {
            return BuildUIPlugin.getImage("icons/obj16/no_result.gif");
        }
        BuildStatus status = this.fProvider.getStatus();
        if (status == null) {
            BuildUIPlugin.log(NLS.bind((String)BuildResultEditorMessages.ContributionSummaryItem_NULL_CONTRIBUTION_STATUS_ERROR, (Object)this.fProvider.getSummaryText()));
            return null;
        }
        switch (status) {
            case OK: {
                return BuildUIPlugin.getImage("icons/ovr16/success_ovr.gif");
            }
            case WARNING: {
                return BuildUIPlugin.getImage("icons/ovr16/warn_ovr.gif");
            }
            case ERROR: {
                return BuildUIPlugin.getImage("icons/ovr16/failed_ovr.gif");
            }
            case INFO: {
                return null;
            }
        }
        return null;
    }
}

