/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.summary;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.helper.BuildActivityHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildResultStatusRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildResultStatusTrend;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.helper.BuildResultTimeHelper;
import com.ibm.team.build.internal.ui.helper.StringFormatHelper;
import com.ibm.team.build.ui.BuildUI;
import com.ibm.team.jface.ColorUtils;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import java.util.Collection;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BuildStatusSection {
    private LocalResourceManager fResourceManager;
    protected IBuildResultRecord fBuildResultRecord;
    protected IBuildResultStatusTrend fBuildStatusTrend;
    protected IWorkbenchPage fWorkbenchPage;
    private Color fSectionForeground;
    private Color fSectionBackground;

    public BuildStatusSection(IBuildResultRecord record, IBuildResultStatusTrend trend, IWorkbenchPage workbenchPage) {
        this.fBuildResultRecord = record;
        this.fBuildStatusTrend = trend;
        this.fWorkbenchPage = workbenchPage;
    }

    public Composite createContent(Composite parent, FormToolkit formToolkit) {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        final Composite content = formToolkit.createComposite(parent);
        content.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        this.fSectionBackground = this.getBackgroundColor(this.getBuildResult());
        final Color sectionBorder = this.getBorderColor(this.getBuildResult());
        content.setBackground(this.fSectionBackground);
        Composite headerComposite = formToolkit.createComposite(content);
        headerComposite.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(3, false);
        headerComposite.setLayout((Layout)gridLayout);
        headerComposite.setBackground(this.fSectionBackground);
        Image image = this.getStatusImage(this.getBuildResult());
        Label label = new Label(headerComposite, 0);
        label.setBackground(this.fSectionBackground);
        label.setImage(image);
        this.fSectionForeground = this.getStatusHeaderForeground(this.getBuildResult());
        Label headerLabel = formToolkit.createLabel(headerComposite, this.getStatusHeaderText(this.getBuildResult()));
        headerLabel.setForeground(this.fSectionForeground);
        headerLabel.setBackground(this.fSectionBackground);
        headerLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        if (this.getBuildResult().getState() == BuildState.IN_PROGRESS) {
            String progressPercentString = BuildResultTimeHelper.getProgressPercentString(this.getBuildResult(), this.fBuildResultRecord);
            if (!progressPercentString.equals("")) {
                this.createTitleLabel(headerComposite, formToolkit, progressPercentString);
            } else {
                GridData layoutData = new GridData();
                layoutData.horizontalSpan = 2;
                headerLabel.setLayoutData((Object)layoutData);
            }
        } else {
            GridData layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            headerLabel.setLayoutData((Object)layoutData);
        }
        Composite infoComposite = formToolkit.createComposite(content);
        infoComposite.setLayoutData((Object)new GridData(768));
        infoComposite.setLayout((Layout)new GridLayout(2, false));
        infoComposite.setBackground(this.fSectionBackground);
        if (this.getBuildResult().getState() == BuildState.IN_PROGRESS) {
            String estimatedCompletion;
            String currentActivity = BuildActivityHelper.getCurrentActivityText((Collection)this.fBuildResultRecord.getCurrentBuildActivities());
            if (currentActivity != null && !currentActivity.equals("")) {
                this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_ACTIVITY_MESSAGE);
                label = formToolkit.createLabel(infoComposite, currentActivity, 64);
                label.setBackground(this.fSectionBackground);
                GridData layoutData = new GridData();
                layoutData.widthHint = this.getActivityWidthHint(currentActivity, (Control)label);
                label.setLayoutData((Object)layoutData);
            }
            if (!(estimatedCompletion = BuildResultTimeHelper.getEstimatedCompletionTimeString(this.getBuildResult(), this.fBuildResultRecord)).equals("")) {
                this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_ESTIMATED_COMPLETION);
                label = formToolkit.createLabel(infoComposite, estimatedCompletion);
                label.setBackground(this.fSectionBackground);
            }
            this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_LAST_UPDATE);
            label = formToolkit.createLabel(infoComposite, BuildResultTimeHelper.getLastUpdateTimeString(this.fBuildResultRecord));
            label.setBackground(this.fSectionBackground);
        }
        this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_DURATION);
        label = formToolkit.createLabel(infoComposite, BuildResultTimeHelper.getDurationString(this.getBuildResult()));
        label.setBackground(this.fSectionBackground);
        this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_STARTED_AT);
        label = formToolkit.createLabel(infoComposite, BuildResultTimeHelper.getStartTimeString(this.getBuildResult()));
        label.setBackground(this.fSectionBackground);
        if (this.getBuildResult().getState() != BuildState.IN_PROGRESS) {
            if (this.getBuildResult().getState() == BuildState.INCOMPLETE) {
                String abandonerName = BuildResultEditorMessages.StatusSection_UNKNOWN_ABANDONER;
                IContributor abandoner = this.fBuildResultRecord.getAbandoner();
                if (abandoner != null) {
                    abandonerName = abandoner.getName();
                }
                this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_ABANDONED_BY);
                label = formToolkit.createLabel(infoComposite, NLS.bind((String)BuildResultEditorMessages.StatusSection_ABANDONED_AT, (Object)abandonerName, (Object)BuildResultTimeHelper.getCompletedTime(this.getBuildResult())));
                label.setBackground(this.fSectionBackground);
            } else {
                this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_COMPLETED_AT);
                label = formToolkit.createLabel(infoComposite, BuildResultTimeHelper.getCompletedTime(this.getBuildResult()));
                label.setBackground(this.fSectionBackground);
            }
        }
        Composite statusTrendComposite = formToolkit.createComposite(content);
        statusTrendComposite.setLayoutData((Object)new GridData(768));
        statusTrendComposite.setLayout((Layout)new GridLayout(1, false));
        statusTrendComposite.setBackground(this.fSectionBackground);
        if (this.fBuildStatusTrend.getPreviousBuilds().length > 0 || this.fBuildStatusTrend.getNextBuilds().length > 0) {
            this.createStatusTrendBar(statusTrendComposite, formToolkit, this.fSectionBackground);
        }
        content.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                gc.setForeground(sectionBorder);
                Rectangle rect = content.getClientArea();
                gc.drawRoundRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1, 6, 6);
            }
        });
        return content;
    }

    private void createTitleLabel(Composite parent, FormToolkit formToolkit, String text) {
        Label label = formToolkit.createLabel(parent, text);
        label.setBackground(this.fSectionBackground);
    }

    private String getStatusHeaderText(IBuildResult buildResult) {
        String text = null;
        if (buildResult.getState() == BuildState.COMPLETED) {
            text = BuildResultEditorMessages.StatusSection_COMPLETED_TITLE;
        } else if (buildResult.getState() == BuildState.IN_PROGRESS) {
            text = BuildResultEditorMessages.StatusSection_IN_PROGRESS_TITLE;
        } else if (buildResult.getState() == BuildState.INCOMPLETE) {
            text = BuildResultEditorMessages.StatusSection_ABANDONED_TITLE;
        }
        return text;
    }

    private Color getStatusHeaderForeground(IBuildResult buildResult) {
        Color foreground = Display.getDefault().getSystemColor(6);
        if (buildResult.getState() == BuildState.INCOMPLETE) {
            foreground = Display.getDefault().getSystemColor(16);
        } else if (buildResult.getStatus() == BuildStatus.ERROR) {
            foreground = Display.getDefault().getSystemColor(3);
        } else if (buildResult.getStatus() == BuildStatus.WARNING) {
            foreground = Display.getDefault().getSystemColor(8);
        }
        return foreground;
    }

    private Image getStatusImage(IBuildResult buildResult) {
        Image image = BuildUIPlugin.getImage("icons/obj16/completedblds_obj.gif");
        if (buildResult.getState() == BuildState.INCOMPLETE) {
            image = BuildUIPlugin.getImage("icons/obj16/abanblds_obj.gif");
        } else if (buildResult.getStatus() == BuildStatus.ERROR) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            image = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
        } else if (buildResult.getStatus() == BuildStatus.WARNING) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            image = sharedImages.getImage("IMG_OBJS_WARN_TSK");
        }
        return image;
    }

    private Color getBorderColor(IBuildResult buildResult) {
        RGB blend = ColorUtils.addColor((RGB)Display.getDefault().getSystemColor(6).getRGB(), (float)70.0f);
        if (buildResult.getState() == BuildState.INCOMPLETE) {
            blend = ColorUtils.addColor((RGB)Display.getDefault().getSystemColor(16).getRGB(), (float)70.0f);
        } else if (buildResult.getStatus() == BuildStatus.ERROR) {
            blend = ColorUtils.addColor((RGB)Display.getDefault().getSystemColor(3).getRGB(), (float)70.0f);
        } else if (buildResult.getStatus() == BuildStatus.WARNING) {
            blend = ColorUtils.addColor((RGB)Display.getDefault().getSystemColor(8).getRGB(), (float)70.0f);
        }
        return JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)blend);
    }

    private void createStatusTrendBar(Composite parent, FormToolkit toolkit, Color background) {
        Composite trendBarContainer = toolkit.createComposite(parent);
        trendBarContainer.setLayoutData((Object)new GridData());
        trendBarContainer.setBackground(background);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        trendBarContainer.setLayout((Layout)gridLayout);
        this.createTitleLabel(trendBarContainer, toolkit, BuildResultEditorMessages.StatusSection_STATUS_TREND);
        Composite trendBar = toolkit.createComposite(trendBarContainer, 0);
        GridData layoutData = new GridData();
        trendBar.setLayoutData((Object)layoutData);
        trendBar.setBackground(background);
        RowLayout layout = new RowLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        trendBar.setLayout((Layout)layout);
        IBuildResultStatusRecord[] previousBuilds = this.fBuildStatusTrend.getPreviousBuilds();
        int i = 0;
        while (i < previousBuilds.length) {
            this.createTrendBarItem(trendBar, toolkit, previousBuilds[i].getBuildResult(), previousBuilds[i].getStatus(), previousBuilds[i].getState(), false);
            ++i;
        }
        this.createTrendBarItem(trendBar, toolkit, (IBuildResultHandle)this.getBuildResult(), this.getBuildResult().getStatus(), this.getBuildResult().getState(), true);
        IBuildResultStatusRecord[] nextBuilds = this.fBuildStatusTrend.getNextBuilds();
        int i2 = 0;
        while (i2 < nextBuilds.length) {
            this.createTrendBarItem(trendBar, toolkit, nextBuilds[i2].getBuildResult(), nextBuilds[i2].getStatus(), nextBuilds[i2].getState(), false);
            ++i2;
        }
    }

    private void createTrendBarItem(Composite parent, FormToolkit toolkit, IBuildResultHandle buildResultHandle, BuildStatus buildStatus, BuildState buildState, boolean selected) {
        Label label = toolkit.createLabel(parent, "");
        final Image image = this.getStatusTrendItemImage(buildStatus, buildState, selected);
        label.setImage(image);
        if (!buildResultHandle.getItemId().equals((Object)this.getBuildResult().getItemId())) {
            this.addMouseListener(label, buildResultHandle);
        }
        this.getTooltipSupport(label, buildResultHandle);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                image.dispose();
            }
        });
    }

    protected TooltipSupport getTooltipSupport(Label label, final IBuildResultHandle buildResultHandle) {
        return new TooltipSupport((Control)label, true, true, true){

            public Object getElement(Control control, int x, int y) {
                return buildResultHandle;
            }
        };
    }

    private void addMouseListener(Label label, IBuildResultHandle buildResultHandle) {
        final Cursor cursor = new Cursor((Device)Display.getDefault(), 21);
        label.setCursor(cursor);
        label.addMouseListener(this.getMouseListener(buildResultHandle));
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
    }

    protected MouseListener getMouseListener(final IBuildResultHandle buildResultHandle) {
        return new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                BuildUI.getDefault().open(buildResultHandle, (ITeamRepository)buildResultHandle.getOrigin(), BuildStatusSection.this.fWorkbenchPage);
            }
        };
    }

    private int getActivityWidthHint(String currentActivity, Control fontSupplier) {
        int width = StringFormatHelper.getWidth(currentActivity, fontSupplier) + 5;
        if (width > 400) {
            width = 400;
        }
        return width;
    }

    private Color getBackgroundColor(IBuildResult buildResult) {
        RGB blend = ColorUtils.addColor((RGB)Display.getDefault().getSystemColor(6).getRGB(), (float)90.0f);
        if (buildResult.getState() == BuildState.INCOMPLETE) {
            blend = ColorUtils.addColor((RGB)Display.getDefault().getSystemColor(16).getRGB(), (float)90.0f);
        } else if (buildResult.getStatus() == BuildStatus.ERROR) {
            blend = ColorUtils.addColor((RGB)Display.getDefault().getSystemColor(3).getRGB(), (float)90.0f);
        } else if (buildResult.getStatus() == BuildStatus.WARNING) {
            blend = ColorUtils.addColor((RGB)Display.getDefault().getSystemColor(7).getRGB(), (float)85.0f);
        }
        return JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)blend);
    }

    private Image getStatusTrendItemImage(BuildStatus buildStatus, BuildState buildState, boolean selected) {
        Color baseColor = Display.getDefault().getSystemColor(6);
        if (buildState == BuildState.INCOMPLETE) {
            baseColor = Display.getDefault().getSystemColor(16);
        } else if (buildStatus == BuildStatus.ERROR) {
            baseColor = Display.getDefault().getSystemColor(3);
        } else if (buildStatus == BuildStatus.WARNING) {
            baseColor = Display.getDefault().getSystemColor(8);
        }
        RGB blend = ColorUtils.addColor((RGB)baseColor.getRGB(), (float)50.0f);
        Color fillColor = JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)blend);
        blend = ColorUtils.addColor((RGB)baseColor.getRGB(), (float)40.0f);
        Color borderColor = JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)blend);
        Color backgroundColor = this.getBackgroundColor(this.getBuildResult());
        Image image = new Image((Device)Display.getDefault(), 11, 26);
        GC gc = new GC((Drawable)image);
        Rectangle bounds = image.getBounds();
        gc.setBackground(backgroundColor);
        gc.fillRectangle(bounds);
        gc.setBackground(fillColor);
        gc.fillRectangle(bounds.x, bounds.y + 4, bounds.width - 1, bounds.height - 9);
        gc.setForeground(borderColor);
        gc.drawRectangle(bounds.x, bounds.y + 4, bounds.width - 1, bounds.height - 9);
        if (selected) {
            gc.setForeground(Display.getDefault().getSystemColor(16));
            gc.drawLine(2, 0, 8, 0);
            gc.drawLine(3, 1, 7, 1);
            gc.drawLine(4, 2, 6, 2);
            gc.drawLine(5, 3, 5, 3);
            gc.drawLine(5, bounds.height - 4, 5, bounds.height - 4);
            gc.drawLine(4, bounds.height - 3, 6, bounds.height - 3);
            gc.drawLine(3, bounds.height - 2, 7, bounds.height - 2);
            gc.drawLine(2, bounds.height - 1, 8, bounds.height - 1);
        }
        gc.dispose();
        return image;
    }

    private IBuildResult getBuildResult() {
        return this.fBuildResultRecord.getBuildResult();
    }
}

