/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.properties;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.properties.BuildPropertiesPage;
import com.ibm.team.build.internal.ui.editors.result.properties.Messages;
import com.ibm.team.build.internal.ui.helper.BuildResultTextHelper;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.forms.editor.FormEditor;

public class BuildPropertiesContributionProvider
extends AbstractBuildResultContributionProvider {
    private List fBuildProperties;

    public BuildPropertiesContributionProvider(FormEditor buildEditor, String extensionId, IBuildResultContext context) {
        super(buildEditor, extensionId, context);
    }

    public AbstractBuildResultPage getBuildResultPage() {
        return new BuildPropertiesPage(this.getBuildResultEditor(), this.getExtensionId(), Messages.BuildPropertiesContributionProvider_TAB_TEXT, this.getExtendedContributionIds(), this.getBuildResultContext(), this.fBuildProperties);
    }

    public String[] getExtendedContributionIds() {
        return new String[0];
    }

    public boolean isContributionPresent() {
        for (Object object : this.fBuildProperties) {
            IBuildProperty property = (IBuildProperty)object;
            if (!property.isGenericEditAllowed()) continue;
            return true;
        }
        return false;
    }

    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    public String getSummaryText() {
        return NLS.bind((String)Messages.BuildPropertiesContributionProvider_SUMMARY_TEXT, (Object)this.fBuildProperties.size());
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        IBuildRequest request = this.getStartRequest(this.getBuildResultContext().getBuildResultRecord().getBuildRequests());
        this.fBuildProperties = request != null ? request.getBuildDefinitionInstance().getProperties() : new ArrayList();
    }

    private IBuildRequest getStartRequest(IBuildRequest[] allRequests) {
        IBuildRequest[] iBuildRequestArray = allRequests;
        int n = allRequests.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildRequest currentRequest = iBuildRequestArray[n2];
            if (currentRequest.getBuildAction().getAction().equals("com.ibm.team.build.action.requestBuild")) {
                return currentRequest;
            }
            ++n2;
        }
        BuildUIPlugin.log(NLS.bind((String)Messages.BuildPropertiesContributionProvider_NO_REQUEST, (Object)BuildResultTextHelper.getLabel(this.getBuildResultContext().getBuildResult())));
        return null;
    }

    public String getSummaryTitle() {
        return Messages.BuildPropertiesContributionProvider_SUMMARY_TITLE;
    }

    public boolean isSummaryLink() {
        return true;
    }

    public void summaryLinkActivated() {
        this.getBuildResultEditor().setActivePage(this.getExtensionId());
    }

    public boolean shouldHideSummary() {
        return true;
    }
}

