/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.links;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.editors.result.links.LinksPage;
import com.ibm.team.build.internal.ui.editors.result.links.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.forms.editor.FormEditor;

public class LinksContributionProvider
extends AbstractBuildResultContributionProvider {
    private IBuildResultContribution[] fContributions;

    public LinksContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fContributions = this.getContributions();
    }

    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    public String getSummaryText() {
        if (this.fContributions.length > 1) {
            return NLS.bind((String)Messages.LinksContributionProvider_SUMMARY_TEXT_MULTIPLE_CONTRIBUTIONS, (Object)this.fContributions.length);
        }
        if (this.fContributions.length == 1) {
            return Messages.LinksContributionProvider_SUMMARY_TEXT_SINGLE_CONTRIBUTION;
        }
        return Messages.LinksContributionProvider_SUMMARY_TEXT_NO_CONTRIBUTIONS;
    }

    public String[] getExtendedContributionIds() {
        return new String[]{IBuildResultContribution.LINK_EXTENDED_CONTRIBUTION_ID};
    }

    public boolean isSummaryLink() {
        return this.fContributions.length > 0;
    }

    public void summaryLinkActivated() {
        this.getBuildResultEditor().setActivePage(this.getExtensionId());
    }

    public String getSummaryTitle() {
        return Messages.LinksContributionProvider_SUMMARY_TITLE;
    }

    public AbstractBuildResultPage getBuildResultPage() {
        return new LinksPage(this.getBuildResultEditor(), this.getExtensionId(), Messages.LinksContributionProvider_PAGE_TITLE, this.getExtendedContributionIds(), this.getBuildResultContext());
    }
}

