/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.junit;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.junit.JavaStackTraceHyperlinkNoConsole;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorSite;

public class JavaStackTraceHyperlinkDetector
implements IHyperlinkDetector {
    IEditorSite fEditorSite;

    public JavaStackTraceHyperlinkDetector(IEditorSite editorSite) {
        this.fEditorSite = editorSite;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null) {
            return null;
        }
        try {
            IDocument document = textViewer.getDocument();
            IRegion entireLine = document.getLineInformation(document.getLineOfOffset(region.getOffset()));
            String string = document.get(entireLine.getOffset(), entireLine.getLength());
            if (string.matches("\\sat\\s.*\\(.*\\.java\\:\\d*\\)")) {
                Region linkRegion = new Region(entireLine.getOffset() + 4, entireLine.getLength() - 4);
                string = string.substring(4);
                return new IHyperlink[]{new JavaStackTraceHyperlinkNoConsole(string, (IRegion)linkRegion, this.fEditorSite)};
            }
        }
        catch (BadLocationException exception) {
            BuildUIPlugin.log(exception);
        }
        return null;
    }
}

