/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.junit;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IJUnitTestClass;
import com.ibm.team.build.common.model.IJUnitTestSuiteContribution;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.AbstractBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.IDeferredBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.junit.IJUnitRunErrorDetailProvider;
import com.ibm.team.build.internal.ui.editors.result.junit.JUnitTestClassNode;
import com.ibm.team.build.internal.ui.helper.TimeFormatHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class JUnitTestSuiteNode
extends AbstractBuildTreeNode
implements IJUnitRunErrorDetailProvider {
    private static final List PARTIAL_TEST_CLASS_PROPERTIES = new LinkedList();
    private String fProblemString;
    private IJUnitTestSuiteContribution fTestSuiteContribution;
    private IBuildResultContribution fBuildResultContribution;

    static {
        PARTIAL_TEST_CLASS_PROPERTIES.add(IJUnitTestClass.PROPERTY_CLASS_NAME);
        PARTIAL_TEST_CLASS_PROPERTIES.add(IJUnitTestClass.PROPERTY_ERROR_COUNT);
        PARTIAL_TEST_CLASS_PROPERTIES.add(IJUnitTestClass.PROPERTY_FAILURE_COUNT);
        PARTIAL_TEST_CLASS_PROPERTIES.add(IJUnitTestClass.PROPERTY_TEST_COUNT);
        PARTIAL_TEST_CLASS_PROPERTIES.add(IJUnitTestClass.PROPERTY_TIME_TAKEN);
        PARTIAL_TEST_CLASS_PROPERTIES.add(IJUnitTestClass.PROPERTY_ORDINAL);
    }

    public JUnitTestSuiteNode(IDeferredBuildTreeNode parentNode, IBuildResultContribution buildResultContribution, IJUnitTestSuiteContribution testSuite) {
        super(parentNode);
        ValidationHelper.validateNotNull((String)"parentNode", (Object)parentNode);
        ValidationHelper.validateNotNull((String)"buildResultContribution", (Object)buildResultContribution);
        ValidationHelper.validateNotNull((String)"testSuite", (Object)testSuite);
        this.fBuildResultContribution = buildResultContribution;
        this.fTestSuiteContribution = testSuite;
    }

    public IJUnitTestSuiteContribution getTestSuiteContribution() {
        return this.fTestSuiteContribution;
    }

    public IBuildResultContribution getBuildResultContribution() {
        return this.fBuildResultContribution;
    }

    public boolean hasChildren() {
        if (this.getChildren() != null) {
            return this.getChildren().length > 0;
        }
        return this.fTestSuiteContribution.getErrorData() == null;
    }

    protected Object[] doFetchChildren(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)this.fTestSuiteContribution.getOrigin();
        this.fTestSuiteContribution = (IJUnitTestSuiteContribution)teamRepository.itemManager().fetchCompleteItem((IItemHandle)this.fTestSuiteContribution, 0, monitor);
        List testClassHandles = this.fTestSuiteContribution.getTestClasses();
        List fetchedTestClasses = teamRepository.itemManager().fetchPartialItems(testClassHandles, 0, (Collection)PARTIAL_TEST_CLASS_PROPERTIES, monitor);
        Object[] testClasses = new JUnitTestClassNode[fetchedTestClasses.size()];
        int i = 0;
        for (Object testClass : fetchedTestClasses) {
            testClasses[i++] = new JUnitTestClassNode(this, (IJUnitTestClass)testClass);
        }
        return testClasses;
    }

    public Image getColumnImage(int columnIndex) {
        if (columnIndex == 0) {
            Image newImage = BuildUIPlugin.getImage("icons/view16/junit.gif");
            BuildStatus status = BuildStatus.OK;
            if (this.fTestSuiteContribution.getErrorCount() > 0 || this.fTestSuiteContribution.getFailureCount() > 0) {
                status = BuildStatus.ERROR;
            }
            return BuildCompositeImageRegistry.getImage(newImage, status);
        }
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.fBuildResultContribution.getLabel();
            }
            case 1: {
                return Integer.toString(this.fTestSuiteContribution.getTestCount());
            }
            case 2: {
                return Integer.toString(this.fTestSuiteContribution.getFailureCount());
            }
            case 3: {
                return Integer.toString(this.fTestSuiteContribution.getErrorCount());
            }
            case 4: {
                return TimeFormatHelper.formatAbbreviatedTime(this.fBuildResultContribution.getTimeTaken());
            }
        }
        return null;
    }

    public int getColumnAsInt(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return this.fTestSuiteContribution.getTestCount();
            }
            case 2: {
                return this.fTestSuiteContribution.getFailureCount();
            }
            case 3: {
                return this.fTestSuiteContribution.getErrorCount();
            }
            case 4: {
                return (int)this.fBuildResultContribution.getTimeTaken();
            }
        }
        return 0;
    }

    public boolean hasProblems() {
        return this.fTestSuiteContribution.getErrorCount() > 0 || this.fTestSuiteContribution.getFailureCount() > 0;
    }

    public String getJUnitName() {
        return "";
    }

    public String getNodeName() {
        return this.getJUnitClassName();
    }

    public String getJUnitClassName() {
        return this.fTestSuiteContribution.getTestSuiteClassName();
    }

    public boolean isError() {
        return this.fTestSuiteContribution.getErrorData() != null;
    }

    public boolean isFailure() {
        return false;
    }

    public IContent getErrorData() {
        return this.fTestSuiteContribution.getErrorData();
    }

    public IContent getFailureData() {
        return null;
    }

    public long getTimeTaken() {
        return this.fBuildResultContribution.getTimeTaken();
    }

    public String getDetailString() {
        return this.fProblemString;
    }

    public void setDetailString(String detailString) {
        this.fProblemString = detailString;
    }
}

