/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.junit;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IJUnitTestSuiteContribution;
import com.ibm.team.build.common.model.IJUnitTestSuiteContributionHandle;
import com.ibm.team.build.internal.ui.editors.result.junit.JUnitResultsPage;
import com.ibm.team.build.internal.ui.editors.result.junit.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.repository.client.ITeamRepository;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.forms.editor.FormEditor;

public class JUnitContributionProvider
extends AbstractBuildResultContributionProvider {
    private int fTestCount;
    private int fErrorCount;
    private int fFailureCount;

    public JUnitContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fTestCount = 0;
        this.fErrorCount = 0;
        this.fFailureCount = 0;
        ITeamRepository teamRepository = this.getBuildResultContext().getTeamRepository();
        ArrayList<IJUnitTestSuiteContributionHandle> testSuiteHandles = new ArrayList<IJUnitTestSuiteContributionHandle>();
        IBuildResultContribution[] contributions = this.getContributions();
        int i = 0;
        while (i < contributions.length) {
            testSuiteHandles.add((IJUnitTestSuiteContributionHandle)contributions[i].getExtendedContribution());
            ++i;
        }
        if (contributions.length > 0) {
            List<String> properties = Arrays.asList(IJUnitTestSuiteContribution.PROPERTY_TEST_COUNT, IJUnitTestSuiteContribution.PROPERTY_ERROR_COUNT, IJUnitTestSuiteContribution.PROPERTY_FAILURE_COUNT);
            List testSuites = teamRepository.itemManager().fetchPartialItems(testSuiteHandles, 0, properties, monitor);
            for (Object object : testSuites) {
                if (object == null) continue;
                IJUnitTestSuiteContribution testSuite = (IJUnitTestSuiteContribution)object;
                this.fTestCount += testSuite.getTestCount();
                this.fErrorCount += testSuite.getErrorCount();
                this.fFailureCount += testSuite.getFailureCount();
            }
        }
    }

    public BuildStatus getStatus() {
        if (this.fErrorCount > 0 || this.fFailureCount > 0) {
            return BuildStatus.ERROR;
        }
        return BuildStatus.OK;
    }

    public String getSummaryText() {
        if (this.fTestCount > 0) {
            return MessageFormat.format(Messages.JUnitContributionProvider_SUMMARY_TEXT, String.valueOf(this.fTestCount), this.getTestString(), String.valueOf(this.fFailureCount), this.getFailureString(), String.valueOf(this.fErrorCount), this.getErrorString());
        }
        return Messages.JUnitContributionProvider_NO_TESTS;
    }

    private String getTestString() {
        if (this.fTestCount == 1) {
            return Messages.JUnitContributionProvider_ONE_TEST;
        }
        return Messages.JUnitContributionProvider_MULTIPLE_TESTS;
    }

    private String getFailureString() {
        if (this.fFailureCount == 1) {
            return Messages.JUnitContributionProvider_ONE_FAILURE;
        }
        return Messages.JUnitContributionProvider_MULTIPLE_FAILURES;
    }

    private String getErrorString() {
        if (this.fErrorCount == 1) {
            return Messages.JUnitContributionProvider_ONE_ERROR;
        }
        return Messages.JUnitContributionProvider_MULTIPLE_ERRORS;
    }

    public String getSummaryTitle() {
        return Messages.JUnitContributionProvider_SUMMARY_TITLE;
    }

    public boolean isSummaryLink() {
        return this.fTestCount > 0;
    }

    public void summaryLinkActivated() {
        this.getBuildResultEditor().setActivePage(this.getExtensionId());
    }

    public AbstractBuildResultPage getBuildResultPage() {
        return new JUnitResultsPage(this.getBuildResultEditor(), this.getExtensionId(), Messages.JUnitContributionProvider_PAGE_TITLE, this.getBuildResultContext());
    }

    public String[] getExtendedContributionIds() {
        return new String[]{IJUnitTestSuiteContribution.EXTENDED_CONTRIBUTION_TYPE_ID};
    }
}

