/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.download;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.IBuildTreeNode;
import com.ibm.team.build.internal.ui.helper.StringFormatHelper;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.swt.graphics.Image;

public class DownloadContributionNode
implements IBuildTreeNode {
    private IBuildResultContribution fContribution;
    private IBuildTreeNode fParentNode;
    private String fFileURL;
    private String fFileName;
    private String fSizeText;
    private long fSize;
    private Image fImage;
    private ITeamRepository fRepository;

    public DownloadContributionNode(IBuildTreeNode parent, IBuildResultContribution contribution, ITeamRepository repository) {
        boolean isExternalArtifact;
        ValidationHelper.validateNotNull((String)"parent", (Object)parent);
        ValidationHelper.validateNotNull((String)"contribution", (Object)contribution);
        ValidationHelper.validateNotNull((String)"repository", (Object)repository);
        this.fContribution = contribution;
        this.fParentNode = parent;
        this.fRepository = repository;
        this.fFileURL = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_URL);
        boolean bl = isExternalArtifact = this.fFileURL != null;
        if (isExternalArtifact) {
            this.fFileName = this.fFileURL;
            while (this.fFileName.length() > 0 && this.fFileName.endsWith("/")) {
                this.fFileName = this.fFileName.substring(0, this.fFileName.length() - 1);
            }
            if (this.fFileName.lastIndexOf(47) != -1) {
                int index = this.fFileName.lastIndexOf(47);
                this.fFileName = this.fFileName.substring(index + 1);
            }
            this.fFileName = this.fFileName.substring(this.fFileName.lastIndexOf(47) + 1);
        } else {
            this.fFileName = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME);
            if (this.fFileURL == null || this.fFileURL.length() == 0) {
                this.fFileURL = this.fFileName;
            }
        }
        this.fSize = Long.MAX_VALUE;
        String sizeString = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE);
        if (sizeString != null) {
            this.fSize = Long.valueOf(sizeString);
        } else if (!isExternalArtifact) {
            this.fSize = contribution.getExtendedContributionData().getEstimatedConvertedLength();
        }
        this.fSizeText = this.fSize == Long.MAX_VALUE ? BuildResultEditorMessages.AbstractDownloadsPage_UNKNOWN_SIZE : StringFormatHelper.formatFileSize(this.fSize);
    }

    public boolean isExternalArtifact() {
        return this.fContribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_URL) != null;
    }

    public String getSizeText() {
        return this.fSizeText;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public String getFileURL() {
        return this.fFileURL;
    }

    public ITeamRepository getRepository() {
        return this.fRepository;
    }

    public IBuildResultContribution getContribution() {
        return this.fContribution;
    }

    public Object[] getChildren() {
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.fFileName;
            }
            case 1: {
                return this.fContribution.getLabel();
            }
            case 2: {
                return this.fSizeText;
            }
        }
        return null;
    }

    public int getColumnAsInt(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return (int)this.fSize;
            }
        }
        return 0;
    }

    public Image getColumnImage(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getIconImage();
            }
        }
        return null;
    }

    protected Image getIconImage() {
        if (this.fImage == null) {
            this.fImage = this.isExternalArtifact() ? BuildUIPlugin.getImage("icons/obj16/extnal_artfct_obj.gif") : BuildUIPlugin.getImage("icons/obj16/buildart_obj.gif");
            if (this.fContribution.getStatus() == BuildStatus.WARNING) {
                this.fImage = BuildCompositeImageRegistry.getImage(this.fImage, BuildStatus.WARNING, false);
            } else if (this.fContribution.getStatus() == BuildStatus.ERROR) {
                this.fImage = BuildCompositeImageRegistry.getImage(this.fImage, BuildStatus.ERROR, false);
            }
        }
        return this.fImage;
    }

    public String getNodeName() {
        return this.fContribution.getLabel();
    }

    public IBuildTreeNode getParentNode() {
        return this.fParentNode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DownloadContributionNode)) {
            return false;
        }
        DownloadContributionNode node = (DownloadContributionNode)object;
        return this.getFileName().equals(node.getFileName()) && this.getFileURL().equals(node.getFileURL()) && this.getNodeName().equals(node.getNodeName()) && this.getParentNode().getNodeName().equals(node.getParentNode().getNodeName());
    }

    public int hashCode() {
        return this.isExternalArtifact() ? this.getFileURL().hashCode() : this.getFileName().hashCode();
    }
}

