/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.compile;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.compile.AbstractCompileTreeNode;
import com.ibm.team.build.internal.ui.editors.result.compile.ICompileDetailProvider;
import com.ibm.team.build.internal.ui.editors.result.compile.ICompileTreeNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class SimpleCompileContributionNode
extends AbstractCompileTreeNode
implements ICompileDetailProvider {
    private ICompileContribution fCompileContribution;
    private IBuildResultContribution fBuildResultContribution;

    public SimpleCompileContributionNode(ICompileTreeNode parentNode, IBuildResultContribution buildResultContribution, ICompileContribution compileContribution) {
        super(parentNode);
        ValidationHelper.validateNotNull((String)"parentNode", (Object)parentNode);
        ValidationHelper.validateNotNull((String)"buildResultContribution", (Object)buildResultContribution);
        ValidationHelper.validateNotNull((String)"compileContribution", (Object)compileContribution);
        this.fBuildResultContribution = buildResultContribution;
        this.fCompileContribution = compileContribution;
    }

    public boolean hasChildren() {
        return false;
    }

    protected Object[] doFetchChildren(IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    public Image getColumnImage(int columnIndex) {
        if (columnIndex == 0) {
            Image newImage = BuildUIPlugin.getImage("icons/view16/compile.gif");
            BuildStatus status = BuildStatus.OK;
            if (this.fCompileContribution.getWarningCount() > 0) {
                status = BuildStatus.WARNING;
            }
            if (this.fCompileContribution.getErrorCount() > 0) {
                status = BuildStatus.ERROR;
            }
            return BuildCompositeImageRegistry.getImage(newImage, status, false);
        }
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getNodeName();
            }
            case 2: {
                return Integer.toString(this.fCompileContribution.getWarningCount());
            }
            case 1: {
                return Integer.toString(this.fCompileContribution.getErrorCount());
            }
        }
        return null;
    }

    public int getColumnAsInt(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return this.fCompileContribution.getWarningCount();
            }
            case 1: {
                return this.fCompileContribution.getErrorCount();
            }
        }
        return 0;
    }

    public boolean hasProblems() {
        return this.fCompileContribution.getErrorCount() > 0 || this.fCompileContribution.getWarningCount() > 0;
    }

    public String getNodeName() {
        return this.fBuildResultContribution.getLabel();
    }

    public boolean hasWarnings() {
        return this.fCompileContribution.getWarningCount() > 0;
    }

    public boolean hasErrors() {
        return this.fCompileContribution.getErrorCount() > 0;
    }

    public String getErrorDetails(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fCompileContribution.getErrors() != null) {
            return ContentUtil.contentToString((ITeamRepository)((ITeamRepository)this.fCompileContribution.getOrigin()), (IContent)this.fCompileContribution.getErrors(), (IProgressMonitor)monitor);
        }
        return null;
    }

    public String getWarningDetails(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fCompileContribution.getWarnings() != null) {
            return ContentUtil.contentToString((ITeamRepository)((ITeamRepository)this.fCompileContribution.getOrigin()), (IContent)this.fCompileContribution.getWarnings(), (IProgressMonitor)monitor);
        }
        return null;
    }
}

