/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.compile;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildDeferredContentProvider;
import com.ibm.team.build.internal.ui.editors.result.BuildLabelProvider;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.internal.ui.editors.result.BuildResultsTreeViewerComparator;
import com.ibm.team.build.internal.ui.editors.result.IDeferredBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.compile.CompileBuildResultNode;
import com.ibm.team.build.internal.ui.editors.result.compile.CompileComponentNode;
import com.ibm.team.build.internal.ui.editors.result.compile.CompileDetailBlock;
import com.ibm.team.build.internal.ui.editors.result.compile.CompilePackageNode;
import com.ibm.team.build.internal.ui.editors.result.compile.CompileSourceNode;
import com.ibm.team.build.internal.ui.editors.result.compile.ICompileDetailProvider;
import com.ibm.team.build.internal.ui.editors.result.compile.ICompileTreeNode;
import com.ibm.team.build.internal.ui.editors.result.compile.Messages;
import com.ibm.team.build.internal.ui.helper.CompileSourceHelper;
import com.ibm.team.build.internal.ui.helper.WorkspaceHelper;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CompileResultsPage
extends BuildResultPage {
    public static final String CONTEXT_MENU_ID = "com.ibm.team.build.ui.compilePageContextMenu";
    public static final int ERROR_COUNT_COLUMN_INDEX = 1;
    public static final int WARNING_COUNT_COLUMN_INDEX = 2;
    public static final int TIME_TAKEN_COLUMN_INDEX = 3;
    protected TreeViewer fViewer;
    protected Tree fCompileResultsTree;
    private CompileDetailBlock fDetailBlock = new CompileDetailBlock();
    protected Button fShowErrorsButton;
    protected Button fShowWarningsButton;
    protected boolean fShowSuccessNodes;
    protected boolean fShowWarningNodes;
    protected SelectionAdapter fRadioListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)CompileResultsPage.this.getViewer().getSelection();
            if (selection.size() == 1 && selection.getFirstElement() instanceof ICompileDetailProvider) {
                CompileResultsPage.this.setDetailProvider((ICompileDetailProvider)selection.getFirstElement(), CompileResultsPage.this.fShowErrorsButton.getSelection());
            }
        }
    };
    protected ViewerFilter fSuccessNodeFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ICompileTreeNode) {
                IDeferredBuildTreeNode node = (IDeferredBuildTreeNode)element;
                return node.hasProblems();
            }
            return true;
        }
    };
    protected ViewerFilter fWarningNodeFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ICompileTreeNode) {
                ICompileTreeNode node = (ICompileTreeNode)element;
                return !node.hasWarnings() || node.hasErrors();
            }
            return true;
        }
    };

    public CompileResultsPage(FormEditor editor, String id, String title, IBuildResultContext buildResultContext) {
        super(editor, id, title, new String[]{ICompileContribution.EXTENDED_CONTRIBUTION_TYPE_ID}, buildResultContext);
        this.fShowWarningNodes = !this.containsFailures(this.getContributions());
        this.fShowSuccessNodes = this.fShowWarningNodes;
    }

    public AbstractBuildResultPage.PageGroup getPageGroup() {
        return AbstractBuildResultPage.PageGroup.COMPILATION;
    }

    protected void doCreatePageContent(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.setBorderStyle(2048);
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.addResultTree(parent, toolkit);
        this.addDetails(parent, toolkit);
        this.createContextMenu(CONTEXT_MENU_ID, this.getSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.editor_buildresultcompile");
    }

    private void addResultTree(final Composite body, FormToolkit toolkit) {
        Section section = toolkit.createSection(body, 256);
        section.setText(Messages.CompileResultsPage_COMPILE_SECTION_TITLE);
        GridLayoutFactory.fillDefaults().applyTo((Composite)section);
        ToolBar toolbar = this.createToolbar(toolkit, (Composite)section);
        section.setTextClient((Control)toolbar);
        Composite treeComposite = toolkit.createComposite(body);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)treeComposite);
        section.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)section, 7);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(50, 0);
        treeComposite.setLayoutData((Object)formData);
        this.fCompileResultsTree = toolkit.createTree(treeComposite, 0x10010B00);
        this.fCompileResultsTree.setLinesVisible(true);
        this.fCompileResultsTree.setHeaderVisible(true);
        this.fCompileResultsTree.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                CompileResultsPage.this.fCompileResultsTree.removeListener(36, (Listener)this);
                body.layout(true, true);
            }
        });
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.createTreeColumn(this.fCompileResultsTree, treeColumnLayout, BuildResultEditorMessages.NAME_COLUMN_TITLE, 60, 16384, 0);
        this.createTreeColumn(this.fCompileResultsTree, treeColumnLayout, BuildResultEditorMessages.ERROR_COUNT_COLUMN_TITLE, 20, 131072, 1);
        this.createTreeColumn(this.fCompileResultsTree, treeColumnLayout, BuildResultEditorMessages.WARNING_COUNT_COLUMN_TITLE, 20, 131072, 2);
        treeComposite.setLayout((Layout)treeColumnLayout);
        this.fViewer = new TreeViewer(this.fCompileResultsTree);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new BuildLabelProvider());
        this.fViewer.setContentProvider((IContentProvider)new BuildDeferredContentProvider(this.fViewer));
        this.fViewer.setComparator((ViewerComparator)new BuildResultsTreeViewerComparator());
        TreeColumn nameColumn = this.fViewer.getTree().getColumn(0);
        this.fViewer.getTree().setSortColumn(nameColumn);
        this.fViewer.getTree().setSortDirection(128);
        this.fViewer.addDoubleClickListener(this.getDoubleClickListener());
        Image showSuccessImage = BuildCompositeImageRegistry.getImage(BuildUIPlugin.getImage("icons/view16/compile.gif"), BuildStatus.OK, true);
        Image showWarningImage = BuildCompositeImageRegistry.getImage(BuildUIPlugin.getImage("icons/view16/compile.gif"), BuildStatus.WARNING, false);
        this.createFilterButton(showSuccessImage, Messages.CompileResultsPage_SUCCESSFUL_PROJECTS_FILTER_TOOLTIP, toolbar, this.fSuccessNodeFilter, (StructuredViewer)this.fViewer, this.fShowSuccessNodes);
        this.createFilterButton(showWarningImage, Messages.CompileResultsPage_PROJECT_WITH_WARNINGS_FILTER_TOOLTIP, toolbar, this.fWarningNodeFilter, (StructuredViewer)this.fViewer, this.fShowWarningNodes);
        this.fViewer.setInput((Object)new CompileBuildResultNode(this.getContributions()));
    }

    protected void toggleFilter(boolean buttonSelected, StructuredViewer viewer, ViewerFilter filter) {
        if (filter == this.fSuccessNodeFilter) {
            this.fShowSuccessNodes = buttonSelected;
        } else {
            this.fShowWarningNodes = buttonSelected;
        }
        super.toggleFilter(buttonSelected, viewer, filter);
    }

    protected IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof CompileSourceNode) {
                    CompileSourceNode sourceNode = (CompileSourceNode)element;
                    String fullTypeName = CompileSourceHelper.getFullyQualifiedTypeName(sourceNode.getCompileSource());
                    CompileResultsPage.this.openJavaSourceFile(fullTypeName);
                }
            }
        };
    }

    protected boolean openJavaSourceFile(String fullTypeName) {
        return WorkspaceHelper.openJavaSourceFile(fullTypeName, 1, this.getEditorSite());
    }

    protected void setDetailProvider(ICompileDetailProvider provider, boolean showErrors) {
        this.fDetailBlock.setDetailProvider(provider, showErrors);
    }

    private void addDetails(Composite body, FormToolkit toolkit) {
        Section outputSection = toolkit.createSection(body, 384);
        outputSection.setDescription(Messages.CompileResultsPage_OUTPUT_SECTION_DESCRIPTION);
        outputSection.setText(Messages.CompileResultsPage_OUTPUT_SECTION_TITLE);
        GridLayoutFactory.fillDefaults().applyTo((Composite)outputSection);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(50, 7);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        outputSection.setLayoutData((Object)formData);
        Composite composite = toolkit.createComposite((Composite)outputSection);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).minSize(300, 150).applyTo((Control)composite);
        outputSection.setClient((Control)composite);
        Composite radioComposite = toolkit.createComposite(composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(radioComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)radioComposite);
        this.fShowErrorsButton = toolkit.createButton(radioComposite, Messages.CompileResultsPage_ERRORS_BUTTON_TITLE, 16);
        this.fShowErrorsButton.setSelection(true);
        this.fShowErrorsButton.addSelectionListener((SelectionListener)this.fRadioListener);
        this.fShowWarningsButton = toolkit.createButton(radioComposite, Messages.CompileResultsPage_WARNINGS_BUTTON_TITLE, 16);
        this.fDetailBlock.createContents(composite, toolkit, this.getEditor());
        this.fViewer.addSelectionChangedListener(this.getSelectionChangedListener());
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    if (CompileResultsPage.this.inRemoveFilterCall()) {
                        return;
                    }
                    Object element = selection.getFirstElement();
                    if (element instanceof ICompileDetailProvider) {
                        ICompileDetailProvider provider = (ICompileDetailProvider)element;
                        if (provider.hasErrors()) {
                            CompileResultsPage.this.fShowWarningsButton.setSelection(false);
                            CompileResultsPage.this.fShowErrorsButton.setSelection(true);
                        } else if (provider.hasWarnings()) {
                            CompileResultsPage.this.fShowWarningsButton.setSelection(true);
                            CompileResultsPage.this.fShowErrorsButton.setSelection(false);
                        }
                        CompileResultsPage.this.setDetailProvider((ICompileDetailProvider)element, CompileResultsPage.this.fShowErrorsButton.getSelection());
                        return;
                    }
                }
                CompileResultsPage.this.setDetailProvider(null, false);
            }
        };
    }

    protected Object getSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        return selection.getFirstElement();
    }

    protected Tree getCompileResultsTree() {
        return this.fCompileResultsTree;
    }

    protected BuildResultPage.CopyStrategy getCopyStrategy(Control control) {
        return control == this.getCompileResultsTree() ? BuildResultPage.CopyStrategy.FIRST : BuildResultPage.CopyStrategy.DEFAULT;
    }

    protected String getCopyActionItemNameForSelectedItem(Control control) {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem instanceof CompileComponentNode) {
            return Messages.CompileResultsPage_COMPONENT_NAME;
        }
        if (selectedItem instanceof CompilePackageNode) {
            if (((CompilePackageNode)selectedItem).getPackageType().equals("plugin")) {
                return Messages.CompileResultsPage_PLUGIN_NAME;
            }
            return Messages.CompileResultsPage_PACKAGE_NAME;
        }
        return Messages.CompileResultsPage_FILENAME;
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    protected void createTreeColumn(Tree tree, TreeColumnLayout layout, String columnName, int weight, int style, int index) {
        TreeColumn treeColumn = new TreeColumn(tree, style, index);
        layout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(weight));
        treeColumn.setText(columnName);
        treeColumn.addSelectionListener(this.getColumnSelectionListener(tree, treeColumn));
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_buildresultcompile";
    }
}

