/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.compile;

import com.ibm.team.build.common.model.ICompileProblem;
import com.ibm.team.build.internal.ui.editors.result.compile.ICompileDetailProvider;
import com.ibm.team.build.internal.ui.editors.result.compile.IComplexCompileDetailProvider;
import com.ibm.team.build.internal.ui.editors.result.compile.Messages;
import com.ibm.team.build.internal.ui.helper.CompileSourceHelper;
import com.ibm.team.build.internal.ui.helper.WorkspaceHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.jface.tooltip.TooltipSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;

public class CompileDetailBlock {
    private static final int NUMBER_OF_COLUMNS = 2;
    private ICompileDetailProvider fProvider;
    private boolean fShowErrors;
    protected FormEditor fEditor;
    protected PageBook fPageBook;
    protected Page fSimplePage;
    protected Page fComplexPage;
    protected Control fSimpleDetailsControl;
    protected Control fComplexDetailsControl;
    protected Tree fTree;
    protected TreeViewer fTreeViewer;
    protected Text fText;

    public Composite createContents(Composite parent, final FormToolkit toolkit, FormEditor editor) {
        this.fPageBook = new PageBook(parent, 0);
        this.fEditor = editor;
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fPageBook);
        this.fSimplePage = new Page(){

            public void createControl(Composite innerParent) {
                CompileDetailBlock.this.createSimpleDetailsControl(innerParent, toolkit);
            }

            public Control getControl() {
                return CompileDetailBlock.this.fSimpleDetailsControl;
            }

            public void setFocus() {
            }
        };
        this.fSimplePage.createControl((Composite)this.fPageBook);
        this.fComplexPage = new Page(){

            public void createControl(Composite innerParent) {
                CompileDetailBlock.this.createComplexDetailsControl(innerParent, toolkit);
            }

            public Control getControl() {
                return CompileDetailBlock.this.fComplexDetailsControl;
            }

            public void setFocus() {
            }
        };
        this.fComplexPage.createControl((Composite)this.fPageBook);
        return this.fPageBook;
    }

    protected void createSimpleDetailsControl(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fText = toolkit.createText(composite, "", 2826);
        GridData gridData = new GridData(1808);
        this.fText.setLayoutData((Object)gridData);
        this.fText.setFont(JFaceResources.getTextFont());
        this.fSimpleDetailsControl = composite;
    }

    protected void createComplexDetailsControl(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fTree = toolkit.createTree(composite, 65538);
        this.fTree.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < 2) {
            TreeColumn column = new TreeColumn(this.fTree, 0, i);
            column.setResizable(true);
            ++i;
        }
        this.fTreeViewer = new TreeViewer(this.fTree);
        this.fTreeViewer.addDoubleClickListener(this.getDoubleClickListener());
        this.createContextMenu();
        this.addTooltipSupport();
        this.fComplexDetailsControl = composite;
    }

    protected TooltipSupport addTooltipSupport() {
        return new TooltipSupport((Control)this.fTree, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                String markup = super.getMarkup(element, isFocus);
                if (element instanceof ICompileProblem && isFocus) {
                    this.setPreferredFocusSize(new Point(500, 40));
                }
                return markup;
            }
        };
    }

    protected IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CompileDetailBlock.this.openCompileProblem((ICompileProblem)selection.getFirstElement());
            }
        };
    }

    protected void createContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(this.getMenuListener());
        Menu menu = mgr.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        this.fEditor.getEditorSite().registerContextMenu(mgr, (ISelectionProvider)this.fTreeViewer);
    }

    protected IMenuListener getMenuListener() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ActionFactory.IWorkbenchAction copyAction = ActionFactory.COPY.create(CompileDetailBlock.this.fEditor.getEditorSite().getWorkbenchWindow());
                copyAction.setEnabled(true);
                if (copyAction instanceof RetargetAction) {
                    ((RetargetAction)copyAction).partActivated((IWorkbenchPart)CompileDetailBlock.this.fEditor);
                }
                manager.add((IAction)copyAction);
                manager.add((IContributionItem)new GroupMarker("additions"));
            }
        };
    }

    protected boolean openCompileProblem(ICompileProblem compileProblem) {
        String fullTypeName = CompileSourceHelper.getFullyQualifiedTypeName(compileProblem.getCompileSource());
        return WorkspaceHelper.openJavaSourceFile(fullTypeName, compileProblem.getLineNumber(), this.fEditor.getEditorSite());
    }

    public void setDetailProvider(ICompileDetailProvider provider, boolean showErrors) {
        if (provider == this.fProvider && this.fShowErrors == showErrors) {
            return;
        }
        this.fProvider = provider;
        this.fShowErrors = showErrors;
        if (provider == null) {
            this.setVisible(false);
            return;
        }
        this.updateDetailsAsync();
    }

    protected void updateDetailsAsync() {
        TeamBuildJob job = new TeamBuildJob(Messages.CompileDetailBlock_RETRIEVING_PROBLEM_DETAILS, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                final boolean complexDetails = CompileDetailBlock.this.fProvider instanceof IComplexCompileDetailProvider;
                final ICompileProblem[][] problems = new ICompileProblem[1][];
                final String[] details = new String[]{""};
                if (complexDetails) {
                    IComplexCompileDetailProvider complexProvider = (IComplexCompileDetailProvider)CompileDetailBlock.this.fProvider;
                    problems[0] = CompileDetailBlock.this.fShowErrors ? complexProvider.getErrors(monitor) : complexProvider.getWarnings(monitor);
                } else {
                    details[0] = CompileDetailBlock.this.fShowErrors ? CompileDetailBlock.this.fProvider.getErrorDetails(monitor) : CompileDetailBlock.this.fProvider.getWarningDetails(monitor);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        CompileDetailBlock.this.handleShowDetailsAsync(complexDetails, problems[0], details[0]);
                    }
                });
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getSeverity() == 4) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            CompileDetailBlock.this.setVisible(false);
                        }
                    });
                }
            }
        };
        this.scheduleJob(job);
    }

    protected void scheduleJob(TeamBuildJob job) {
        job.schedule();
    }

    protected void handleShowDetailsAsync(boolean complex, ICompileProblem[] problems, String details) {
        if (!this.fPageBook.isDisposed()) {
            if (complex) {
                this.showComplexDetails(problems);
            } else {
                this.showSimpleDetails(details);
            }
        }
    }

    protected void showSimpleDetails(String problemString) {
        if (problemString != null && problemString.length() > 0) {
            this.fText.setText(problemString);
            this.showSimplePage();
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    protected void showComplexDetails(ICompileProblem[] problems) {
        Image image;
        this.cleanupTree();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        Image image2 = image = this.fShowErrors ? sharedImages.getImage("IMG_OBJS_ERROR_TSK") : sharedImages.getImage("IMG_OBJS_WARN_TSK");
        if (problems == null || problems.length == 0) {
            return;
        }
        int i = 0;
        while (i < problems.length) {
            ICompileProblem problem = problems[i];
            TreeItem TreeItem2 = new TreeItem(this.fTree, 0);
            TreeItem2.setImage(image);
            String lineNumber = NLS.bind((String)Messages.CompileDetailBlock_LINE_NUMBER, (Object)problem.getLineNumber());
            TreeItem2.setText(0, lineNumber);
            TreeItem2.setText(1, problem.getMessageText());
            TreeItem2.setData((Object)problem);
            ++i;
        }
        i = 0;
        while (i < 2) {
            this.fTree.getColumn(i).pack();
            ++i;
        }
        this.showComplexPage();
        this.setVisible(true);
    }

    protected void showSimplePage() {
        this.fPageBook.showPage(this.fSimpleDetailsControl);
    }

    protected void showComplexPage() {
        this.fPageBook.showPage(this.fComplexDetailsControl);
    }

    protected void setVisible(boolean visible) {
        this.fPageBook.setVisible(visible);
    }

    private void cleanupTree() {
        TreeItem[] treeItemArray = this.fTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.dispose();
            ++n2;
        }
    }
}

