/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.process;

import com.ibm.team.build.internal.ui.editors.process.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CancelPendingRequestAspectEditor
extends OperationDetailsAspectEditor {
    private static final String ELEMENT_ALLOW = "allow";
    private static final String ATTRIBUTE_CANCELER = "canceler";
    private static final String ATTRIBUTE_VALUE_REQUESTER = "requester";
    private static final String ATTRIBUTE_VALUE_TEAM = "team";
    protected Button fRequesterButton;
    protected Button fRequestorAndTeamButton;
    protected boolean fTeamMayCancelRequest = false;

    public void restoreState(IMemento memento) {
        this.fTeamMayCancelRequest = false;
        if (memento.getChildren(ELEMENT_ALLOW).length > 0) {
            IMemento[] iMementoArray = memento.getChildren(ELEMENT_ALLOW);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento allowMemento = iMementoArray[n2];
                String canceler = allowMemento.getString(ATTRIBUTE_CANCELER);
                if (ATTRIBUTE_VALUE_TEAM.equals(canceler)) {
                    this.fTeamMayCancelRequest = true;
                }
                ++n2;
            }
        } else {
            this.fTeamMayCancelRequest = true;
            this.setDirty();
        }
    }

    public boolean saveState(IMemento memento) {
        memento.createChild(ELEMENT_ALLOW).putString(ATTRIBUTE_CANCELER, ATTRIBUTE_VALUE_REQUESTER);
        if (this.fTeamMayCancelRequest) {
            memento.createChild(ELEMENT_ALLOW).putString(ATTRIBUTE_CANCELER, ATTRIBUTE_VALUE_TEAM);
        }
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().spacing(5, 8).applyTo(parent);
        toolkit.createLabel(parent, Messages.AspectEditor_CONSTRAINTS_SECTION_HEADER).setFont(this.getBoldFont());
        toolkit.createLabel(parent, Messages.CancelPendingRequestAspectEditor_SELECTION_LABEL);
        Composite buttonComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(10, 0).spacing(5, 8).applyTo(buttonComposite);
        this.fRequesterButton = this.createRadioButton(toolkit, buttonComposite, Messages.AspectEditer_REQUESTER_BUTTON_LABEL, false);
        this.fRequestorAndTeamButton = this.createRadioButton(toolkit, buttonComposite, Messages.AspectEditer_REQUESTER_OR_TEAM_BUTTON_LABEL, true);
    }

    private Button createRadioButton(FormToolkit toolkit, Composite parent, String text, boolean teamConstraint) {
        Button button = toolkit.createButton(parent, text, 16);
        button.addSelectionListener(this.createButtonListener(teamConstraint));
        button.setSelection(this.fTeamMayCancelRequest == teamConstraint);
        return button;
    }

    protected SelectionListener createButtonListener(final boolean teamConstraint) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CancelPendingRequestAspectEditor.this.fTeamMayCancelRequest = teamConstraint;
                CancelPendingRequestAspectEditor.this.setDirty(true);
            }
        };
    }

    public void dispose() {
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }
}

