/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.buildengine;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildEngineEditorInput
implements IEditorInput {
    private static final int MONITORING_THRESHOLD_DEFAULT = 3;
    private IBuildEngine fBuildEngine;
    private boolean fNewBuildEngine;
    private ITeamRepository fTeamRepository;
    private Collection<IBuildDefinitionHandle> fSupportedBuildDefinitions = new ArrayList<IBuildDefinitionHandle>();
    private ITeamArea fDefaultTeamArea;

    public BuildEngineEditorInput(IBuildEngine buildEngine, ITeamRepository teamRepository) {
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        this.fTeamRepository = teamRepository;
        if (buildEngine == null) {
            this.fNewBuildEngine = true;
            this.fBuildEngine = BuildItemFactory.createBuildEngine();
            this.fBuildEngine.setMonitoringThreshold(3);
            this.fBuildEngine.setActive(true);
        } else {
            this.fNewBuildEngine = false;
            this.fBuildEngine = buildEngine;
        }
    }

    public boolean isNewBuildEngine() {
        return this.fNewBuildEngine;
    }

    public IBuildEngine getBuildEngine() {
        return this.fBuildEngine;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return BuildUIPlugin.getImageDescriptor("icons/obj16/bld_srvr.gif");
    }

    public String getName() {
        return this.fBuildEngine.getId();
    }

    public String getToolTipText() {
        return this.fBuildEngine.getId();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BuildEngineEditorInput)) {
            return false;
        }
        BuildEngineEditorInput input = (BuildEngineEditorInput)obj;
        return this.getBuildEngine().getItemId().equals((Object)input.getBuildEngine().getItemId());
    }

    public int hashCode() {
        return this.getBuildEngine().getItemId().hashCode();
    }

    public Collection<IBuildDefinitionHandle> getDefaultSupportedBuildDefinitions() {
        return this.fSupportedBuildDefinitions;
    }

    public void setDefaultSupportedBuildDefinitions(Collection<IBuildDefinitionHandle> buildDefinitions) {
        this.fSupportedBuildDefinitions = buildDefinitions == null ? new ArrayList<IBuildDefinitionHandle>() : buildDefinitions;
    }

    public void setDefaultTeamArea(ITeamArea teamArea) {
        this.fDefaultTeamArea = teamArea;
    }

    public ITeamArea getDefaultTeamArea() {
        return this.fDefaultTeamArea;
    }
}

