/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.model.BuildDefinition;
import com.ibm.team.build.internal.common.model.BuildProperty;
import com.ibm.team.build.internal.ui.BuildPropertyControl;
import com.ibm.team.build.internal.ui.IBuildPropertyControlListener;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PropertiesConfigurationEditor
extends AbstractConfigurationElementEditor {
    protected BuildPropertyControl fBuildPropertyControl;
    private Section fPropertiesSection;
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private Adapter fPropertyChangedAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            Object notifier = notification.getNotifier();
            if (notifier instanceof BuildProperty || notifier instanceof BuildDefinition) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PropertiesConfigurationEditor.this.refreshBuildPropertyControl();
                    }
                });
            }
        }
    };
    private IBuildPropertyControlListener fBuildPropertyListener = this.getPropertyListener();

    public PropertiesConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new GridLayout());
        this.fPropertiesSection = toolkit.createSection(parent, 384);
        this.fPropertiesSection.setLayoutData((Object)new GridData(1808));
        this.fPropertiesSection.setLayout((Layout)new GridLayout(1, false));
        this.fPropertiesSection.setText(BuildDefinitionEditorMessages.BuildDefinitionEditor_PROPERTIES_TITLE);
        this.fPropertiesSection.setDescription(BuildDefinitionEditorMessages.BuildDefinitionEditor_PROPERTIES_DESCRIPTION);
        Composite composite = toolkit.createComposite((Composite)this.fPropertiesSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.fBuildPropertyControl = new BuildPropertyControl(composite, toolkit, this.fBuildDefinitionWorkingCopy.getProperties(), this.getTeamRepository(), true, BuildPropertyControl.LayoutSize.FULL);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.fBuildPropertyControl.getComposite().setLayoutData((Object)gridData);
        this.fBuildPropertyControl.addListener(this.fBuildPropertyListener);
        this.fPropertiesSection.setClient((Control)composite);
    }

    protected IBuildPropertyControlListener getPropertyListener() {
        return new IBuildPropertyControlListener(){

            public void propertyAdded(IBuildProperty buildProperty) {
                PropertiesConfigurationEditor.this.handlePropertyAdded(buildProperty);
            }

            public void propertyEdited(IBuildProperty buildProperty) {
                PropertiesConfigurationEditor.this.handlePropertyEdited(buildProperty);
            }

            public void propertiesRemoved(IBuildProperty[] buildProperties) {
                PropertiesConfigurationEditor.this.handlePropertiesRemoved(buildProperties);
            }
        };
    }

    public boolean validate() {
        boolean isValid = true;
        List properties = this.fBuildDefinitionWorkingCopy.getProperties();
        for (Object object : properties) {
            IBuildProperty property = (IBuildProperty)object;
            if (!property.isRequired() || !property.isGenericEditAllowed()) continue;
            if (property.getValue().equals("")) {
                this.addErrorMessage((Object)property.getName(), NLS.bind((String)BuildDefinitionEditorMessages.PropertiesConfigurationEditor_PROPERTY_REQUIRED, (Object)property.getName()), (Control)this.fBuildPropertyControl.getComposite());
                isValid = false;
                continue;
            }
            this.removeErrorMessage(property.getName(), (Control)this.fBuildPropertyControl.getComposite());
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    protected void handlePropertyAdded(IBuildProperty buildProperty) {
        this.setDirty(true);
    }

    protected void handlePropertyEdited(IBuildProperty editedProperty) {
        this.setDirty(true);
        this.validate();
    }

    protected void handlePropertiesRemoved(IBuildProperty[] removedProperties) {
        this.setDirty(true);
    }

    public void dispose() {
        super.dispose();
        if (this.fBuildDefinitionWorkingCopy != null) {
            ((BuildDefinition)this.fBuildDefinitionWorkingCopy).eAdapters().remove((Object)this.fPropertyChangedAdapter);
        }
        if (this.fBuildPropertyControl != null) {
            this.fBuildPropertyControl.removeListener(this.fBuildPropertyListener);
        }
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        if (this.fBuildDefinitionWorkingCopy != null) {
            ((BuildDefinition)this.fBuildDefinitionWorkingCopy).eAdapters().remove((Object)this.fPropertyChangedAdapter);
        }
        this.fBuildDefinitionWorkingCopy = definition;
        ((BuildDefinition)this.fBuildDefinitionWorkingCopy).eAdapters().add((Object)this.fPropertyChangedAdapter);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PropertiesConfigurationEditor.this.handleSetWorkingCopyAsync();
            }
        });
    }

    protected void handleSetWorkingCopyAsync() {
        if (this.fBuildPropertyControl != null && !this.fBuildPropertyControl.getComposite().isDisposed()) {
            this.fBuildPropertyControl.setBuildProperties(this.fBuildDefinitionWorkingCopy.getProperties());
        }
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionproperties";
    }

    public Control getFocusControl() {
        return this.fBuildPropertyControl.getViewer().getControl();
    }

    protected void refreshBuildPropertyControl() {
        if (this.fBuildPropertyControl != null && !this.fBuildPropertyControl.getComposite().isDisposed()) {
            this.fBuildPropertyControl.refresh();
        }
    }
}

