/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.scm.ComponentLoadRules;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ui.FileSelectionDialog;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wizards.newworkspace.NewWorkspaceWizard;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JazzScmConfigurationEditor
extends AbstractConfigurationElementEditor {
    public static final String PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING = "showWorkspaceOwnerWarning";
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    protected Text fFetchDestinationText;
    protected Button fAcceptBeforeFetchButton;
    protected Button fBuildOnlyIfChangesButton;
    protected Button fDeleteBeforeFetchButton;
    private FormToolkit fToolkit;
    protected Hyperlink fWorkspaceTitleHyperlink;
    protected Text fWorkspaceNameText;
    protected Button fSelectWorkspaceButton;
    protected Button fCreateWorkspaceButton;
    protected IWorkspace fWorkspace;
    protected Text fComponentLoadRulesText;
    protected Button fSelectComponentLoadRulesButton;
    protected Button fClearComponentLoadRulesButton;
    protected ComponentLoadRules fComponentLoadRules;
    protected Color fEnabledHyperlinkForegroundColor;
    protected Color fDisabledHyperlinkForegroundColor;
    protected Button fDontShowWarningButton;

    public JazzScmConfigurationEditor(String elementId, String title) {
        super(elementId, title);
        BuildUIPlugin.getDefault().getPreferenceStore().setDefault(PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING, true);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 15;
        parent.setLayout((Layout)layout);
        this.createWorkspaceNameWidgets(parent);
        this.createLoadOptionsWidgets(parent);
        this.createAcceptOptionsWidgets(parent);
    }

    private void createWorkspaceNameWidgets(Composite parent) {
        Section section = this.fToolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_REPOSITORY);
        section.setDescription(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 4;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.fWorkspaceTitleHyperlink = this.fToolkit.createHyperlink(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_LABEL, 0);
        this.fWorkspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.fEnabledHyperlinkForegroundColor = this.fWorkspaceTitleHyperlink.getForeground();
        this.fWorkspaceTitleHyperlink.setLayoutData((Object)new TableWrapData());
        this.fWorkspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.fWorkspaceNameText = this.fToolkit.createText(composite, "", 0);
        this.fDisabledHyperlinkForegroundColor = this.fWorkspaceNameText.getForeground();
        this.fWorkspaceNameText.setEnabled(false);
        this.fWorkspaceNameText.setEditable(false);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.fWorkspaceNameText.setLayoutData((Object)layoutData);
        this.fSelectWorkspaceButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SELECT_WORKSPACE_BUTTON_TITLE, 0);
        this.fSelectWorkspaceButton.addSelectionListener(this.getSelectWorkspaceListener());
        this.fSelectWorkspaceButton.setLayoutData((Object)new TableWrapData());
        this.fCreateWorkspaceButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CREATE_WORKSPACE_BUTTON_TITLE, 0);
        this.fCreateWorkspaceButton.addSelectionListener(this.getCreateWorkspaceListener());
        this.fCreateWorkspaceButton.setLayoutData((Object)new TableWrapData());
        this.createSpacer(composite, 5, 4);
        Label label = this.fToolkit.createLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_UUID_PROPERTY, (Object)"team.scm.workspaceUUID"), 64);
        label.setForeground(Display.getDefault().getSystemColor(16));
        layoutData = new TableWrapData(2, 32, 1, 4);
        label.setLayoutData((Object)layoutData);
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.workspaceUUID");
        if (property.getValue().length() == 0) {
            this.setWorkspaceNameText("", false);
            return;
        }
        this.setWorkspaceNameText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PENDING, false);
        final IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)property.getValue()), null);
        String jobName = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_FETCHING_JOB_NAME;
        TeamBuildJob job = new TeamBuildJob(jobName, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                JazzScmConfigurationEditor.this.fWorkspace = JazzScmConfigurationEditor.this.fetchWorkspace(workspaceHandle, monitor);
                JazzScmConfigurationEditor.this.handleUpdateWorkspaceText(JazzScmConfigurationEditor.this.fWorkspace.getName());
                JazzScmConfigurationEditor.this.handleUpdateComponentLoadRulesButton(JazzScmConfigurationEditor.this.fWorkspace);
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getSeverity() == 4) {
                    JazzScmConfigurationEditor.this.handleFetchFailed(status);
                }
            }
        };
        job.schedule();
    }

    protected void handleFetchFailed(final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!JazzScmConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                    String errorMessage = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_FETCHING;
                    if (status.getException() instanceof ItemNotFoundException) {
                        errorMessage = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_DELETED;
                    }
                    JazzScmConfigurationEditor.this.setWorkspaceNameText(errorMessage, false);
                }
            }
        });
    }

    private void setWorkspaceTitleHyperlinkEnablement(boolean enabled) {
        this.fWorkspaceTitleHyperlink.setForeground(enabled ? this.fEnabledHyperlinkForegroundColor : this.fDisabledHyperlinkForegroundColor);
        this.fWorkspaceTitleHyperlink.setUnderlined(enabled);
        this.fWorkspaceTitleHyperlink.setEnabled(enabled);
    }

    private void setWorkspaceNameText(String text, boolean workspaceSet) {
        this.fWorkspaceNameText.setText(text);
        this.fWorkspaceNameText.setEnabled(workspaceSet);
        this.setWorkspaceTitleHyperlinkEnablement(workspaceSet);
    }

    private void createLoadOptionsWidgets(Composite parent) {
        this.createSpacer(parent, 5, 1);
        Section section = this.fToolkit.createSection(parent, 450);
        section.setLayoutData((Object)new TableWrapData(128));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_LOAD);
        section.setDescription(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_DESC_LOAD);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 4;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.fetchDestination");
        this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DESTINATION_LABEL);
        this.fFetchDestinationText = this.fToolkit.createText(composite, property.getValue());
        TableWrapData layoutData = new TableWrapData(128, 32, 1, 3);
        this.fFetchDestinationText.setLayoutData((Object)layoutData);
        this.fFetchDestinationText.addModifyListener(this.getFetchDestinationModifiedListener());
        String propertyValue = "false";
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.deleteDestinationBeforeFetch");
        if (property != null) {
            propertyValue = property.getValue();
        }
        this.fDeleteBeforeFetchButton = this.fToolkit.createButton(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DELETE_DESTINATION_DESC, (Object)"team.scm.deleteDestinationBeforeFetch"), 32);
        layoutData = new TableWrapData(2, 32, 1, 4);
        this.fDeleteBeforeFetchButton.setLayoutData((Object)layoutData);
        this.fDeleteBeforeFetchButton.setSelection(Boolean.valueOf(propertyValue).booleanValue());
        this.fDeleteBeforeFetchButton.addSelectionListener(this.getDeleteBeforeFetchSelectionListener());
        this.fDeleteBeforeFetchButton.setEnabled(this.fFetchDestinationText.getText().trim().length() > 0);
        this.createSpacer(composite, 5, 4);
        Label label = this.fToolkit.createLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_OPTIONS_PROPERTY, (Object)"team.scm.fetchDestination", (Object)"team.scm.deleteDestinationBeforeFetch"), 64);
        label.setForeground(Display.getDefault().getSystemColor(16));
        layoutData = new TableWrapData(2, 32, 1, 4);
        label.setLayoutData((Object)layoutData);
        String componentLoadRulesValue = "";
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.componentLoadRules");
        if (property != null) {
            componentLoadRulesValue = property.getValue();
        }
        this.fComponentLoadRules = new ComponentLoadRules(componentLoadRulesValue);
        Label desc = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_COMPONENT_LOAD_RULES_DESC, 64);
        desc.setForeground(Display.getDefault().getSystemColor(2));
        layoutData = new TableWrapData(2, 32, 1, 4);
        desc.setLayoutData((Object)layoutData);
        Label rulesLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_COMPONENT_LOAD_RULES_LABEL);
        layoutData = new TableWrapData(2, 32);
        rulesLabel.setLayoutData((Object)layoutData);
        this.fComponentLoadRulesText = this.fToolkit.createText(composite, componentLoadRulesValue, 0);
        this.fComponentLoadRulesText.setEnabled(false);
        this.fComponentLoadRulesText.setEditable(false);
        layoutData = new TableWrapData(256, 32);
        layoutData.maxWidth = 400;
        this.fComponentLoadRulesText.setLayoutData((Object)layoutData);
        this.fSelectComponentLoadRulesButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SELECT_COMPONENT_LOAD_RULES_BUTTON_TITLE, 0);
        this.fSelectComponentLoadRulesButton.addSelectionListener(this.getSelectComponentLoadRulesListener());
        this.fSelectComponentLoadRulesButton.setLayoutData((Object)new TableWrapData());
        this.fSelectComponentLoadRulesButton.setEnabled(this.fWorkspace != null);
        this.fClearComponentLoadRulesButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CLEAR_COMPONENTRULES_BUTTON, 0);
        this.fClearComponentLoadRulesButton.addSelectionListener(this.getClearComponentLoadRulesListener());
        this.fClearComponentLoadRulesButton.setLayoutData((Object)new TableWrapData());
        this.updateComponentLoadRules(this.fComponentLoadRules);
        this.createSpacer(composite, 5, 4);
        label = this.fToolkit.createLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_COMPONENT_LOAD_RULES_PROPERTY, (Object)"team.scm.componentLoadRules"), 64);
        label.setForeground(Display.getDefault().getSystemColor(16));
        layoutData = new TableWrapData(2, 32, 1, 4);
        label.setLayoutData((Object)layoutData);
    }

    private void createAcceptOptionsWidgets(Composite parent) {
        this.createSpacer(parent, 15, 1);
        Section section = this.fToolkit.createSection(parent, 450);
        section.setLayoutData((Object)new TableWrapData(128));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_ACCEPT);
        section.setDescription(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_DESC_ACCEPT);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.acceptBeforeFetch");
        this.fAcceptBeforeFetchButton = this.fToolkit.createButton(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ACCEPT_DESC, (Object)"team.scm.acceptBeforeFetch"), 32);
        TableWrapData layoutData = new TableWrapData(2, 32, 1, 2);
        this.fAcceptBeforeFetchButton.setLayoutData((Object)layoutData);
        this.fAcceptBeforeFetchButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.fAcceptBeforeFetchButton.addSelectionListener(this.getAcceptBeforeFetchSelectionListener());
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.buildOnlyIfChanges");
        this.fBuildOnlyIfChangesButton = this.fToolkit.createButton(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CHANGES_DESC, (Object)"team.scm.buildOnlyIfChanges"), 32);
        layoutData = new TableWrapData(2, 32, 1, 2);
        this.fBuildOnlyIfChangesButton.setLayoutData((Object)layoutData);
        this.fBuildOnlyIfChangesButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.fBuildOnlyIfChangesButton.addSelectionListener(this.getBuildOnlyIfChangesSelectionListener());
        this.fBuildOnlyIfChangesButton.setEnabled(this.fAcceptBeforeFetchButton.getSelection());
        this.createSpacer(composite, 5, 2);
        Label label = this.fToolkit.createLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_OPTIONS_PROPERTY, (Object)"team.scm.acceptBeforeFetch", (Object)"team.scm.buildOnlyIfChanges"), 64);
        label.setForeground(Display.getDefault().getSystemColor(16));
        layoutData = new TableWrapData(2, 32, 1, 2);
        label.setLayoutData((Object)layoutData);
    }

    protected IHyperlinkListener getWorkspaceHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                JazzScmConfigurationEditor.this.openWorkspaceEditor();
            }
        };
    }

    protected void openWorkspaceEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TeamPlacePart2.open((IWorkbenchPage)page, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)this.fWorkspace)));
        }
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    protected void handleUpdateWorkspaceText(final String workspaceName) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!JazzScmConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                    JazzScmConfigurationEditor.this.setWorkspaceNameText(workspaceName, true);
                }
            }
        });
    }

    private void handleUpdateComponentLoadRulesButton(final IWorkspace workspace) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (JazzScmConfigurationEditor.this.fSelectComponentLoadRulesButton != null && !JazzScmConfigurationEditor.this.fSelectComponentLoadRulesButton.isDisposed()) {
                    JazzScmConfigurationEditor.this.fSelectComponentLoadRulesButton.setEnabled(workspace != null);
                }
            }
        });
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        if (this.fWorkspaceNameText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fWorkspaceNameText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_REQUIRED, (Control)this.fWorkspaceNameText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fWorkspaceNameText, (Control)this.fWorkspaceNameText);
        }
        if (this.fFetchDestinationText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fFetchDestinationText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_DIRECTORY_REQUIRED, (Control)this.fFetchDestinationText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fFetchDestinationText, (Control)this.fFetchDestinationText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    @Override
    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    private ModifyListener getFetchDestinationModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JazzScmConfigurationEditor.this.validate();
                IBuildProperty property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.fetchDestination");
                String destination = JazzScmConfigurationEditor.this.fFetchDestinationText.getText().trim();
                property.setValue(destination);
                if (destination.length() == 0) {
                    JazzScmConfigurationEditor.this.fDeleteBeforeFetchButton.setSelection(false);
                    JazzScmConfigurationEditor.this.fDeleteBeforeFetchButton.setEnabled(false);
                    JazzScmConfigurationEditor.this.getDeleteBeforeFetchSelectionListener().widgetSelected(null);
                } else {
                    JazzScmConfigurationEditor.this.fDeleteBeforeFetchButton.setEnabled(true);
                }
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getSelectWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.setWorkspace(JazzScmConfigurationEditor.this.openWorkspaceChooserDialog(JazzScmConfigurationEditor.this.fWorkspaceTitleHyperlink.getShell(), JazzScmConfigurationEditor.this.getTeamRepository()));
            }
        };
    }

    protected SelectionListener getCreateWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.openWorkspaceCreationDialog();
            }
        };
    }

    protected SelectionListener getClearComponentLoadRulesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBuildProperty property;
                if (JazzScmConfigurationEditor.this.confirmClearComponentLoadRules() && (property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.componentLoadRules")) != null) {
                    JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperties().remove(property);
                    JazzScmConfigurationEditor.this.fComponentLoadRulesText.setText("");
                    JazzScmConfigurationEditor.this.validate();
                    JazzScmConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    protected boolean confirmClearComponentLoadRules() {
        return MessageDialog.openConfirm((Shell)this.fClearComponentLoadRulesButton.getShell(), (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CLEAR_LOADRULES_CONFIRM_TITLE, (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CLEAR_LOADRULES_CONFIRM_TEXT);
    }

    protected SelectionListener getSelectComponentLoadRulesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Map initialSelection = JazzScmConfigurationEditor.this.fComponentLoadRules != null ? JazzScmConfigurationEditor.this.fComponentLoadRules.getLoadRuleFiles() : Collections.EMPTY_MAP;
                Map<IComponentHandle, IFileItemHandle> componentLoadRuleFiles = JazzScmConfigurationEditor.this.openComponentLoadRulesSelector(initialSelection);
                JazzScmConfigurationEditor.this.setComponentLoadRules(componentLoadRuleFiles);
            }
        };
    }

    protected Map<IComponentHandle, IFileItemHandle> openComponentLoadRulesSelector(Map<IComponentHandle, IFileItemHandle> initialSelection) {
        Map componentLoadRuleFiles = FileSelectionDialog.pickFilePerComponent((Shell)this.fWorkspaceTitleHyperlink.getShell(), (ITeamRepository)this.getTeamRepository(), (IWorkspace)this.fWorkspace, (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PICK_COMPONENT_LOAD_RULES_FILE, initialSelection);
        return componentLoadRuleFiles;
    }

    protected void setComponentLoadRules(Map<IComponentHandle, IFileItemHandle> componentLoadRuleFiles) {
        if (componentLoadRuleFiles != null) {
            this.fComponentLoadRules = new ComponentLoadRules(componentLoadRuleFiles);
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.componentLoadRules");
            String componentLoadRulesProperty = this.fComponentLoadRules.getBuildPropertySetting();
            if (property == null) {
                this.fBuildDefinitionWorkingCopy.getProperties().add(this.createBuildProperty("team.scm.componentLoadRules", this.fComponentLoadRules.getBuildPropertySetting(), ""));
            } else {
                property.setValue(componentLoadRulesProperty);
            }
            this.updateComponentLoadRules(this.fComponentLoadRules);
            this.validate();
            this.setDirty(true);
        }
    }

    protected void updateComponentLoadRules(ComponentLoadRules rules) {
        int numLoadRules = this.fComponentLoadRules.getLoadRuleFiles().values().size();
        if (numLoadRules == 0) {
            this.fComponentLoadRulesText.setText("");
        } else {
            String messageId = numLoadRules > 1 ? BuildDefinitionEditorMessages.JazzScmConfigurationEditor_NUMBER_OF_LOADRULE_FILES_TEXT_MULTI : BuildDefinitionEditorMessages.JazzScmConfigurationEditor_NUMBER_OF_LOADRULE_FILES_TEXT;
            this.fComponentLoadRulesText.setText(NLS.bind((String)messageId, (Object)numLoadRules));
        }
    }

    private IBuildProperty createBuildProperty(String name, String value, String description) {
        IBuildProperty buildProp = BuildItemFactory.createBuildProperty();
        buildProp.setName(name);
        buildProp.setValue(value);
        buildProp.setDescription(description);
        return buildProp;
    }

    protected void setWorkspace(IWorkspace workspace) {
        if (workspace != null) {
            Dialog dialog;
            int result;
            this.fWorkspace = workspace;
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.workspaceUUID");
            property.setValue(workspace.getItemId().getUuidValue());
            this.setWorkspaceNameText(workspace.getName(), true);
            this.validate();
            this.setDirty(true);
            if (this.shouldShowWorkspaceOwnerWarning() && (result = (dialog = this.getWorkspaceOwnerWarningDialog()).open()) == 0) {
                this.openWorkspaceEditor();
            }
            if (this.fSelectComponentLoadRulesButton != null && !this.fSelectComponentLoadRulesButton.isDisposed()) {
                this.fSelectComponentLoadRulesButton.setEnabled(true);
            }
        }
    }

    private boolean shouldShowWorkspaceOwnerWarning() {
        return BuildUIPlugin.getDefault().getPreferenceStore().getBoolean(PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING);
    }

    protected Dialog getWorkspaceOwnerWarningDialog() {
        return new MessageDialog(this.fWorkspaceTitleHyperlink.getShell(), BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_OWNER_WARNING_TITLE, null, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_OWNER_WARNING_MESSAGE, 2, new String[]{BuildDefinitionEditorMessages.JazzScmConfigurationEditor_OPEN_WORKSPACE_BUTTON, IDialogConstants.OK_LABEL}, 1){

            protected Control createCustomArea(Composite parent) {
                new Label(parent, 0);
                JazzScmConfigurationEditor.this.fDontShowWarningButton = new Button(parent, 32);
                JazzScmConfigurationEditor.this.fDontShowWarningButton.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DONT_SHOW_WARNING_AGAIN);
                JazzScmConfigurationEditor.this.fDontShowWarningButton.addSelectionListener(JazzScmConfigurationEditor.this.getDontShowWarningButtonListener());
                return JazzScmConfigurationEditor.this.fDontShowWarningButton;
            }
        };
    }

    protected SelectionListener getDontShowWarningButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildUIPlugin.getDefault().getPreferenceStore().setValue(JazzScmConfigurationEditor.PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING, !JazzScmConfigurationEditor.this.fDontShowWarningButton.getSelection());
                BuildUIPlugin.getDefault().savePluginPreferences();
            }
        };
    }

    protected SelectionListener getDeleteBeforeFetchSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                IBuildProperty property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.deleteDestinationBeforeFetch");
                property.setValue(Boolean.toString(JazzScmConfigurationEditor.this.fDeleteBeforeFetchButton.getSelection()));
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getAcceptBeforeFetchSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                IBuildProperty property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.acceptBeforeFetch");
                property.setValue(Boolean.toString(JazzScmConfigurationEditor.this.fAcceptBeforeFetchButton.getSelection()));
                JazzScmConfigurationEditor.this.fBuildOnlyIfChangesButton.setSelection(JazzScmConfigurationEditor.this.fAcceptBeforeFetchButton.getSelection());
                JazzScmConfigurationEditor.this.fBuildOnlyIfChangesButton.setEnabled(JazzScmConfigurationEditor.this.fAcceptBeforeFetchButton.getSelection());
                JazzScmConfigurationEditor.this.getBuildOnlyIfChangesSelectionListener().widgetSelected(null);
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getBuildOnlyIfChangesSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                IBuildProperty property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.buildOnlyIfChanges");
                property.setValue(Boolean.toString(JazzScmConfigurationEditor.this.fBuildOnlyIfChangesButton.getSelection()));
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.WORKSPACES, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    protected void openWorkspaceCreationDialog() {
        NewWorkspaceWizard wizard = new NewWorkspaceWizard(UIContext.createPartContext((IWorkbenchPart)this), false, (IPartResult)new IPartResult<AbstractPlaceWrapper>(){

            public void setResult(AbstractPlaceWrapper result) {
                JazzScmConfigurationEditor.this.setWorkspace(result.getWorkspace());
            }
        });
        new WizardDialog(this.fWorkspaceTitleHyperlink.getShell(), (IWizard)wizard).open();
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    @Override
    public Control getFocusControl() {
        return this.fSelectWorkspaceButton;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionjazzscm";
    }
}

