/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildResultPruningPolicy;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.EditBuildEngineActionDelegate;
import com.ibm.team.build.internal.ui.dialogs.CreateBuildEngineDialog;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineEditorMessages;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralConfigurationEditor
extends AbstractConfigurationElementEditor {
    private static final int MONITORING_THRESHOLD_DEFAULT = 3;
    private static final int TEXT_FIELD_WIDTH_NUMBER = 25;
    private Section fGeneralSection;
    private Section fPruningSection;
    private Section fBuildEnginesSection;
    protected Text fDescriptionText;
    protected Label fSuccessfulResultsToKeepLabel;
    protected Text fSuccessfulResultsToKeepText;
    protected Label fFailedResultsToKeepLabel;
    protected Text fFailedResultsToKeepText;
    protected Button fPruneButton;
    protected Button fIgnoreWarningsButton;
    protected CheckboxTableViewer fBuildEnginesTableViewer;
    protected Button fSelectAllEnginesButton;
    protected Button fDeselectAllEnginesButton;
    protected Button fCreateEngineButton;
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private FormToolkit fToolkit;
    protected Map<String, IBuildEngine> fBuildEngines = new HashMap<String, IBuildEngine>();
    private Map<String, IBuildEngine> fChangedBuildEngines = new HashMap<String, IBuildEngine>();

    public GeneralConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.createGeneralSection(parent);
        this.createBuildEngineSection(parent);
        this.createPruningPolicySection(parent);
        this.validate();
    }

    private void createGeneralSection(Composite parent) {
        this.fGeneralSection = this.fToolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, 10);
        this.fGeneralSection.setLayoutData((Object)data);
        this.fGeneralSection.setLayout((Layout)new GridLayout(1, false));
        this.fGeneralSection.setText(BuildDefinitionEditorMessages.BuildDefinitionEditor_GENERAL_INFORMATION_TITLE);
        this.fGeneralSection.setDescription(BuildDefinitionEditorMessages.BuildDefinitionEditor_GENERAL_INFORMATION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fGeneralSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_DESCRIPTION_LABEL);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        label.setLayoutData((Object)gridData);
        this.fDescriptionText = this.fToolkit.createText(composite, this.fBuildDefinitionWorkingCopy.getDescription(), 2626);
        gridData = new GridData(768);
        gridData.heightHint = 60;
        gridData.horizontalSpan = 2;
        this.fDescriptionText.setLayoutData((Object)gridData);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralConfigurationEditor.this.fBuildDefinitionWorkingCopy.setDescription(GeneralConfigurationEditor.this.fDescriptionText.getText().trim());
                GeneralConfigurationEditor.this.setDirty(true);
            }
        });
        Label spacingLabel = this.fToolkit.createLabel(composite, "");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        spacingLabel.setLayoutData((Object)gridData);
        this.fIgnoreWarningsButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_IGNORE_WARNINGS, 32);
        this.fIgnoreWarningsButton.setToolTipText(BuildDefinitionEditorMessages.BuildDefinitionEditor_IGNORE_WARNINGS_TOOLTIP);
        this.fIgnoreWarningsButton.setSelection(this.fBuildDefinitionWorkingCopy.isIgnoreWarnings());
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.fIgnoreWarningsButton.setLayoutData((Object)gridData);
        this.fIgnoreWarningsButton.addSelectionListener(this.getIgnoreWarningsButtonListener());
        this.fGeneralSection.setClient((Control)composite);
    }

    protected void createBuildEngineSection(Composite parent) {
        this.fBuildEnginesSection = this.fToolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fGeneralSection, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50);
        data.bottom = new FormAttachment(100, 10);
        this.fBuildEnginesSection.setLayoutData((Object)data);
        this.fBuildEnginesSection.setLayout((Layout)new GridLayout(1, false));
        this.fBuildEnginesSection.setText(BuildDefinitionEditorMessages.GeneralConfigurationEditor_SUPPORTING_ENGINES_TITLE);
        this.fBuildEnginesSection.setDescription(BuildDefinitionEditorMessages.GeneralConfigurationEditor_SUPPORTING_ENGINES_DESC);
        Composite composite = this.fToolkit.createComposite((Composite)this.fBuildEnginesSection);
        this.fToolkit.setBorderStyle(2048);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        Table table = this.fToolkit.createTable(composite, 66336);
        GridData gridData = new GridData(4, -1, true, false);
        gridData.heightHint = table.getItemHeight() * 10;
        table.setLayoutData((Object)gridData);
        this.fBuildEnginesTableViewer = new CheckboxTableViewer(table);
        this.fBuildEnginesTableViewer.setComparator(new ViewerComparator());
        this.fBuildEnginesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fBuildEnginesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return BuildUIPlugin.getImage("icons/obj16/build_engine_obj.gif");
            }
        });
        this.fBuildEnginesTableViewer.setInput(this.fBuildEngines.keySet());
        this.fBuildEnginesTableViewer.setCheckedElements(this.getSupportingEngineIds().toArray());
        this.fBuildEnginesTableViewer.addCheckStateListener(this.getCheckStateListener());
        this.fBuildEnginesTableViewer.addDoubleClickListener(this.getDoubleClickListener());
        this.createButtonBar(composite);
        this.fBuildEnginesSection.setClient((Control)composite);
    }

    protected IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                String engineId;
                IBuildEngine buildEngine;
                IStructuredSelection selection = (IStructuredSelection)GeneralConfigurationEditor.this.fBuildEnginesTableViewer.getSelection();
                if (selection.size() == 1 && (buildEngine = GeneralConfigurationEditor.this.fBuildEngines.get(engineId = (String)selection.getFirstElement())) != null && !buildEngine.isNewItem()) {
                    EditBuildEngineActionDelegate.run(buildEngine, GeneralConfigurationEditor.this.getSite().getPage());
                }
            }
        };
    }

    protected ICheckStateListener getCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                GeneralConfigurationEditor.this.updateChangedBuildEngines();
                GeneralConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private void createPruningPolicySection(Composite parent) {
        IBuildResultPruningPolicy policy = this.fBuildDefinitionWorkingCopy.getBuildResultPruningPolicy();
        this.fPruningSection = this.fToolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fGeneralSection, 10);
        data.left = new FormAttachment((Control)this.fBuildEnginesSection, 10);
        data.right = new FormAttachment(100, 10);
        data.bottom = new FormAttachment(100, 10);
        this.fPruningSection.setLayoutData((Object)data);
        this.fPruningSection.setLayout((Layout)new GridLayout(1, false));
        this.fPruningSection.setText(BuildDefinitionEditorMessages.BuildDefinitionEditor_PRUNING_POLICY_TITLE);
        this.fPruningSection.setDescription(BuildDefinitionEditorMessages.BuildDefinitionEditor_PRUNING_POLICY_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fPruningSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.fPruneButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_PRUNE_BUILD_RESULTS_CHECKBOX_LABEL, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fPruneButton.setLayoutData((Object)gridData);
        this.fPruneButton.setSelection(policy.isEnabled());
        this.fPruneButton.addSelectionListener(this.getPruningButtonListener());
        this.fSuccessfulResultsToKeepLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_SUCCESSFUL_BUILDS_LABEL);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        this.fSuccessfulResultsToKeepLabel.setLayoutData((Object)gridData);
        this.fSuccessfulResultsToKeepLabel.setEnabled(this.fPruneButton.getSelection());
        this.fSuccessfulResultsToKeepText = this.fToolkit.createText(composite, String.valueOf(policy.getSuccessfulResultsToKeep()), 2052);
        gridData = new GridData(25, -1);
        this.fSuccessfulResultsToKeepText.setLayoutData((Object)gridData);
        this.fSuccessfulResultsToKeepText.setEnabled(this.fPruneButton.getSelection());
        this.fSuccessfulResultsToKeepText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralConfigurationEditor.this.validate();
                if (GeneralConfigurationEditor.this.isPositiveInteger(GeneralConfigurationEditor.this.fSuccessfulResultsToKeepText.getText())) {
                    GeneralConfigurationEditor.this.fBuildDefinitionWorkingCopy.getBuildResultPruningPolicy().setSuccessfulResultsToKeep(Integer.parseInt(GeneralConfigurationEditor.this.fSuccessfulResultsToKeepText.getText()));
                }
                GeneralConfigurationEditor.this.setDirty(true);
            }
        });
        this.fFailedResultsToKeepLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_FAILED_BUILDS_LABEL);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        this.fFailedResultsToKeepLabel.setLayoutData((Object)gridData);
        this.fFailedResultsToKeepLabel.setEnabled(this.fPruneButton.getSelection());
        this.fFailedResultsToKeepText = this.fToolkit.createText(composite, String.valueOf(policy.getFailedResultsToKeep()), 2052);
        gridData = new GridData(25, -1);
        this.fFailedResultsToKeepText.setLayoutData((Object)gridData);
        this.fFailedResultsToKeepText.setEnabled(this.fPruneButton.getSelection());
        this.fFailedResultsToKeepText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralConfigurationEditor.this.validate();
                if (GeneralConfigurationEditor.this.isPositiveInteger(GeneralConfigurationEditor.this.fFailedResultsToKeepText.getText())) {
                    GeneralConfigurationEditor.this.fBuildDefinitionWorkingCopy.getBuildResultPruningPolicy().setFailedResultsToKeep(Integer.parseInt(GeneralConfigurationEditor.this.fFailedResultsToKeepText.getText()));
                }
                GeneralConfigurationEditor.this.setDirty(true);
            }
        });
        this.fPruningSection.setClient((Control)composite);
    }

    protected IBuildEngine[] getBuildEnginesToSave() {
        LinkedList<IBuildEngine> enginesToSave = new LinkedList<IBuildEngine>();
        enginesToSave.addAll(this.fChangedBuildEngines.values());
        return enginesToSave.toArray(new IBuildEngine[enginesToSave.size()]);
    }

    private IBuildDefinitionHandle getSupportedDefinition(IBuildEngine engine, IBuildDefinitionHandle buildDefinitionHandle) {
        for (Object object : engine.getSupportedBuildDefinitions()) {
            IBuildDefinitionHandle supportedDefinition = (IBuildDefinitionHandle)object;
            if (!supportedDefinition.getItemId().equals((Object)buildDefinitionHandle.getItemId())) continue;
            return supportedDefinition;
        }
        return null;
    }

    protected void updateChangedBuildEngines() {
        for (String engineId : this.fBuildEngines.keySet()) {
            IBuildEngine engine = (IBuildEngine)this.fBuildEngines.get(engineId).getWorkingCopy();
            IBuildDefinitionHandle supportedDefinition = this.getSupportedDefinition(engine, (IBuildDefinitionHandle)this.fBuildDefinitionWorkingCopy);
            if (this.fBuildEnginesTableViewer.getChecked((Object)engineId)) {
                if (supportedDefinition == null) {
                    engine.getSupportedBuildDefinitions().add(this.fBuildDefinitionWorkingCopy);
                    this.fChangedBuildEngines.put(engineId, engine);
                }
            } else if (supportedDefinition != null) {
                engine.getSupportedBuildDefinitions().remove(supportedDefinition);
                this.fChangedBuildEngines.put(engineId, engine);
            }
            this.fBuildEngines.put(engineId, engine);
        }
    }

    private List<String> getSupportingEngineIds() {
        LinkedList<String> supportingEngineIds = new LinkedList<String>();
        for (IBuildEngine engine : this.fBuildEngines.values()) {
            for (Object object : engine.getSupportedBuildDefinitions()) {
                IBuildDefinitionHandle definition = (IBuildDefinitionHandle)object;
                if (!definition.getItemId().equals((Object)this.fBuildDefinitionWorkingCopy.getItemId())) continue;
                supportingEngineIds.add(engine.getId());
            }
        }
        return supportingEngineIds;
    }

    private void createButtonBar(Composite parent) {
        Composite buttonBar = this.fToolkit.createComposite(parent);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.fSelectAllEnginesButton = this.fToolkit.createButton(buttonBar, BuildEngineEditorMessages.SELECT_ALL_LABEL, 8);
        this.fSelectAllEnginesButton.setEnabled(false);
        this.fSelectAllEnginesButton.addSelectionListener((SelectionListener)this.getSelectAllEnginesListener());
        this.fDeselectAllEnginesButton = this.fToolkit.createButton(buttonBar, BuildEngineEditorMessages.SELECT_NONE_LABEL, 8);
        this.fDeselectAllEnginesButton.setEnabled(false);
        this.fDeselectAllEnginesButton.addSelectionListener((SelectionListener)this.getDeselectAllEnginesListener());
        this.fCreateEngineButton = this.fToolkit.createButton(buttonBar, BuildDefinitionEditorMessages.GeneralConfigurationEditor_CREATE_ENGINE, 8);
        this.fCreateEngineButton.addSelectionListener((SelectionListener)this.getCreateNewEngineListener());
        this.fCreateEngineButton.setEnabled(false);
        this.setButtonLayoutData();
    }

    protected SelectionAdapter getSelectAllEnginesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralConfigurationEditor.this.fBuildEnginesTableViewer.setAllChecked(true);
                GeneralConfigurationEditor.this.updateChangedBuildEngines();
                GeneralConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionAdapter getDeselectAllEnginesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralConfigurationEditor.this.fBuildEnginesTableViewer.setAllChecked(false);
                GeneralConfigurationEditor.this.updateChangedBuildEngines();
                GeneralConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionAdapter getCreateNewEngineListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBuildEngineDialog dialog = GeneralConfigurationEditor.this.getCreateBuildEngineDialog();
                if (dialog.open() == 0) {
                    GeneralConfigurationEditor.this.createBuildEngine(dialog.getEngineId());
                }
            }
        };
    }

    protected IBuildEngine createBuildEngine(String engineId) {
        IBuildEngine engine = BuildItemFactory.createBuildEngine();
        engine.setId(engineId);
        engine.setTeamArea(this.fBuildDefinitionWorkingCopy.getTeamArea());
        engine.setActive(true);
        engine.setMonitoringThreshold(3);
        engine.getSupportedBuildDefinitions().add(this.fBuildDefinitionWorkingCopy);
        this.fBuildEnginesTableViewer.add((Object)engine.getId());
        this.fBuildEnginesTableViewer.setChecked((Object)engine.getId(), true);
        this.fBuildEngines.put(engine.getId(), engine);
        this.fChangedBuildEngines.put(engine.getId(), engine);
        this.setDirty(true);
        return engine;
    }

    private IBuildEngine addSupportedDefinition(String engineId) {
        IBuildEngine workingCopy = (IBuildEngine)this.fBuildEngines.get(engineId).getWorkingCopy();
        workingCopy.getSupportedBuildDefinitions().add(this.fBuildDefinitionWorkingCopy);
        this.fBuildEngines.put(workingCopy.getId(), workingCopy);
        this.fChangedBuildEngines.put(workingCopy.getId(), workingCopy);
        this.fBuildEnginesTableViewer.setChecked((Object)workingCopy.getId(), true);
        this.setDirty(true);
        return workingCopy;
    }

    protected CreateBuildEngineDialog getCreateBuildEngineDialog() {
        return new CreateBuildEngineDialog(this.fCreateEngineButton.getShell(), (Collection<String>)this.fBuildEngines.keySet());
    }

    private void setButtonLayoutData() {
        GC gc = new GC((Drawable)this.fSelectAllEnginesButton);
        gc.setFont(this.fSelectAllEnginesButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fSelectAllEnginesButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fDeselectAllEnginesButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fCreateEngineButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fSelectAllEnginesButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fDeselectAllEnginesButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fCreateEngineButton.setLayoutData((Object)gridData);
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        if (!this.fPruneButton.getSelection()) {
            this.removeErrorMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fSuccessfulResultsToKeepText);
            this.removeErrorMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fFailedResultsToKeepText);
            return isValid;
        }
        if (this.isPositiveInteger(this.fSuccessfulResultsToKeepText.getText())) {
            this.removeErrorMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fSuccessfulResultsToKeepText);
        } else {
            this.addErrorMessage((Object)BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fSuccessfulResultsToKeepText);
            isValid = false;
        }
        if (this.isPositiveInteger(this.fFailedResultsToKeepText.getText())) {
            this.removeErrorMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fFailedResultsToKeepText);
        } else {
            this.addErrorMessage((Object)BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fFailedResultsToKeepText);
            isValid = false;
        }
        if (isValid) {
            this.removeErrorMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fSuccessfulResultsToKeepText);
            this.removeErrorMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fFailedResultsToKeepText);
            this.setPageErrorIndicator(false);
        } else {
            this.setPageErrorIndicator(true);
        }
        return isValid;
    }

    protected SelectionListener getPruningButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralConfigurationEditor.this.fBuildDefinitionWorkingCopy.getBuildResultPruningPolicy().setEnabled(GeneralConfigurationEditor.this.fPruneButton.getSelection());
                GeneralConfigurationEditor.this.validate();
                GeneralConfigurationEditor.this.setDirty(true);
                GeneralConfigurationEditor.this.fSuccessfulResultsToKeepLabel.setEnabled(GeneralConfigurationEditor.this.fPruneButton.getSelection());
                GeneralConfigurationEditor.this.fSuccessfulResultsToKeepText.setEnabled(GeneralConfigurationEditor.this.fPruneButton.getSelection());
                GeneralConfigurationEditor.this.fFailedResultsToKeepLabel.setEnabled(GeneralConfigurationEditor.this.fPruneButton.getSelection());
                GeneralConfigurationEditor.this.fFailedResultsToKeepText.setEnabled(GeneralConfigurationEditor.this.fPruneButton.getSelection());
            }
        };
    }

    protected SelectionListener getIgnoreWarningsButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralConfigurationEditor.this.fBuildDefinitionWorkingCopy.setIgnoreWarnings(GeneralConfigurationEditor.this.fIgnoreWarningsButton.getSelection());
                GeneralConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private boolean isPositiveInteger(String number) {
        try {
            int i = Integer.parseInt(number);
            return i > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    protected void initializeBuildEngines(Collection<IBuildEngine> buildEngines, boolean isNewDefinition) {
        this.fBuildEngines.clear();
        this.fChangedBuildEngines.clear();
        for (IBuildEngine buildEngine : buildEngines) {
            this.fBuildEngines.put(buildEngine.getId(), buildEngine);
        }
        if (this.fBuildEnginesTableViewer != null && !this.fBuildEnginesTableViewer.getTable().isDisposed()) {
            if (isNewDefinition) {
                this.createOrAssociateDefaultBuildEngine();
            }
            this.fBuildEnginesTableViewer.setInput(this.fBuildEngines.keySet());
            this.fBuildEnginesTableViewer.setCheckedElements(this.getSupportingEngineIds().toArray());
            this.fSelectAllEnginesButton.setEnabled(!this.fBuildEngines.isEmpty());
            this.fDeselectAllEnginesButton.setEnabled(!this.fBuildEngines.isEmpty());
            this.fCreateEngineButton.setEnabled(true);
        }
    }

    private void createOrAssociateDefaultBuildEngine() {
        IBuildEngine defaultEngine = this.fBuildEngines.get(IBuildEngine.DEFAULT_ENGINE_ID);
        if (this.fBuildEngines.isEmpty()) {
            IBuildEngine buildEngine = this.createBuildEngine(IBuildEngine.DEFAULT_ENGINE_ID);
            this.fBuildEngines.put(buildEngine.getId(), buildEngine);
            this.fChangedBuildEngines.put(buildEngine.getId(), buildEngine);
        } else if (this.fBuildEngines.size() == 1 && defaultEngine != null) {
            defaultEngine = this.addSupportedDefinition(defaultEngine.getId());
            this.fChangedBuildEngines.put(defaultEngine.getId(), defaultEngine);
        }
    }

    protected void buildEngineSaved(IBuildEngine buildEngine) {
        this.fBuildEngines.put(buildEngine.getId(), buildEngine);
        Iterator<Map.Entry<String, IBuildEngine>> iterator = this.fChangedBuildEngines.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, IBuildEngine> entry = iterator.next();
            IBuildEngine changedEngine = entry.getValue();
            if (!changedEngine.getItemId().equals((Object)buildEngine.getItemId())) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitiongeneral";
    }

    @Override
    public Control getFocusControl() {
        return this.fIgnoreWarningsButton;
    }

    protected Button getCreateBuildEngineButton() {
        return this.fCreateEngineButton;
    }

    protected Button getSelectAllEnginesButton() {
        return this.fSelectAllEnginesButton;
    }

    protected Button getDeselectAllEnginesButton() {
        return this.fDeselectAllEnginesButton;
    }
}

