/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.builddefinition.BuildConfigurationRegistry;
import com.ibm.team.build.common.builddefinition.IBuildDefinitionTemplate;
import com.ibm.team.build.common.model.BuildPhase;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.editors.builddefinition.ConfigurationEditingControl;
import com.ibm.team.build.internal.ui.editors.builddefinition.IConfigurationListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditConfigurationDialog
extends TrayDialog {
    protected TabFolder fTabFolder;
    protected IBuildDefinition fBuildDefinition;
    protected List<String> fSelectedUnspecifiedElementIds = new ArrayList<String>();
    protected List<String> fSelectedPreBuildElementIds = new ArrayList<String>();
    protected List<String> fSelectedPostBuildElementIds = new ArrayList<String>();
    protected List<String> fAvailableUnspecifiedElementIds;
    protected List<String> fAvailablePreBuildElementIds;
    protected List<String> fAvailablePostBuildElementIds;

    public EditConfigurationDialog(Shell parent, IBuildDefinition buildDefinition) {
        super(parent);
        this.fBuildDefinition = buildDefinition;
        for (Object object : this.fBuildDefinition.getConfigurationElements()) {
            IBuildConfigurationElement element = (IBuildConfigurationElement)object;
            if (element.getBuildPhase() == BuildPhase.UNSPECIFIED) {
                this.fSelectedUnspecifiedElementIds.add(element.getElementId());
                continue;
            }
            if (element.getBuildPhase() == BuildPhase.PRE_BUILD) {
                this.fSelectedPreBuildElementIds.add(element.getElementId());
                continue;
            }
            if (element.getBuildPhase() != BuildPhase.POST_BUILD) continue;
            this.fSelectedPostBuildElementIds.add(element.getElementId());
        }
        this.fAvailableUnspecifiedElementIds = this.getAvailableElements(buildDefinition, BuildPhase.UNSPECIFIED);
        this.fAvailablePreBuildElementIds = this.getAvailableElements(buildDefinition, BuildPhase.PRE_BUILD);
        this.fAvailablePostBuildElementIds = this.getAvailableElements(buildDefinition, BuildPhase.POST_BUILD);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        ConfigurationEditingControl editingControl;
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.widthHint = 400;
        label.setLayoutData((Object)gridData);
        label.setText(BuildDefinitionEditorMessages.EditConfigurationDialog_DESCRIPTION);
        this.fTabFolder = new TabFolder(composite, 128);
        gridData = new GridData(1808);
        this.fTabFolder.setLayoutData((Object)gridData);
        TabItem tabItem = new TabItem(this.fTabFolder, 0);
        tabItem.setText(BuildDefinitionEditorMessages.EditConfigurationDialog_PRE_BUILD);
        if (this.fAvailablePreBuildElementIds.size() > 0) {
            editingControl = new ConfigurationEditingControl((Composite)this.fTabFolder, true);
            editingControl.initialize(this.fAvailablePreBuildElementIds, this.fSelectedPreBuildElementIds);
            editingControl.addListener(this.getConfigurationListener());
            tabItem.setControl((Control)editingControl.getControl());
        } else {
            label = new Label((Composite)this.fTabFolder, 64);
            label.setText(BuildDefinitionEditorMessages.EditConfigurationDialog_NO_PRE_BUILD);
            tabItem.setControl((Control)label);
        }
        tabItem = new TabItem(this.fTabFolder, 0);
        tabItem.setText(BuildDefinitionEditorMessages.EditConfigurationDialog_POST_BUILD);
        if (this.fAvailablePostBuildElementIds.size() > 0) {
            editingControl = new ConfigurationEditingControl((Composite)this.fTabFolder, true);
            editingControl.initialize(this.fAvailablePostBuildElementIds, this.fSelectedPostBuildElementIds);
            editingControl.addListener(this.getConfigurationListener());
            tabItem.setControl((Control)editingControl.getControl());
        } else {
            label = new Label((Composite)this.fTabFolder, 64);
            label.setText(BuildDefinitionEditorMessages.EditConfigurationDialog_NO_POST_BUILD);
            tabItem.setControl((Control)label);
        }
        tabItem = new TabItem(this.fTabFolder, 0);
        tabItem.setText(BuildDefinitionEditorMessages.EditConfigurationDialog_OTHER);
        if (this.fAvailableUnspecifiedElementIds.size() > 0) {
            editingControl = new ConfigurationEditingControl((Composite)this.fTabFolder, false);
            editingControl.initialize(this.fAvailableUnspecifiedElementIds, this.fSelectedUnspecifiedElementIds);
            editingControl.addListener(this.getConfigurationListener());
            tabItem.setControl((Control)editingControl.getControl());
        } else {
            label = new Label((Composite)this.fTabFolder, 64);
            label.setText(BuildDefinitionEditorMessages.EditConfigurationDialog_NO_OTHER);
            tabItem.setControl((Control)label);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.build.ui.dialog_editconfiguration");
        return composite;
    }

    protected IConfigurationListener getConfigurationListener() {
        return new IConfigurationListener(){

            public void configurationChanged() {
                Button button = EditConfigurationDialog.this.getButton(0);
                button.setEnabled(true);
                if (EditConfigurationDialog.this.getConfigurationElementIds(EditConfigurationDialog.this.fBuildDefinition, BuildPhase.BUILD).length == 0) {
                    if (EditConfigurationDialog.this.fSelectedUnspecifiedElementIds.size() + EditConfigurationDialog.this.fSelectedPreBuildElementIds.size() + EditConfigurationDialog.this.fSelectedPostBuildElementIds.size() > 0) {
                        button.setEnabled(true);
                    } else {
                        button.setEnabled(false);
                    }
                }
            }
        };
    }

    private String[] getConfigurationElementIds(IBuildDefinition definition, BuildPhase buildPhase) {
        ArrayList<String> elementIds = new ArrayList<String>();
        for (Object object : definition.getConfigurationElements()) {
            IBuildConfigurationElement element = (IBuildConfigurationElement)object;
            if (element.getBuildPhase() != buildPhase) continue;
            elementIds.add(element.getElementId());
        }
        return elementIds.toArray(new String[elementIds.size()]);
    }

    private List<String> getAvailableElements(IBuildDefinition buildDefinition, BuildPhase buildPhase) {
        IBuildConfigurationElement element;
        ArrayList<String> availableElements = new ArrayList<String>();
        for (Object object : this.fBuildDefinition.getConfigurationElements()) {
            element = (IBuildConfigurationElement)object;
            if (element.getBuildPhase() != buildPhase) continue;
            availableElements.add(element.getElementId());
        }
        IBuildDefinitionTemplate template = null;
        IBuildProperty templateIdProperty = this.fBuildDefinition.getProperty("com.ibm.team.build.internal.template.id");
        if (templateIdProperty != null) {
            template = BuildConfigurationRegistry.getInstance().getBuildDefinitionTemplate(templateIdProperty.getValue());
        }
        if (template != null) {
            ArrayList templateElements = new ArrayList();
            templateElements.addAll(Arrays.asList(template.getConfigurationElementIds()));
            templateElements.addAll(Arrays.asList(template.getAvailableConfigurationElementIds()));
            for (String elementId : templateElements) {
                IBuildConfigurationElement element2;
                if (availableElements.contains(elementId) || (element2 = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement(elementId)) == null || element2.getBuildPhase() != buildPhase) continue;
                availableElements.add(elementId);
            }
        } else {
            IBuildConfigurationElement[] iBuildConfigurationElementArray = BuildConfigurationRegistry.getInstance().getBuildConfigurationElements();
            int n = iBuildConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                element = iBuildConfigurationElementArray[n2];
                if (element.getBuildPhase() == buildPhase && !availableElements.contains(element.getElementId())) {
                    availableElements.add(element.getElementId());
                }
                ++n2;
            }
        }
        return availableElements;
    }

    public List<String> getOrderedSelectedElementIds(BuildPhase buildPhase) {
        ArrayList<String> orderedSelectedElementIds = new ArrayList<String>();
        List<String> availableElementIds = null;
        List<String> selectedElementIds = null;
        if (buildPhase == BuildPhase.UNSPECIFIED) {
            availableElementIds = this.fAvailableUnspecifiedElementIds;
            selectedElementIds = this.fSelectedUnspecifiedElementIds;
        } else if (buildPhase == BuildPhase.PRE_BUILD) {
            availableElementIds = this.fAvailablePreBuildElementIds;
            selectedElementIds = this.fSelectedPreBuildElementIds;
        } else if (buildPhase == BuildPhase.POST_BUILD) {
            availableElementIds = this.fAvailablePostBuildElementIds;
            selectedElementIds = this.fSelectedPostBuildElementIds;
        }
        for (String elementId : availableElementIds) {
            if (!selectedElementIds.contains(elementId)) continue;
            orderedSelectedElementIds.add(elementId);
        }
        return orderedSelectedElementIds;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(BuildDefinitionEditorMessages.EditConfigurationDialog_TITLE);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        Button button = this.getButton(0);
        button.setEnabled(false);
        return control;
    }
}

