/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class CommandLineConfigurationEditor
extends AbstractConfigurationElementEditor {
    private static final int FIELD_SPACING = 20;
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private Section fSection;
    protected Text fCommandLineText;
    protected Text fArgumentsText;
    protected Text fWorkingDirText;
    protected Text fPropertiesFileText;
    private FormToolkit fToolkit;

    public CommandLineConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new TableWrapLayout());
        this.fSection = this.fToolkit.createSection(parent, 384);
        this.fSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.fSection.setLayout((Layout)new TableWrapLayout());
        this.fSection.setText(BuildDefinitionEditorMessages.CommandLineConfigurationEditor_SECTION_TITLE);
        this.fSection.setDescription(BuildDefinitionEditorMessages.CommandLineConfigurationEditor_SECTION_DESC);
        Composite composite = this.fToolkit.createComposite((Composite)this.fSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createCommandWidgets(composite);
        this.createArgumentsWidgets(composite);
        this.createPropertiesFileWidgets(composite);
        this.createWorkingDirWidgets(composite);
        this.fSection.setClient((Control)composite);
    }

    private void createCommandWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.cmdline");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.cmdline.command");
        this.createSpacer(parent, 5, 2);
        this.fCommandLineText = this.createLabeledText(parent, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_COMMAND_LABEL, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_COMMAND_DESC, property.getValue());
        this.fCommandLineText.addModifyListener(this.getCommandLineModifiedListener());
    }

    private void createArgumentsWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.cmdline");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.cmdline.arguments");
        this.createSpacer(parent, 20, 2);
        this.fArgumentsText = this.createLabeledText(parent, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_ARGUMENTS_LABEL, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_ARGUMENTS_DESCRIPTION, property.getValue());
        this.fArgumentsText.addModifyListener(this.getArgumentsModifiedListener());
    }

    private void createWorkingDirWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.cmdline");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.cmdline.workingDir");
        this.createSpacer(parent, 20, 2);
        this.fWorkingDirText = this.createLabeledText(parent, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_WORKING_DIR_LABEL, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_WORKING_DIR_DESC, property.getValue());
        this.fWorkingDirText.addModifyListener(this.getWorkingDirModifiedListener());
    }

    private void createPropertiesFileWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.cmdline");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.cmdline.propertiesFile");
        this.createSpacer(parent, 20, 2);
        this.fPropertiesFileText = this.createLabeledText(parent, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_PROPERTIES_LABEL, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_PROPERTIES_DESC, property.getValue());
        this.fPropertiesFileText.addModifyListener(this.getPropertiesFileModifiedListener());
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.fCommandLineText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fCommandLineText, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_COMMAND_REQUIRED, (Control)this.fCommandLineText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fCommandLineText, (Control)this.fCommandLineText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    private ModifyListener getCommandLineModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommandLineConfigurationEditor.this.validate();
                IBuildConfigurationElement element = CommandLineConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.cmdline");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.cmdline.command");
                property.setValue(CommandLineConfigurationEditor.this.fCommandLineText.getText().trim());
                CommandLineConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getArgumentsModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommandLineConfigurationEditor.this.validate();
                IBuildConfigurationElement element = CommandLineConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.cmdline");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.cmdline.arguments");
                property.setValue(CommandLineConfigurationEditor.this.fArgumentsText.getText().trim());
                CommandLineConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getWorkingDirModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommandLineConfigurationEditor.this.validate();
                IBuildConfigurationElement element = CommandLineConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.cmdline");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.cmdline.workingDir");
                property.setValue(CommandLineConfigurationEditor.this.fWorkingDirText.getText().trim());
                CommandLineConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getPropertiesFileModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommandLineConfigurationEditor.this.validate();
                IBuildConfigurationElement element = CommandLineConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.cmdline");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.cmdline.propertiesFile");
                property.setValue(CommandLineConfigurationEditor.this.fPropertiesFileText.getText().trim());
                CommandLineConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.fToolkit.createLabel(parent, label);
        Text text = this.fToolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(parent, description, 64);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        return text;
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    public Control getFocusControl() {
        return this.fCommandLineText;
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitioncommand";
    }
}

