/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildConfigurationElementEditorExtension;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

public class BuildConfigurationElementEditorExtensionManager {
    public static final String EXTENSION_POINT_ID_BUILD_CONFIGURATION_ELEMENT_EDITORS = "com.ibm.team.build.ui.buildConfigurationElementEditors";
    protected static BuildConfigurationElementEditorExtensionManager fManager = null;
    private BuildConfigurationElementEditorExtension[] fExtentions = this.loadBuildConfigurationElementEditorExtensions();

    protected BuildConfigurationElementEditorExtensionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildConfigurationElementEditorExtensionManager getInstance() {
        Class<BuildConfigurationElementEditorExtensionManager> clazz = BuildConfigurationElementEditorExtensionManager.class;
        synchronized (BuildConfigurationElementEditorExtensionManager.class) {
            if (fManager == null) {
                fManager = new BuildConfigurationElementEditorExtensionManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fManager;
        }
    }

    public BuildConfigurationElementEditorExtension[] getBuildConfigurationElementEditors() {
        return this.fExtentions;
    }

    public BuildConfigurationElementEditorExtension getBuildConfigurationElementEditor(String elementId) {
        BuildConfigurationElementEditorExtension[] buildConfigurationElementEditorExtensionArray = this.fExtentions;
        int n = this.fExtentions.length;
        int n2 = 0;
        while (n2 < n) {
            BuildConfigurationElementEditorExtension extension = buildConfigurationElementEditorExtensionArray[n2];
            if (extension.getElementIdAttribute().equals(elementId)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    protected IConfigurationElement[] getConfigurationElements(IExtensionPoint extensionPoint) {
        return extensionPoint.getConfigurationElements();
    }

    private BuildConfigurationElementEditorExtension[] loadBuildConfigurationElementEditorExtensions() {
        LinkedList<BuildConfigurationElementEditorExtension> extensions = new LinkedList<BuildConfigurationElementEditorExtension>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID_BUILD_CONFIGURATION_ELEMENT_EDITORS);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements = this.getConfigurationElements(extensionPoint);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configElement = configurationElements[i];
                try {
                    BuildConfigurationElementEditorExtension extension = new BuildConfigurationElementEditorExtension(configElement);
                    if (!extensions.contains(extension)) {
                        extensions.add(extension);
                    } else {
                        this.handleDuplicateExtensions(configElement);
                    }
                }
                catch (IllegalArgumentException exception) {
                    this.handleIllegalArgumentException(exception, configElement);
                }
                ++i;
            }
        }
        return extensions.toArray(new BuildConfigurationElementEditorExtension[extensions.size()]);
    }

    private void handleDuplicateExtensions(IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getAttribute("configurationElementId"), configElement.getContributor().getName()};
        String message = NLS.bind((String)BuildResultEditorMessages.BuildContributionManager_DUPLICATE_EXTENSION_POINT, (Object[])params);
        BuildUIPlugin.log(message);
    }

    private void handleIllegalArgumentException(IllegalArgumentException exception, IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getContributor().getName()};
        String message = NLS.bind((String)BuildResultEditorMessages.BuildContributionManager_MISSING_OR_INVALID, (Object[])params);
        BuildUIPlugin.log(message);
    }

    private String getExtensionFQN(IConfigurationElement configElement) {
        return String.valueOf(configElement.getNamespaceIdentifier()) + "." + configElement.getName();
    }
}

