/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.editors.BuildItemEditor;
import com.ibm.team.build.internal.ui.editors.Messages;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SaveEditorAction
extends ControlContribution {
    private final BuildItemEditor fEditor;
    private Button fSaveButton;

    public SaveEditorAction(BuildItemEditor editor) {
        super("SaveEditorAction.id");
        ValidationHelper.validateNotNull((String)"editor", (Object)((Object)editor));
        this.fEditor = editor;
    }

    protected BuildItemEditor getEditor() {
        return this.fEditor;
    }

    protected Button getSaveButton() {
        return this.fSaveButton;
    }

    protected Control createControl(Composite parent) {
        this.fSaveButton = this.getToolkit().createButton(parent, Messages.SaveEditorAction_SaveButtonLabel, 8);
        this.fSaveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveEditorAction.this.saveEditor();
            }
        });
        this.updateEnabledState();
        return this.fSaveButton;
    }

    protected void updateEnabledState() {
        boolean isEnabled = this.fEditor.isDirty() && !this.fEditor.isBusy();
        Button saveButton = this.getSaveButton();
        if (saveButton != null && !saveButton.isDisposed()) {
            saveButton.setEnabled(isEnabled);
        }
    }

    protected FormToolkit getToolkit() {
        return this.fEditor.getToolkit();
    }

    protected IManagedForm getHeaderForm() {
        return this.fEditor.getHeaderForm();
    }

    protected void saveEditor() {
        this.fEditor.getSite().getPage().saveEditor((IEditorPart)this.fEditor, false);
    }
}

