/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.BuildItemEditor;
import com.ibm.team.build.internal.ui.editors.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class RefreshEditorAction
extends Action {
    private final BuildItemEditor fEditor;
    private final Shell fEditorShell;

    public RefreshEditorAction(BuildItemEditor editor, Shell editorShell) {
        super(Messages.RefreshEditorAction_RefreshButtonToolTip);
        ValidationHelper.validateNotNull((String)"editor", (Object)((Object)editor));
        ValidationHelper.validateNotNull((String)"editorShell", (Object)editorShell);
        this.fEditor = editor;
        this.fEditorShell = editorShell;
        this.setImageDescriptor(BuildUIPlugin.getImageDescriptor("icons/elcl16/refresh.gif"));
    }

    protected void updateEnabledState() {
        if (this.fEditor.isBusy()) {
            this.setEnabled(false);
            return;
        }
        if (this.fEditor.isNewItem()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        if (this.fEditor.isDirty() && !this.confirmRefresh()) {
            return;
        }
        this.fEditor.refreshBuildItem();
    }

    protected boolean confirmRefresh() {
        return MessageDialog.openConfirm((Shell)this.fEditorShell, (String)Messages.RefreshEditorAction_RefreshConfirmDialogTitle, (String)Messages.RefreshEditorAction_EDITOR_MODIFIED);
    }
}

