/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.dialogs.tags.PromptForTagDialog;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.query.BuildQueryByTag;
import com.ibm.team.build.internal.ui.tags.TagContentProposalProvider;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowBuildsWithTagAction
extends Action {
    private final List<IBuildDefinitionHandle> fBuildDefinitionHandles;
    private final List<BuildDomainQueryNode> fBuildDefinitionQueryNodes;
    private IWorkbenchPartSite fPartSite;
    private String fQueryName;
    private IProjectAreaHandle fProjectAreaHandle;

    public ShowBuildsWithTagAction(String actionName, List<IBuildDefinitionHandle> buildDefinitionHandles, List<BuildDomainQueryNode> buildDefinitionQueryNodes, IWorkbenchPartSite parentPart) {
        super(actionName);
        ValidationHelper.validateNotNull((String)"buildDefinitionHandles", buildDefinitionHandles);
        ValidationHelper.validateNotEmpty((String)"buildDefinitionHandles", (Object[])buildDefinitionHandles.toArray());
        ValidationHelper.validateNotNullElements((String)"buildDefinitionHandles", (Object[])buildDefinitionHandles.toArray());
        ValidationHelper.validateNotNull((String)"buildDefinitionQueryNodes", buildDefinitionQueryNodes);
        ValidationHelper.validateNotEmpty((String)"buildDefinitionQueryNodes", (Object[])buildDefinitionQueryNodes.toArray());
        ValidationHelper.validateNotNullElements((String)"buildDefinitionQueryNodes", (Object[])buildDefinitionQueryNodes.toArray());
        this.fBuildDefinitionHandles = buildDefinitionHandles;
        this.fBuildDefinitionQueryNodes = buildDefinitionQueryNodes;
        this.fPartSite = parentPart;
    }

    public ShowBuildsWithTagAction(String actionName, IProjectAreaHandle projectAreaHandle, IWorkbenchPartSite parentPart) {
        super(actionName);
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        this.fProjectAreaHandle = projectAreaHandle;
        this.fBuildDefinitionHandles = null;
        this.fBuildDefinitionQueryNodes = null;
        this.fPartSite = parentPart;
    }

    public void run() {
        ITeamRepository teamRepository = this.getTeamRepository();
        String tag = this.promptForTag(this.fPartSite.getShell(), teamRepository);
        if (!tag.equals("")) {
            BuildQueryByTag query;
            if (this.fBuildDefinitionHandles == null) {
                this.fQueryName = NLS.bind((String)Messages.ShowBuildsWithTagAction_ACTION_NAME_ALL_BUILDS, (Object)tag);
                query = new BuildQueryByTag(this.fQueryName, null, AdaptableBuildQueryRow.Factory, this.fProjectAreaHandle, tag, teamRepository);
            } else {
                this.fQueryName = this.fBuildDefinitionQueryNodes.size() == 1 ? NLS.bind((String)Messages.BuildDomainActionHelper_TAG_QUERY_NAME_ONE_DEFINITION, (Object)this.fBuildDefinitionQueryNodes.get(0).getLabel(), (Object)tag) : NLS.bind((String)Messages.BuildDomainActionHelper_TAG_QUERY_NAME_MULTIPLE_DEFINITIONS, (Object)tag);
                query = new BuildQueryByTag(this.fQueryName, null, AdaptableBuildQueryRow.Factory, this.fBuildDefinitionHandles.toArray(new IBuildDefinitionHandle[this.fBuildDefinitionHandles.size()]), tag, teamRepository);
            }
            BuildQueryView.displayQuery(query, this.fPartSite.getPage());
        }
    }

    public String getId() {
        return Messages.BuildDomainActionHelper_ACTION_ID_TAG_QUERY;
    }

    protected ITeamRepository getTeamRepository() {
        if (this.fBuildDefinitionHandles == null) {
            return (ITeamRepository)this.fProjectAreaHandle.getOrigin();
        }
        return (ITeamRepository)this.fBuildDefinitionHandles.get(0).getOrigin();
    }

    protected String promptForTag(Shell shell, ITeamRepository teamRepository) {
        String tag = "";
        TagContentProposalProvider tagProvider = null;
        tagProvider = this.fBuildDefinitionHandles == null ? new TagContentProposalProvider(teamRepository, this.fProjectAreaHandle) : new TagContentProposalProvider(teamRepository, this.fBuildDefinitionHandles.toArray(new IBuildDefinitionHandle[this.fBuildDefinitionHandles.size()]));
        PromptForTagDialog dialog = new PromptForTagDialog(shell, tagProvider);
        this.openDialog(dialog);
        if (dialog.getReturnCode() == 0) {
            tag = dialog.getTags();
        }
        return tag;
    }

    protected int openDialog(PromptForTagDialog dialog) {
        return dialog.open();
    }

    public String getQueryName() {
        return this.fQueryName;
    }
}

