/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;

public abstract class BuildDomainProjectAreaQueryNode
extends BuildDomainQueryNode {
    private final IProjectAreaHandle fProjectAreaHandle;

    public BuildDomainProjectAreaQueryNode(IProjectAreaHandle projectAreaHandle, String label, int sortPosition) {
        super(BuildDomainProjectAreaQueryNode.getValidTeamRepository(projectAreaHandle), label, sortPosition);
        this.fProjectAreaHandle = projectAreaHandle;
    }

    private static ITeamRepository getValidTeamRepository(IProjectAreaHandle projectAreaHandle) throws IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        if (!(projectAreaHandle.getOrigin() instanceof ITeamRepository)) {
            throw new IllegalArgumentException(Messages.BuildDomainQueryNode_PROJECT_AREA_ORIGIN_NOT_SET_TO_REPOSITORY);
        }
        return (ITeamRepository)projectAreaHandle.getOrigin();
    }

    public IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }

    public int hashCode() {
        return this.getHashString().hashCode() + this.getQuery().hashCode();
    }

    private String getHashString() {
        return String.valueOf(this.fProjectAreaHandle.getItemId().toString()) + this.getLabel();
    }
}

