/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.internal.client.BuildRecordEventManager;
import com.ibm.team.build.internal.client.IBuildDefinitionStatusRecordListener;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildEngineStatusRecord;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.AbstractBuildFolderNode;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomain;
import com.ibm.team.build.internal.ui.domain.BuildDomainItemChangeListener;
import com.ibm.team.build.internal.ui.domain.BuildDomainProjectAreaQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEngineQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEnginesNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.build.internal.ui.listeners.BuildDefinitionStatusRecordListener;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryForBuildQueue;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDomainContentProvider
implements ITreeContentProvider,
ITreePathContentProvider,
IDeferredWorkbenchAdapter,
IConnectedProjectAreaRegistryListener {
    private AbstractTreeViewer fViewer;
    private DeferredTreeContentManager fDeferredTreeManager;
    private BuildDomain fBuildDomain;
    private final boolean fIncludeBuildEngines;
    private boolean fDisposed;
    private Map<IProjectAreaHandle, BuildEnginesNode> fBuildEnginesNodes = new HashMap<IProjectAreaHandle, BuildEnginesNode>();
    private Map<IProjectAreaHandle, DomainSubtreeRoot> fBuildsNodes = new HashMap<IProjectAreaHandle, DomainSubtreeRoot>();
    protected Map<IProjectAreaHandle, IBuildDefinitionStatusRecordListener> fDefinitionRecordListeners = new HashMap<IProjectAreaHandle, IBuildDefinitionStatusRecordListener>();
    protected Map<IProjectAreaHandle, BuildDomainItemChangeListener> fDefinitionItemListeners = new HashMap<IProjectAreaHandle, BuildDomainItemChangeListener>();
    protected Map<IProjectAreaHandle, BuildDomainItemChangeListener> fEngineItemListeners = new HashMap<IProjectAreaHandle, BuildDomainItemChangeListener>();
    private boolean fFetchInProgress;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];

    public BuildDomainContentProvider(BuildDomain domain, boolean includeBuildEngines) {
        this.fBuildDomain = domain;
        this.fIncludeBuildEngines = includeBuildEngines;
        this.fBuildDomain.getConnectedProjectAreaRegistry().addListener((IConnectedProjectAreaRegistryListener)this);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.fDisposed = true;
        this.fDeferredTreeManager = null;
        this.disposeListeners();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (AbstractTreeViewer)viewer;
        if (this.fDeferredTreeManager == null) {
            this.fDeferredTreeManager = new DeferredTreeContentManager(this, (AbstractTreeViewer)viewer, this.fBuildDomain.getWorkbenchPart().getSite()){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (BuildDomainContentProvider.this.hasChildren(element)) {
                        return BuildDomainContentProvider.this;
                    }
                    return super.getAdapter(element);
                }
            };
        }
    }

    public boolean hasChildren(TreePath path) {
        Object object = path.getLastSegment();
        return object instanceof DomainSubtreeRoot || object instanceof AbstractBuildFolderNode;
    }

    public Object[] getChildren(TreePath parentPath) {
        Object parentElement = parentPath.getLastSegment();
        if (parentElement instanceof DomainSubtreeRoot || parentElement instanceof AbstractBuildFolderNode) {
            return this.fDeferredTreeManager.getChildren((Object)parentPath);
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public TreePath[] getParents(Object element) {
        return EMPTY_TREEPATH_ARRAY;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreePath) {
            return this.hasChildren((TreePath)element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreePath) {
            return this.getChildren((TreePath)parentElement);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        TreePath parentPath = (TreePath)object;
        Object parent = parentPath.getLastSegment();
        BuildDomainContentProvider buildDomainContentProvider = this;
        synchronized (buildDomainContentProvider) {
            if (this.fFetchInProgress) {
                return;
            }
            this.fFetchInProgress = true;
        }
        try {
            monitor.beginTask("", -1);
            if (parent instanceof DomainSubtreeRoot) {
                this.getChildrenOfBuildDomain((DomainSubtreeRoot)parent, collector, monitor);
            } else if (parent instanceof BuildEnginesNode) {
                this.getChildrenOfBuildEnginesNode((BuildEnginesNode)parent, collector, monitor);
            }
        }
        finally {
            this.fFetchInProgress = false;
            collector.done();
            monitor.done();
        }
    }

    private void getChildrenOfBuildDomain(DomainSubtreeRoot parent, IElementCollector collector, IProgressMonitor monitor) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        this.fBuildsNodes.put(projectAreaHandle, parent);
        try {
            IBuildDefinitionStatusRecord[] statusRecords;
            this.removeDefinitionListeners(projectAreaHandle);
            ArrayList<BuildDefinitionQueryNode> nodes = new ArrayList<BuildDefinitionQueryNode>();
            IBuildDefinitionStatusRecord[] iBuildDefinitionStatusRecordArray = statusRecords = this.getBuildDefinitionStatusRecords(projectAreaHandle, monitor);
            int n = statusRecords.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildDefinitionStatusRecord record = iBuildDefinitionStatusRecordArray[n2];
                nodes.add(new BuildDefinitionQueryNode((ITeamRepository)projectAreaHandle.getOrigin(), record));
                ++n2;
            }
            collector.add(nodes.toArray(), monitor);
            this.addDefinitionListeners(projectAreaHandle, parent, nodes);
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
        }
        if (this.fIncludeBuildEngines) {
            collector.add((Object)this.getBuildEnginesNode(parent), monitor);
        }
    }

    private void addDefinitionListeners(IProjectAreaHandle projectAreaHandle, DomainSubtreeRoot parent, List<BuildDefinitionQueryNode> nodes) {
        BuildDomainItemChangeListener itemListener = new BuildDomainItemChangeListener(this, projectAreaHandle, parent, nodes);
        this.fDefinitionItemListeners.put(projectAreaHandle, itemListener);
        this.addDefinitionItemListener(projectAreaHandle, itemListener);
        BuildDefinitionStatusRecordListener recordListener = new BuildDefinitionStatusRecordListener((StructuredViewer)this.getTreeViewer(), nodes.toArray(new BuildDefinitionQueryNode[nodes.size()]));
        this.fDefinitionRecordListeners.put(projectAreaHandle, recordListener);
        BuildRecordEventManager.getInstance().addListener((IBuildDefinitionStatusRecordListener)recordListener);
    }

    private void removeDefinitionListeners(IProjectAreaHandle projectAreaHandle) {
        IBuildDefinitionStatusRecordListener oldRecordListener;
        AbstractBuildDefinitionChangeListener oldItemListener = this.fDefinitionItemListeners.get(projectAreaHandle);
        if (oldItemListener != null) {
            this.removeDefinitionItemListener(projectAreaHandle, oldItemListener);
            this.fDefinitionItemListeners.remove(projectAreaHandle);
        }
        if ((oldRecordListener = this.fDefinitionRecordListeners.get(projectAreaHandle)) != null) {
            BuildRecordEventManager.getInstance().removeListener(oldRecordListener);
            this.fDefinitionRecordListeners.remove(projectAreaHandle);
        }
    }

    private BuildEnginesNode getBuildEnginesNode(DomainSubtreeRoot parent) {
        IProjectAreaHandle projectAreaHandle;
        BuildEnginesNode node;
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        if ((node = this.fBuildEnginesNodes.get(projectAreaHandle = (IProjectAreaHandle)category)) == null) {
            node = new BuildEnginesNode(parent);
            this.fBuildEnginesNodes.put(projectAreaHandle, node);
        }
        return node;
    }

    private BuildDomainQueryNode getBuildQueueNode(final IProjectAreaHandle projectAreaHandle) {
        return new BuildDomainProjectAreaQueryNode(projectAreaHandle, Messages.BuildDomainContentProvider_BUILD_QUEUE_NODE_LABEL, 0){

            public BuildQuery getQuery() {
                return new BuildQueryForBuildQueue(Messages.BuildDomainActionHelper_QUERY_NAME_BUILD_QUEUE, null, AdaptableBuildQueryRow.Factory, projectAreaHandle, this.getTeamRepository());
            }

            public Image getImage() {
                return BuildUIPlugin.getImage("icons/elcl16/buildque.gif");
            }
        };
    }

    private IBuildDefinitionStatusRecord[] getBuildDefinitionStatusRecords(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)teamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        List teamAreaHandles = this.fBuildDomain.getConnectedProjectAreaRegistry().getSelectedTeamAreas(projectAreaHandle);
        return client.getBuildDefinitionStatusRecords(teamAreaHandles.toArray(new ITeamAreaHandle[teamAreaHandles.size()]), monitor);
    }

    private void getChildrenOfBuildEnginesNode(BuildEnginesNode parent, IElementCollector collector, IProgressMonitor monitor) {
        try {
            IProjectAreaHandle projectAreaHandle = parent.getProjectArea();
            AbstractBuildDefinitionChangeListener oldEngineListener = this.fEngineItemListeners.get(projectAreaHandle);
            if (oldEngineListener != null) {
                this.removeEngineItemListener(projectAreaHandle, oldEngineListener);
                this.fEngineItemListeners.remove(projectAreaHandle);
            }
            List<BuildEngineQueryNode> nodes = BuildDomainContentProvider.getBuildEngineQueryNodes(parent, monitor);
            collector.add((Object)this.getBuildQueueNode(parent.getProjectArea()), monitor);
            collector.add(nodes.toArray(), monitor);
            BuildDomainItemChangeListener engineListener = new BuildDomainItemChangeListener(this, projectAreaHandle, parent, nodes);
            this.fEngineItemListeners.put(projectAreaHandle, engineListener);
            this.addEngineItemListener(projectAreaHandle, engineListener);
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
        }
    }

    public static List<BuildEngineQueryNode> getBuildEngineQueryNodes(BuildEnginesNode parent, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)parent.getTeamRepository().getClientLibrary(ITeamBuildRecordClient.class);
        IProjectAreaHandle projectAreaHandle = parent.getProjectArea();
        IBuildEngineStatusRecord[] statusRecords = client.getBuildEngineStatusRecords(new IProjectAreaHandle[]{projectAreaHandle}, monitor);
        ArrayList<BuildEngineQueryNode> nodes = new ArrayList<BuildEngineQueryNode>();
        IBuildEngineStatusRecord[] iBuildEngineStatusRecordArray = statusRecords;
        int n = statusRecords.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildEngineStatusRecord statusRecord = iBuildEngineStatusRecordArray[n2];
            nodes.add(new BuildEngineQueryNode(projectAreaHandle, statusRecord));
            ++n2;
        }
        return nodes;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof TreePath) {
            TreePath path = (TreePath)object;
            Object lastSegement = path.getLastSegment();
            if (lastSegement instanceof DomainSubtreeRoot) {
                return Messages.BuildDomainContentProvider_BUILD_DOMAIN_NODE;
            }
            if (lastSegement instanceof AbstractBuildFolderNode) {
                return ((AbstractBuildFolderNode)lastSegement).getLabel();
            }
            if (lastSegement instanceof BuildDomainQueryNode) {
                return ((BuildDomainQueryNode)lastSegement).getLabel();
            }
            return object.toString();
        }
        return object.toString();
    }

    protected boolean fetchAndUpdate(BuildDefinitionQueryNode element) {
        TeamBuildJob job = this.getFetchBuildDefinitionStatusRecordJob(element);
        job.schedule();
        return true;
    }

    protected TeamBuildJob getFetchBuildDefinitionStatusRecordJob(final BuildDefinitionQueryNode element) {
        return new TeamBuildJob(NLS.bind((String)Messages.BuildDomainContentProvider_REFRESH_NODE_JOB_NAME, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IBuildDefinition definition = element.getBuildDefinition();
                ITeamBuildRecordClient client = BuildDomainContentProvider.this.getTeamBuildRecordClient(element);
                IBuildDefinitionStatusRecord[] allRecords = client.getBuildDefinitionStatusRecords(new String[]{definition.getId()}, monitor);
                if (allRecords.length > 0) {
                    IBuildDefinitionStatusRecord record = allRecords[0];
                    element.setStatus(record.getStatus());
                    element.setBuildDefinition(record.getBuildDefinition());
                }
                BuildDomainContentProvider.this.refreshNode(element);
                return Status.OK_STATUS;
            }
        };
    }

    protected boolean fetchAndUpdate(BuildEngineQueryNode element) {
        TeamBuildJob job = this.getFetchBuildEngineStatusRecordJob(element);
        job.schedule();
        return true;
    }

    protected TeamBuildJob getFetchBuildEngineStatusRecordJob(final BuildEngineQueryNode element) {
        return new TeamBuildJob(NLS.bind((String)Messages.BuildDomainContentProvider_REFRESH_NODE_JOB_NAME, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IBuildEngine engine = element.getBuildEngineStatusRecord().getBuildEngine();
                ITeamBuildRecordClient client = BuildDomainContentProvider.this.getTeamBuildRecordClient(element);
                IBuildEngineStatusRecord record = client.getBuildEngineStatusRecord((IBuildEngineHandle)engine, monitor);
                element.setBuildEngineStatusRecord(record);
                BuildDomainContentProvider.this.refreshNode(element);
                return Status.OK_STATUS;
            }
        };
    }

    private void refreshNode(final BuildDomainQueryNode element) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (BuildDomainContentProvider.this.getTreeViewer() != null && !BuildDomainContentProvider.this.getTreeViewer().getControl().isDisposed()) {
                    BuildDomainContentProvider.this.getTreeViewer().refresh((Object)element);
                }
            }
        });
    }

    public void connectedProjectAreaRegistryChanged(final IConnectedProjectAreaRegistryChangeEvent changeEvent) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                BuildDomainContentProvider.this.handleProjectAreaRegistryChanged(changeEvent);
            }
        });
    }

    protected void handleProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
        if (!this.fDisposed) {
            if (changeEvent.getType() == 2) {
                IBuildDefinitionStatusRecordListener removedRecordListener;
                IProjectAreaHandle projectAreaHandle = changeEvent.getProjectAreaHandle();
                BuildDomainItemChangeListener removedItemListener = this.fDefinitionItemListeners.remove(projectAreaHandle);
                if (removedItemListener != null) {
                    this.removeDefinitionItemListener(projectAreaHandle, removedItemListener);
                }
                if ((removedRecordListener = this.fDefinitionRecordListeners.remove(projectAreaHandle)) != null) {
                    BuildRecordEventManager.getInstance().removeListener(removedRecordListener);
                }
                if ((removedItemListener = this.fEngineItemListeners.remove(projectAreaHandle)) != null) {
                    this.removeEngineItemListener(projectAreaHandle, removedItemListener);
                }
            } else if (changeEvent.getType() == 0) {
                BuildDomainItemChangeListener listenerToRemove;
                IProjectAreaHandle projectAreaHandle;
                Iterator<IProjectAreaHandle> iterator = this.fDefinitionItemListeners.keySet().iterator();
                while (iterator.hasNext()) {
                    IBuildDefinitionStatusRecordListener removedRecordListener;
                    projectAreaHandle = iterator.next();
                    if (ConnectedProjectAreaRegistry.getDefault().isConnectedProjectArea(projectAreaHandle)) continue;
                    listenerToRemove = this.fDefinitionItemListeners.get(projectAreaHandle);
                    iterator.remove();
                    if (listenerToRemove != null) {
                        this.removeDefinitionItemListener(projectAreaHandle, listenerToRemove);
                    }
                    if ((removedRecordListener = this.fDefinitionRecordListeners.remove(projectAreaHandle)) == null) continue;
                    BuildRecordEventManager.getInstance().removeListener(removedRecordListener);
                }
                iterator = this.fEngineItemListeners.keySet().iterator();
                while (iterator.hasNext()) {
                    projectAreaHandle = iterator.next();
                    if (ConnectedProjectAreaRegistry.getDefault().isConnectedProjectArea(projectAreaHandle)) continue;
                    listenerToRemove = this.fEngineItemListeners.get(projectAreaHandle);
                    iterator.remove();
                    if (listenerToRemove == null) continue;
                    this.removeEngineItemListener(projectAreaHandle, listenerToRemove);
                }
            }
        }
    }

    private void addDefinitionItemListener(IProjectAreaHandle projectAreaHandle, BuildDomainItemChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().addItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }

    private void removeDefinitionItemListener(IProjectAreaHandle projectAreaHandle, AbstractBuildDefinitionChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().removeItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }

    private void addEngineItemListener(IProjectAreaHandle projectAreaHandle, AbstractBuildDefinitionChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().addItemChangeListener(IBuildEngine.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }

    private void removeEngineItemListener(IProjectAreaHandle projectAreaHandle, AbstractBuildDefinitionChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().removeItemChangeListener(IBuildEngine.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }

    private void disposeListeners() {
        this.fBuildDomain.getConnectedProjectAreaRegistry().removeListener((IConnectedProjectAreaRegistryListener)this);
        for (IProjectAreaHandle projectAreaHandle : this.fDefinitionItemListeners.keySet()) {
            this.removeDefinitionItemListener(projectAreaHandle, this.fDefinitionItemListeners.get(projectAreaHandle));
        }
        this.fDefinitionItemListeners.clear();
        for (IProjectAreaHandle projectAreaHandle : this.fEngineItemListeners.keySet()) {
            this.removeEngineItemListener(projectAreaHandle, this.fEngineItemListeners.get(projectAreaHandle));
        }
        this.fEngineItemListeners.clear();
    }

    protected AbstractTreeViewer getTreeViewer() {
        return this.fViewer;
    }

    protected BuildDomain getBuildDomain() {
        return this.fBuildDomain;
    }

    private ITeamBuildRecordClient getTeamBuildRecordClient(BuildDomainQueryNode element) {
        ITeamRepository repository = element.getTeamRepository();
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)repository.getClientLibrary(ITeamBuildRecordClient.class);
        return client;
    }
}

