/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.EditBuildDefinitionActionDelegate;
import com.ibm.team.build.internal.ui.actions.EditBuildEngineActionDelegate;
import com.ibm.team.build.internal.ui.actions.NewBuildDefinitionActionDelegate;
import com.ibm.team.build.internal.ui.actions.ShowBuildResultsAction;
import com.ibm.team.build.internal.ui.actions.SubscribeToFeedAction;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialog;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomain;
import com.ibm.team.build.internal.ui.domain.BuildDomainProjectAreaQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEngineQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEnginesNode;
import com.ibm.team.build.internal.ui.domain.ConnectedProjectAreaRegistryHelper;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.domain.ShowBuildsWithTagAction;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineEditorInput;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.build.internal.ui.query.BuildQueryByEngine;
import com.ibm.team.build.internal.ui.query.BuildQueryForBuildQueue;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryBySelectedTeamAreas;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.build.ui.BuildUI;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDomainActionHelper {
    private IMenuManager fMenuManager;
    private IStructuredSelection fSelection;
    IWorkbenchPartSite fPartSite;

    public BuildDomainActionHelper(IMenuManager manager, IStructuredSelection selection, IWorkbenchPartSite site) {
        this.fMenuManager = manager;
        this.fSelection = selection;
        this.fPartSite = site;
    }

    public void contributeActions() {
        if (this.fSelection.isEmpty()) {
            return;
        }
        Object element = this.fSelection.getFirstElement();
        if (this.fSelection.size() == 1 && element instanceof DomainSubtreeRoot) {
            DomainSubtreeRoot root = (DomainSubtreeRoot)element;
            if (root.getDomain() instanceof BuildDomain) {
                this.contributeBuildsNodeActions((DomainSubtreeRoot)element);
            }
        } else if (this.fSelection.size() == 1 && element instanceof BuildEnginesNode) {
            this.contributeActivityNodeActions((BuildEnginesNode)element);
        } else if (element instanceof BuildDomainQueryNode) {
            this.contributeQueryNodeActions(this.fSelection);
        }
    }

    private void contributeActivityNodeActions(BuildEnginesNode node) {
        IProjectAreaHandle projectArea = node.getProjectArea();
        this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getNewBuildEngineAction(projectArea));
    }

    private void contributeQueryNodeActions(IStructuredSelection selection) {
        List<BuildDomainQueryNode> queryNodes = this.getQueryNodesFromSelection(selection);
        List<IBuildDefinitionHandle> buildDefinitionHandles = this.getBuildDefinitionsFromQueryNodes(queryNodes);
        if (queryNodes.size() > 1 && queryNodes.size() == buildDefinitionHandles.size()) {
            this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getShowBuildResultsWithTagAction(queryNodes));
            this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getOpenBuildDefinitionAction(queryNodes));
        } else if (queryNodes.size() > 1) {
            if (this.areAllBuildEngineQueryNodes(queryNodes)) {
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getOpenBuildEngineAction(queryNodes));
                this.fMenuManager.appendToGroup("jazz.open.group", (IContributionItem)new Separator());
            }
        } else {
            BuildDomainQueryNode queryNode = queryNodes.get(0);
            if (queryNode.getQuery() instanceof BuildQueryByDefinition) {
                BuildQueryByDefinition queryByType = (BuildQueryByDefinition)queryNode.getQuery();
                ITeamRepository teamRepository = (ITeamRepository)queryByType.getBuildDefinitionHandles().get(0).getOrigin();
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getOpenLatestBuildAction(queryNodes.get(0).getLabel(), teamRepository));
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getShowBuildResultsWithTagAction(queryNodes));
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getOpenBuildDefinitionAction(Collections.singletonList(queryNode)));
                this.fMenuManager.appendToGroup("jazz.open.group", (IContributionItem)new Separator());
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getRequestBuildAction(queryByType.getBuildDefinitionHandles().get(0)));
                this.fMenuManager.appendToGroup("jazz.open.group", (IContributionItem)new Separator());
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getSubscribeToFeedAction(queryByType.getName(), queryByType.getBuildDefinitionHandles().get(0)));
            } else if (queryNode.getQuery() instanceof BuildQueryByEngine) {
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getOpenBuildEngineAction(queryNodes));
                this.fMenuManager.appendToGroup("jazz.open.group", (IContributionItem)new Separator());
            } else if (queryNode.getQuery() instanceof BuildQueryForBuildQueue) {
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getShowBuildQueueAction(((BuildDomainProjectAreaQueryNode)queryNode).getProjectAreaHandle()));
                this.fMenuManager.appendToGroup("jazz.open.group", (IContributionItem)new Separator());
            }
        }
    }

    private void contributeBuildsNodeActions(DomainSubtreeRoot root) {
        Object category = root.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        this.fMenuManager.appendToGroup("jazz.open.group", (IAction)new NewBuildDefinitionActionDelegate().getAction(projectAreaHandle, this.fPartSite.getWorkbenchWindow().getShell()));
        this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getShowBuildResultsAction(projectAreaHandle));
        this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getShowBuildResultsWithTagAction(projectAreaHandle));
    }

    protected Action getShowBuildResultsAction(final IProjectAreaHandle projectAreaHandle) {
        return new Action(Messages.BuildDomainActionHelper_SHOW_BUILDS){

            public void run() {
                ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
                String projectAreaName = ConnectedProjectAreaRegistryHelper.getProjectAreaName(projectAreaHandle);
                String queryName = NLS.bind((String)BuildUIQueryMessages.BuildQueryView_MY_BUILDS_FOR_PROJECT, (Object)projectAreaName);
                BuildQueryBySelectedTeamAreas query = new BuildQueryBySelectedTeamAreas(queryName, projectAreaHandle, teamRepository);
                BuildQueryView.displayQuery(query, BuildDomainActionHelper.this.fPartSite.getPage());
            }

            public String getId() {
                return Messages.BuildDomainActionHelper_ACTION_ID_SHOW_BUILDS_SELECTED_TEAMS;
            }
        };
    }

    protected Action getNewBuildEngineAction(final IProjectAreaHandle projectAreaHandle) {
        return new Action(Messages.BuildDomainActionHelper_NEW_BUILD_ENGINE){

            public void run() {
                ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
                IWorkbenchPage page = BuildDomainActionHelper.this.fPartSite.getPage();
                if (page != null) {
                    try {
                        BuildEngineEditorInput input = new BuildEngineEditorInput(null, teamRepository);
                        page.openEditor((IEditorInput)input, "com.ibm.team.build.ui.editors.buildEngineEditor");
                    }
                    catch (PartInitException exception) {
                        BuildUIPlugin.log(exception);
                    }
                }
            }

            public String getId() {
                return Messages.BuildDomainActionHelper_NEW_BUILD_ENGINE_ID;
            }
        };
    }

    protected Action getRequestBuildAction(final IBuildDefinitionHandle buildDefinitionHandle) {
        return new Action(Messages.BuildDomain_REQUEST_BUILD_ACTION_LABEL){

            public void run() {
                RequestBuildDialog dialog = new RequestBuildDialog(BuildDomainActionHelper.this.fPartSite.getWorkbenchWindow().getShell(), buildDefinitionHandle);
                BuildDomainActionHelper.this.openDialog(dialog);
            }

            public String getId() {
                return Messages.BuildDomainActionHelper_ACTION_ID_REQUEST_BUILD_FOR_TYPE;
            }
        };
    }

    protected Action getSubscribeToFeedAction(String buildDefinitionId, IBuildDefinitionHandle buildDefinitionHandle) {
        return new SubscribeToFeedAction(buildDefinitionId, buildDefinitionHandle);
    }

    protected Action getOpenBuildDefinitionAction(final List<BuildDomainQueryNode> queryNodes) {
        return new Action(Messages.BuildDomainActionHelper_OPEN_BUILD_DEFINITION){

            public void run() {
                for (BuildDomainQueryNode node : queryNodes) {
                    if (!(node instanceof BuildDefinitionQueryNode)) continue;
                    EditBuildDefinitionActionDelegate.run(((BuildDefinitionQueryNode)node).getBuildDefinition(), BuildDomainActionHelper.this.fPartSite.getWorkbenchWindow().getActivePage());
                }
            }

            public String getId() {
                return Messages.BuildDomainActionHelper_ACTION_ID_OPEN_BUILD_DEFINITION;
            }
        };
    }

    protected Action getOpenBuildEngineAction(final List<BuildDomainQueryNode> queryNodes) {
        return new Action(Messages.BuildDomainActionHelper_OPEN_BUILD_ENGINE){

            public void run() {
                for (BuildDomainQueryNode node : queryNodes) {
                    if (!(node instanceof BuildEngineQueryNode)) continue;
                    EditBuildEngineActionDelegate.run(((BuildEngineQueryNode)node).getBuildEngineStatusRecord().getBuildEngine(), BuildDomainActionHelper.this.fPartSite.getWorkbenchWindow().getActivePage());
                }
            }

            public String getId() {
                return Messages.BuildDomainActionHelper_ACTION_ID_OPEN_BUILD_ENGINE;
            }
        };
    }

    protected Action getShowBuildResultsAction(List<BuildDomainQueryNode> buildDefinitionQueryNodes) {
        List<IBuildDefinitionHandle> buildDefinitionHandles = this.getBuildDefinitionsFromQueryNodes(buildDefinitionQueryNodes);
        return new ShowBuildResultsAction(buildDefinitionQueryNodes, buildDefinitionHandles, this.fPartSite.getPage());
    }

    protected Action getShowBuildResultsWithTagAction(List<BuildDomainQueryNode> buildDefinitionQueryNodes) {
        List<IBuildDefinitionHandle> buildDefinitionHandles = this.getBuildDefinitionsFromQueryNodes(buildDefinitionQueryNodes);
        return new ShowBuildsWithTagAction(Messages.BuildDomainActionHelper_TAG_QUERY_ACTION_NAME, buildDefinitionHandles, buildDefinitionQueryNodes, this.fPartSite);
    }

    protected Action getShowBuildResultsWithTagAction(IProjectAreaHandle projectAreaHandle) {
        return new ShowBuildsWithTagAction(Messages.BuildDomainActionHelper_TAG_QUERY_ACTION_NAME, projectAreaHandle, this.fPartSite);
    }

    protected Action getShowBuildQueueAction(final IProjectAreaHandle projectAreaHandle) {
        final ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        return new Action(Messages.BuildDomainActionHelper_ACTION_LABEL_SHOW_BUILD_QUEUE){

            public void run() {
                BuildQueryForBuildQueue query = new BuildQueryForBuildQueue(Messages.BuildDomainActionHelper_QUERY_NAME_BUILD_QUEUE, null, AdaptableBuildQueryRow.Factory, projectAreaHandle, teamRepository);
                BuildQueryView.displayQuery(query, BuildDomainActionHelper.this.fPartSite.getPage());
            }

            public String getId() {
                return Messages.BuildDomainActionHelper_ACTION_ID_SHOW_BUILD_QUEUE;
            }
        };
    }

    protected Action getOpenLatestBuildAction(final String buildDefinitionId, final ITeamRepository teamRepository) {
        return new Action(Messages.BuildDomainActionHelper_OPEN_LATEST_BUILD){

            public void run() {
                BuildDomainActionHelper.this.openLatestBuild(buildDefinitionId, teamRepository);
            }

            public String getId() {
                return Messages.BuildDomainActionHelper_ACTION_ID_OPEN_LATEST_BUILD;
            }
        };
    }

    private boolean areAllBuildEngineQueryNodes(List<BuildDomainQueryNode> nodes) {
        for (BuildDomainQueryNode buildDomainQueryNode : nodes) {
            if (buildDomainQueryNode instanceof BuildEngineQueryNode) continue;
            return false;
        }
        return true;
    }

    private List<IBuildDefinitionHandle> getBuildDefinitionsFromQueryNodes(List<BuildDomainQueryNode> queryNodes) {
        ArrayList<IBuildDefinitionHandle> buildDefinitionHandles = new ArrayList<IBuildDefinitionHandle>();
        for (BuildDomainQueryNode node : queryNodes) {
            BuildQuery query = node.getQuery();
            if (!(query instanceof BuildQueryByDefinition)) continue;
            BuildQueryByDefinition queryByType = (BuildQueryByDefinition)query;
            buildDefinitionHandles.addAll(queryByType.getBuildDefinitionHandles());
        }
        return buildDefinitionHandles;
    }

    private List<BuildDomainQueryNode> getQueryNodesFromSelection(IStructuredSelection selection) {
        ArrayList<BuildDomainQueryNode> queryNodes = new ArrayList<BuildDomainQueryNode>();
        List list = selection.toList();
        for (Object object : list) {
            if (!(object instanceof BuildDomainQueryNode)) continue;
            queryNodes.add((BuildDomainQueryNode)object);
        }
        return queryNodes;
    }

    private void openLatestBuild(final String buildDefinitionId, final ITeamRepository teamRepository) {
        String jobName = Messages.BuildDomainActionHelper_JOB_LABEL_OPEN_LATEST_BUILD;
        TeamBuildJob job = new TeamBuildJob(jobName, true, teamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                ITeamBuildClient client = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
                IBuildDefinition buildDefinition = client.getBuildDefinition(buildDefinitionId, (IProgressMonitor)subMonitor.newChild(1));
                if (buildDefinition != null) {
                    BuildState[] buildStatesOfInterest = new BuildState[]{BuildState.INCOMPLETE, BuildState.IN_PROGRESS, BuildState.COMPLETED};
                    IBuildResult buildResult = client.getLastBuildResult((IBuildDefinitionHandle)buildDefinition, buildStatesOfInterest, IBuildResult.PROPERTIES_VIEW_ITEM, (IProgressMonitor)subMonitor.newChild(1));
                    if (buildResult != null) {
                        BuildUI.getDefault().open((IBuildResultHandle)buildResult, teamRepository, BuildDomainActionHelper.this.fPartSite.getPage());
                    } else {
                        BuildDomainActionHelper.this.showInfoDialog(Messages.BuildDomainActionHelper_NO_BUILDS_TITLE, Messages.BuildDomainActionHelper_NO_BUILDS_FOUND);
                    }
                } else {
                    BuildDomainActionHelper.this.showErrorDialog(Messages.BuildDomainActionHelper_NO_DEFINITION_FOUND);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void showInfoDialog(String title, String message) {
        BuildUIHelper.showInfoDialog(this.fPartSite.getShell(), title, message);
    }

    protected void showErrorDialog(String errorMessage) {
        BuildUIHelper.showErrorDialog(errorMessage);
    }

    protected void openDialog(RequestBuildDialog dialog) {
        dialog.open();
    }
}

