/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.internal.ui.domain.AbstractBuildFolderNode;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomainActionHelper;
import com.ibm.team.build.internal.ui.domain.BuildDomainContentProvider;
import com.ibm.team.build.internal.ui.domain.BuildDomainLabelProvider;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEngineQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEnginesNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.IProcessAreaCategory;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class BuildDomain
extends Domain {
    protected BuildDomainContentProvider fContentProvider;
    private BuildDomainLabelProvider fLabelProvider;
    private ViewerSorter fViewerSorter;

    public boolean contains(Object element) {
        return element instanceof BuildDomainQueryNode || element instanceof AbstractBuildFolderNode;
    }

    public ITreePathContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new BuildDomainContentProvider(this, this.includeBuildEngines());
        }
        return this.fContentProvider;
    }

    private boolean includeBuildEngines() {
        Category category = this.getCategory();
        if (category instanceof IProcessAreaCategory) {
            return !((IProcessAreaCategory)category).isTeamAreaCategory();
        }
        return true;
    }

    public ITreePathLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new BuildDomainLabelProvider();
        }
        return this.fLabelProvider;
    }

    public Object getRoot() {
        return this;
    }

    public boolean supportsCategory(Category category) {
        return category instanceof IProcessAreaCategory;
    }

    public boolean open(IWorkbenchPartSite site, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object element = selection.getFirstElement();
        if (element instanceof BuildDomainQueryNode) {
            BuildDomainQueryNode node = (BuildDomainQueryNode)element;
            node.open((IWorkbenchSite)site);
            return true;
        }
        return false;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        BuildDomainActionHelper actionHelper = new BuildDomainActionHelper(manager, selection, this.getWorkbenchPart().getSite());
        actionHelper.contributeActions();
        super.contributeContextMenuActions(manager, selection);
    }

    public ViewerSorter getSorter() {
        if (this.fViewerSorter == null) {
            this.fViewerSorter = new BuildDomainQueryNodeViewerSorter();
        }
        return this.fViewerSorter;
    }

    public void dispose() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
            this.fContentProvider = null;
        }
    }

    public boolean refresh(Object element) {
        if (element instanceof BuildDefinitionQueryNode) {
            return ((BuildDomainContentProvider)this.getContentProvider()).fetchAndUpdate((BuildDefinitionQueryNode)element);
        }
        if (element instanceof BuildEngineQueryNode) {
            return ((BuildDomainContentProvider)this.getContentProvider()).fetchAndUpdate((BuildEngineQueryNode)element);
        }
        return super.refresh(element);
    }

    public static class BuildDomainQueryNodeViewerSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object element1, Object element2) {
            if (element1 instanceof PendingUpdateAdapter && element2 instanceof PendingUpdateAdapter) {
                return 0;
            }
            if (element1 instanceof PendingUpdateAdapter) {
                return -1;
            }
            if (element2 instanceof PendingUpdateAdapter) {
                return 1;
            }
            if (element1 instanceof BuildDomainQueryNode && element2 instanceof BuildDomainQueryNode) {
                BuildDomainQueryNode node1 = (BuildDomainQueryNode)element1;
                BuildDomainQueryNode node2 = (BuildDomainQueryNode)element2;
                if (node1.getLabel().equals(Messages.BuildDomainContentProvider_BUILD_QUEUE_NODE_LABEL)) {
                    return -1;
                }
                if (node2.getLabel().equals(Messages.BuildDomainContentProvider_BUILD_QUEUE_NODE_LABEL)) {
                    return 1;
                }
                return node1.getLabel().compareTo(node2.getLabel());
            }
            if (element1 instanceof BuildDomainQueryNode && element2 instanceof BuildEnginesNode) {
                return 1;
            }
            if (element1 instanceof BuildEnginesNode && element2 instanceof BuildDomainQueryNode) {
                return -1;
            }
            return 0;
        }
    }
}

