/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.swt.graphics.Image;

public class BuildDefinitionQueryNode
extends BuildDomainQueryNode {
    private BuildStatus fStatus;
    private IBuildDefinition fBuildDefinition;
    private BuildQuery fBuildQuery;
    private final String fBuildQueryLock = "lock";

    public BuildDefinitionQueryNode(ITeamRepository repository, IBuildDefinitionStatusRecord record) {
        super(repository, record.getBuildDefinition().getId(), 0);
        this.fStatus = record.getStatus();
        this.fBuildDefinition = record.getBuildDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildQuery getQuery() {
        String string = "lock";
        synchronized ("lock") {
            if (this.fBuildQuery == null) {
                this.fBuildQuery = new BuildQueryByDefinition(this.fBuildDefinition.getId(), null, AdaptableBuildQueryRow.Factory, (IBuildDefinitionHandle)this.fBuildDefinition, this.getTeamRepository());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fBuildQuery;
        }
    }

    public Image getImage() {
        Image undecoratedImage = BuildUIPlugin.getImage("icons/obj16/build_type_obj.gif");
        if (this.fStatus == null) {
            return undecoratedImage;
        }
        return BuildCompositeImageRegistry.getImage(undecoratedImage, this.fStatus);
    }

    public String getLabel() {
        return this.fBuildDefinition.getId();
    }

    public BuildStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(BuildStatus status) {
        this.fStatus = status;
    }

    public String getBuildDefinitionId() {
        return this.fBuildDefinition.getId();
    }

    public IBuildDefinition getBuildDefinition() {
        return this.fBuildDefinition;
    }

    public void setBuildDefinition(IBuildDefinition definition) {
        this.fBuildDefinition = definition;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BuildDefinitionQueryNode) {
            return ((BuildDefinitionQueryNode)obj).getBuildDefinition().getItemId().equals((Object)this.getBuildDefinition().getItemId());
        }
        return false;
    }

    public int hashCode() {
        return this.getBuildDefinition().getItemId().hashCode();
    }
}

