/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.actions.DeleteBuildDefinitionActionDelegate;
import com.ibm.team.build.internal.ui.actions.ShowBuildResultsAction;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class BuildDefinitionMenuOperationTarget
implements IMenuOperationTarget {
    public boolean canDoOperation(String actionId, IStructuredSelection selection) {
        if (actionId.equals(IMenuOperationTarget.DELETE) && this.isSelectionOfBuildDefinitions(selection)) {
            return true;
        }
        return actionId.equals("jazz.open") && this.isSelectionOfBuildDefinitions(selection);
    }

    public void doOperation(String actionId, IWorkbenchSite site, IStructuredSelection selection) {
        if (actionId.equals(IMenuOperationTarget.DELETE)) {
            this.deleteBuildDefinitions(selection);
        }
        if (actionId.equals("jazz.open")) {
            this.showBuildResults(selection);
        }
    }

    public String getLabel(String actionId) {
        if ("jazz.open".equals(actionId)) {
            return Messages.BuildDomainActionHelper_SHOW_BUILDS;
        }
        return null;
    }

    private boolean isSelectionOfBuildDefinitions(IStructuredSelection selection) {
        if (selection.size() > 0) {
            for (Object object : selection) {
                if (object instanceof BuildDefinitionQueryNode) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void showBuildResults(IStructuredSelection selection) {
        ArrayList<IBuildDefinitionHandle> definitionsForQuery = new ArrayList<IBuildDefinitionHandle>();
        for (BuildDefinitionQueryNode node : selection) {
            definitionsForQuery.add((IBuildDefinitionHandle)node.getBuildDefinition());
        }
        ShowBuildResultsAction action = new ShowBuildResultsAction(selection.toList(), definitionsForQuery, this.getWorkbenchPage());
        action.run();
    }

    private void deleteBuildDefinitions(IStructuredSelection selection) {
        ArrayList<IBuildDefinition> definitionsToDelete = new ArrayList<IBuildDefinition>();
        for (BuildDefinitionQueryNode node : selection) {
            definitionsToDelete.add(node.getBuildDefinition());
        }
        DeleteBuildDefinitionActionDelegate delegate = this.getDeleteDefinitionAction();
        delegate.selectionChanged(null, (ISelection)new StructuredSelection(definitionsToDelete));
        delegate.run(null);
    }

    protected DeleteBuildDefinitionActionDelegate getDeleteDefinitionAction() {
        return new DeleteBuildDefinitionActionDelegate();
    }

    protected IWorkbenchPage getWorkbenchPage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }
}

