/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.build.internal.ui.properties.BuildPropertyEditorExtension;
import com.ibm.team.build.internal.ui.properties.BuildPropertyEditorExtensionManager;
import com.ibm.team.build.internal.ui.properties.BuildPropertyLabelHelper;
import com.ibm.team.build.ui.properties.AbstractBuildPropertyEditor;
import com.ibm.team.build.ui.properties.IBuildPropertyEditorContext;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPropertyDialog
extends Dialog {
    protected String fTitle;
    protected Label fErrorMessageLabel;
    protected Text fPropertyNameText;
    protected Text fPropertyValueText;
    protected Text fPropertyDescriptionText;
    protected final List fExistingProperties;
    protected IBuildProperty fBuildProperty;
    protected boolean fIsNewProperty;
    protected Shell fParentShell;
    protected ITeamRepository fTeamRepository;
    protected AbstractBuildPropertyEditor fPropertyEditor;
    private Button fEditButton;

    public BuildPropertyDialog(Shell parentShell, String title, IBuildProperty buildProperty, List<IBuildProperty> existingProperties, boolean isNewProperty, ITeamRepository teamRepository) {
        super(parentShell);
        ValidationHelper.validateNotNull((String)"title", (Object)title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fParentShell = parentShell;
        this.fExistingProperties = existingProperties;
        this.fBuildProperty = buildProperty;
        this.fIsNewProperty = isNewProperty;
        this.fTeamRepository = teamRepository;
        this.fPropertyEditor = this.getPropertyEditor(buildProperty);
    }

    protected void validate(boolean suppressErrorMessage) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null || suppressErrorMessage) {
            this.fErrorMessageLabel.setText("");
        } else {
            this.fErrorMessageLabel.setText(errorMessage);
        }
        this.fErrorMessageLabel.redraw();
        Button okButton = this.getButton(0);
        okButton.setEnabled(errorMessage == null);
    }

    protected String getPropertyNameTextValue() {
        return this.fPropertyNameText.getText();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        composite.setLayoutData((Object)gridData);
        String message = BuildUIDialogMessages.PROPERTY_HEADER;
        if (this.fBuildProperty.isRequired()) {
            message = BuildUIDialogMessages.PROPERTY_HEADER_REQUIRED;
        }
        this.createLabel(composite, message, null);
        this.fErrorMessageLabel = this.createLabel(composite, "", JFaceColors.getErrorText((Display)composite.getDisplay()));
        int horizontalSpan = 2;
        boolean addEditButton = false;
        if (this.fPropertyEditor != null) {
            addEditButton = true;
            horizontalSpan = 1;
        }
        String valueText = "";
        if (!this.fIsNewProperty) {
            valueText = BuildUIDialogMessages.BuildPropertyDialog_FETCHING_VALUE;
        }
        this.fPropertyNameText = this.createText(composite, BuildUIDialogMessages.PROPERTY_NAME, this.fBuildProperty.getName(), 2);
        this.fPropertyDescriptionText = this.createText(composite, BuildUIDialogMessages.DESCRIPTION_LABEL, this.fBuildProperty.getDescription(), 2);
        this.fPropertyValueText = this.createText(composite, BuildUIDialogMessages.PROPERTY_VALUE, valueText, horizontalSpan);
        if (addEditButton) {
            this.fEditButton = new Button(composite, 0);
            this.fEditButton.setText(BuildUIDialogMessages.BuildPropertyDialog_EDIT_BUTTON_LABEL);
            this.fEditButton.addSelectionListener(this.getEditButtonSelectionListener());
            IBuildPropertyEditorContext context = this.getPropertyEditorContext(this.fBuildProperty, this.fParentShell, this.fTeamRepository);
            this.fPropertyValueText.setEnabled(false);
            if (!this.fIsNewProperty) {
                BuildPropertyLabelHelper labelHelper = this.getLabelHelper();
                labelHelper.getPropertyValueLabelInBackground(this.fPropertyEditor, context);
            }
        } else {
            this.fPropertyValueText.setText(this.fBuildProperty.getValue());
        }
        if (this.fBuildProperty.isRequired()) {
            this.fPropertyNameText.setEditable(false);
            this.fPropertyDescriptionText.setEditable(false);
        }
        this.fPropertyNameText.addModifyListener(this.getNameModifiedListener());
        this.fPropertyDescriptionText.addModifyListener(this.getDescriptionModifiedListener());
        this.fPropertyValueText.addModifyListener(this.getValueModifiedListener());
        BuildPropertyDialog.applyDialogFont((Control)composite);
        if (!this.fIsNewProperty && !addEditButton) {
            this.fPropertyValueText.setFocus();
            this.fPropertyValueText.selectAll();
        } else {
            this.fPropertyNameText.setFocus();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.dialog_buildproperty");
        return composite;
    }

    private BuildPropertyLabelHelper getLabelHelper() {
        return new BuildPropertyLabelHelper(){

            public void labelAvailable(String label, IBuildProperty buildProperty) {
                if (!BuildPropertyDialog.this.fPropertyValueText.isDisposed()) {
                    BuildPropertyDialog.this.fPropertyValueText.setText(label);
                }
            }
        };
    }

    private ModifyListener getNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildPropertyDialog.this.validate(false);
                BuildPropertyDialog.this.fBuildProperty.setName(BuildPropertyDialog.this.fPropertyNameText.getText());
            }
        };
    }

    private ModifyListener getDescriptionModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildPropertyDialog.this.validate(false);
                BuildPropertyDialog.this.fBuildProperty.setDescription(BuildPropertyDialog.this.fPropertyDescriptionText.getText());
            }
        };
    }

    private ModifyListener getValueModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildPropertyDialog.this.validate(false);
                if (BuildPropertyDialog.this.fPropertyEditor == null) {
                    BuildPropertyDialog.this.fBuildProperty.setValue(BuildPropertyDialog.this.fPropertyValueText.getText());
                }
            }
        };
    }

    private SelectionListener getEditButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPropertyDialog.this.editProperty(BuildPropertyDialog.this.fBuildProperty);
            }
        };
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        label.setForeground(color);
        return label;
    }

    protected Text createText(Composite parent, String labelText, String defaultText, int textHorizontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData());
        Text text = new Text(parent, 2052);
        text.setText(defaultText);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = textHorizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    public void create() {
        super.create();
        this.validate(true);
    }

    protected List getExistingProperties() {
        return this.fExistingProperties;
    }

    protected String getErrorMessage() {
        String proposedPropertyName = this.getPropertyNameTextValue();
        if (proposedPropertyName.equals("")) {
            return BuildUIDialogMessages.PROPERTY_NAME_REQUIRED;
        }
        if (proposedPropertyName.indexOf(32) > -1) {
            return BuildUIDialogMessages.PROPERTY_NAME_NO_SPACES;
        }
        if (this.propertyNameConflict(proposedPropertyName)) {
            return BuildUIDialogMessages.PROPERTY_EXISTS;
        }
        return null;
    }

    protected boolean propertyNameConflict(String name) {
        if (this.fBuildProperty.getName().equals(name)) {
            return false;
        }
        List properties = this.getExistingProperties();
        for (Object object : properties) {
            IBuildProperty property = (IBuildProperty)object;
            if (!property.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void editProperty(IBuildProperty buildProperty) {
        IBuildPropertyEditorContext context = this.getPropertyEditorContext(buildProperty, this.getShell(), this.fTeamRepository);
        if (this.fPropertyEditor.editProperty(context)) {
            this.fPropertyValueText.setText(BuildUIDialogMessages.BuildPropertyDialog_FETCHING_VALUE);
            BuildPropertyLabelHelper labelHelper = this.getLabelHelper();
            labelHelper.getPropertyValueLabelInBackground(this.fPropertyEditor, context);
        }
    }

    private AbstractBuildPropertyEditor getPropertyEditor(IBuildProperty buildProperty) {
        AbstractBuildPropertyEditor editor = null;
        try {
            BuildPropertyEditorExtension extension = BuildPropertyEditorExtensionManager.getInstance().getBuildPropertyEditor(buildProperty.getKind());
            if (extension != null) {
                editor = extension.createPropertyEditor();
            }
        }
        catch (CoreException exception) {
            this.handlePropertyEditorException(exception);
        }
        return editor;
    }

    protected IBuildPropertyEditorContext getPropertyEditorContext(final IBuildProperty buildProperty, final Shell parent, ITeamRepository teamRepository) {
        return new IBuildPropertyEditorContext(){

            public IBuildProperty getProperty() {
                return buildProperty;
            }

            public Shell getShell() {
                return parent;
            }

            public ITeamRepository getTeamRepository() {
                return BuildPropertyDialog.this.fTeamRepository;
            }
        };
    }

    private void handlePropertyEditorException(CoreException exception) {
        BuildUIPlugin.log(exception);
    }
}

