/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineEditorInput;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public class EditBuildEngineActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fTargetPart;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        if (this.fSelection.getFirstElement() instanceof IBuildEngine) {
            IBuildEngine buildEngine = (IBuildEngine)this.fSelection.getFirstElement();
            EditBuildEngineActionDelegate.run(buildEngine, this.fTargetPart.getSite().getPage());
        }
    }

    public static void run(IBuildEngine buildEngine, IWorkbenchPage workbenchPage) {
        try {
            BuildEngineEditorInput input = new BuildEngineEditorInput(buildEngine, (ITeamRepository)buildEngine.getOrigin());
            workbenchPage.openEditor((IEditorInput)input, "com.ibm.team.build.ui.editors.buildEngineEditor");
        }
        catch (PartInitException exception) {
            BuildUIPlugin.log(exception);
        }
    }
}

