/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorInput;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public class EditBuildDefinitionActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fTargetPart;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        if (this.fSelection.getFirstElement() instanceof IBuildDefinition) {
            IBuildDefinition buildDefinition = (IBuildDefinition)this.fSelection.getFirstElement();
            EditBuildDefinitionActionDelegate.run(buildDefinition, this.fTargetPart.getSite().getPage());
        }
    }

    public static void run(IBuildDefinition buildDefinition, IWorkbenchPage workbenchPage) {
        EditBuildDefinitionActionDelegate.run(buildDefinition, null, workbenchPage);
    }

    public static void run(final IBuildDefinition buildDefinition, final String initialPageId, final IWorkbenchPage workbenchPage) {
        String jobName = BuildUIActionMessages.EditBuildDefinitionActionDelegate_FETCHING_TEAM_AREA;
        TeamBuildJob job = new TeamBuildJob(jobName, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
                ITeamAreaHandle teamAreaHandle = buildDefinition.getTeamArea();
                final ITeamArea teamArea = (ITeamArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)teamAreaHandle, 0, monitor);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        EditBuildDefinitionActionDelegate.handleAsyncExec(workbenchPage, buildDefinition, initialPageId, teamArea);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static void handleAsyncExec(IWorkbenchPage workbenchPage, IBuildDefinition buildDefinition, String initialPageId, ITeamArea teamArea) {
        try {
            IWorkbenchPartSite site;
            IWorkbenchPart activePart = workbenchPage.getActivePart();
            if (activePart != null && (site = activePart.getSite()) != null && !site.getShell().isDisposed()) {
                BuildDefinitionEditorInput input = new BuildDefinitionEditorInput(buildDefinition, teamArea, (ITeamRepository)buildDefinition.getOrigin(), false);
                if (initialPageId != null) {
                    input.setInitialPageId(initialPageId);
                }
                workbenchPage.openEditor((IEditorInput)input, "com.ibm.team.build.ui.editors.buildDefinitionEditor");
            }
        }
        catch (PartInitException exception) {
            BuildUIPlugin.log(exception);
        }
    }
}

