/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.TeamBuildStateException;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ui.actions.AbstractRepositoryActionDelegate;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteBuildResultActionDelegate
extends AbstractRepositoryActionDelegate
implements IViewActionDelegate {
    private IStructuredSelection fSelection;
    private BuildQueryView fQueryView;

    public void init(IViewPart view) {
        this.fQueryView = (BuildQueryView)view;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.isQueryActionInProgress()) {
            action.setEnabled(false);
            return;
        }
        this.fSelection = (IStructuredSelection)selection;
        this.updateEnablement(action);
    }

    protected void updateEnablement(IAction action) {
        Object[] objectArray = this.fSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            BuildQueryRow row = (BuildQueryRow)object;
            if (row.getBuildResult().getState() == BuildState.IN_PROGRESS || row.getBuildResult().getState() == BuildState.NOT_STARTED) {
                action.setEnabled(false);
                return;
            }
            ++n2;
        }
    }

    @Override
    protected String getConfirmationMessage() {
        return BuildUIActionMessages.RemoveBuildResultsActionDelegate_1;
    }

    @Override
    protected String getJobLabel() {
        return BuildUIActionMessages.RemoveBuildResultsActionDelegate_0;
    }

    @Override
    protected void performAction(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        LinkedList<IBuildResult> notDeleted = new LinkedList<IBuildResult>();
        progressMonitor.beginTask(BuildUIActionMessages.RemoveBuildResultsActionDelegate_0, this.fSelection.size());
        try {
            Object[] objectArray = this.fSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                BuildQueryRow row = (BuildQueryRow)object;
                try {
                    if (row.getBuildResult().isDeleteAllowed()) {
                        this.delete(row.getTeamRepository(), row.getBuildResult(), progressMonitor);
                    } else {
                        notDeleted.add(row.getBuildResult());
                    }
                }
                catch (ItemNotFoundException itemNotFoundException) {
                }
                catch (TeamBuildStateException teamBuildStateException) {
                    notDeleted.add(row.getBuildResult());
                }
                ++n2;
            }
            this.handleDeletionNotAllowed(notDeleted);
        }
        finally {
            progressMonitor.done();
        }
    }

    protected void delete(ITeamRepository teamRepository, IBuildResult buildResult, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ITeamBuildClient teamBuildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
        teamBuildClient.delete((IBuildResultHandle)buildResult, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
    }

    protected void handleDeletionNotAllowed(List<IBuildResult> notDeleted) {
        if (!notDeleted.isEmpty()) {
            String message = NLS.bind((String)BuildUIActionMessages.DeleteBuildResultActionDelegate_RESULT_DELETE_NOT_ALLOWED, (Object[])new Object[]{notDeleted.size()});
            BuildUIHelper.showInfoDialog(this.getShell(), BuildUIActionMessages.RemoveBuildResultsActionDelegate_0, message);
        }
    }

    protected boolean isQueryActionInProgress() {
        return this.fQueryView.isRunBuildQueryActionInProgress();
    }
}

