/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.helper.ClipboardHelper;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyBuildPropertyActionDelegate
extends ActionDelegate {
    private List fSelectedElements;

    public void run(IAction action) {
        CopyBuildPropertyActionDelegate.copyValuesToClipboard(this.fSelectedElements);
    }

    public static void copyValuesToClipboard(List<IBuildProperty> properties) {
        ClipboardHelper.getDefault().copyTextToClipboard(CopyBuildPropertyActionDelegate.getCopyText(properties), Display.getCurrent());
    }

    public static String getCopyText(List<IBuildProperty> properties) {
        StringBuffer buffer = new StringBuffer();
        if (properties != null && !properties.isEmpty() && CopyBuildPropertyActionDelegate.isValidCopy(properties)) {
            Iterator<IBuildProperty> iter = properties.iterator();
            while (iter.hasNext()) {
                IBuildProperty next;
                IBuildProperty currentProperty = next = iter.next();
                buffer.append(currentProperty.getValue());
                if (!iter.hasNext()) continue;
                buffer.append(System.getProperty("line.separator"));
            }
        }
        return new String(buffer);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean isValueSet = false;
        if (selection instanceof IStructuredSelection) {
            this.fSelectedElements = ((IStructuredSelection)selection).toList();
            isValueSet = CopyBuildPropertyActionDelegate.isValidCopy(this.fSelectedElements);
        }
        action.setEnabled(isValueSet);
    }

    public static boolean isValidCopy(List propertiesToCopy) {
        boolean isValueSet = false;
        if (propertiesToCopy != null && CopyBuildPropertyActionDelegate.areBuildProperties(propertiesToCopy)) {
            Iterator buildProperties = propertiesToCopy.iterator();
            while (!isValueSet && buildProperties.hasNext()) {
                IBuildProperty thisProperty = (IBuildProperty)buildProperties.next();
                if (thisProperty.getValue() == null || thisProperty.getValue().equals("")) continue;
                isValueSet = true;
            }
        }
        return isValueSet;
    }

    private static boolean areBuildProperties(List propertiesToCopy) {
        Iterator iterator = propertiesToCopy.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof IBuildProperty) continue;
            return false;
        }
        return true;
    }

    protected List<IBuildProperty> getSelectedElements() {
        return this.fSelectedElements;
    }
}

