/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.ItemNotFoundHelper;
import com.ibm.team.build.internal.ui.tooltips.AbstractBuildItemHyperlinkHandler;
import com.ibm.team.build.ui.BuildUI;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class BuildResultHyperlinkHandler
extends AbstractBuildItemHyperlinkHandler {
    public boolean resolves(URI uri) {
        return this.handles(uri);
    }

    public Object resolve(URI uri, ContextProvider provider) throws TeamRepositoryException {
        Location location = this.getLocationFor(uri);
        if (location == null) {
            return null;
        }
        IBuildResultHandle buildResultHandle = this.getBuildResultHandle(location);
        if (buildResultHandle == null) {
            return null;
        }
        ITeamRepository teamRepository = this.getTeamRepository(location, null);
        if (teamRepository == null) {
            return null;
        }
        return teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 0, null);
    }

    public boolean links(Object object) {
        if (object instanceof IBuildResultHandle) {
            return true;
        }
        return super.links(object);
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        ITeamRepository teamRepository;
        IBuildResultHandle buildResultHandle;
        URI uri;
        if (object instanceof IBuildResultHandle && (uri = BuildResultHyperlinkHandler.getAbsoluteURI((IItemHandle)(buildResultHandle = (IBuildResultHandle)object), teamRepository = (ITeamRepository)buildResultHandle.getOrigin())) != null) {
            try {
                IBuildResult buildResult = this.getBuildResultForCreateHyperlink(buildResultHandle, teamRepository);
                if (buildResult != null) {
                    String label = buildResult.getLabel();
                    if (label == null || label.length() == 0) {
                        label = BuildUIMessages.BUILD_RESULT_LABEL_UNLABELED;
                    }
                    IBuildDefinition definition = (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildResult.getBuildDefinition(), 0, monitor);
                    String name = NLS.bind((String)BuildUIMessages.BUILD_RESULT_LABEL, (Object)definition.getId(), (Object)label);
                    String details = NLS.bind((String)BuildUIMessages.BuildResultHyperlinkHandler_URIReferenceDetails, (Object)definition.getId(), (Object)label);
                    return new URIReference(name, details, uri);
                }
            }
            catch (ItemNotFoundException exception) {
                ItemNotFoundHelper.updateItemManager((IItemHandle)exception.getData());
                return new URIReference(BuildUIMessages.BUILD_RESULT_LABEL_DELETED, BuildUIMessages.BUILD_RESULT_DELETED_HYPERLINK_DETAIL, uri);
            }
            catch (TeamRepositoryException exception) {
                BuildUIPlugin.log(exception);
                return new URIReference(BuildUIMessages.BUILD_RESULT_HYPERLINK_ERROR, BuildUIMessages.BUILD_RESULT_ERROR_HYPERLINK_DETAIL, uri);
            }
        }
        return super.createHyperlink(object, monitor);
    }

    protected IBuildResult getBuildResultForCreateHyperlink(IBuildResultHandle buildResultHandle, ITeamRepository teamRepository) throws TeamRepositoryException {
        IBuildResult buildResult;
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        if (teamRepository == null) {
            return null;
        }
        if (buildResultHandle instanceof IBuildResult && this.hasRequiredCreateHyperlinkProperties(buildResult = (IBuildResult)buildResultHandle)) {
            return buildResult;
        }
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(IBuildResult.PROPERTY_LABEL);
        properties.add(IBuildResult.PROPERTY_BUILD_DEFINITION);
        return (IBuildResult)teamRepository.itemManager().fetchPartialItem((IItemHandle)buildResultHandle, 0, properties, null);
    }

    protected boolean hasRequiredCreateHyperlinkProperties(IBuildResult buildResult) {
        return buildResult.isPropertySet(IBuildResult.PROPERTY_LABEL) && buildResult.isPropertySet(IBuildResult.PROPERTY_BUILD_DEFINITION);
    }

    public boolean handles(URI uri) {
        Location location = this.getLocationForUriNoException(uri);
        if (location == null) {
            return false;
        }
        IBuildResultHandle buildResultHandle = this.getBuildResultHandle(location);
        return buildResultHandle != null;
    }

    public IStatus open2(URI uri, ContextProvider context, IProgressMonitor monitor) {
        Location location = this.getLocationForUriNoException(uri);
        if (location == null) {
            return new Status(4, BuildUIPlugin.getUniqueIdentifier(), NLS.bind((String)BuildUIMessages.BuildResultHyperlinkHandler_BAD_URI_NO_LOCATION, (Object)uri.toString()));
        }
        IBuildResultHandle buildResultHandle = this.getBuildResultHandle(location);
        if (buildResultHandle == null) {
            return new Status(4, BuildUIPlugin.getUniqueIdentifier(), NLS.bind((String)BuildUIMessages.BuildResultHyperlinkHandler_BAD_URI_NO_BUILD_RESULT, (Object)uri.toString()));
        }
        ITeamRepository teamRepository = null;
        try {
            teamRepository = this.getTeamRepository(location, monitor);
        }
        catch (TeamRepositoryException exception) {
            return new Status(4, BuildUIPlugin.getUniqueIdentifier(), NLS.bind((String)BuildUIMessages.BuildItemHyperlinkHandler_ERROR_RESOLVING_REPOSITORY, (Object)uri.toString()), (Throwable)exception);
        }
        if (teamRepository == null) {
            return new Status(4, BuildUIPlugin.getUniqueIdentifier(), NLS.bind((String)BuildUIMessages.BuildResultHyperlinkHandler_BAD_URI_BAD_REPOSITORY, (Object)uri.toString()));
        }
        this.getBuildUI().open(buildResultHandle, teamRepository, null);
        return Status.OK_STATUS;
    }

    protected BuildUI getBuildUI() {
        return BuildUI.getDefault();
    }

    protected IBuildResultHandle getBuildResultHandle(Location location) {
        ValidationHelper.validateNotNull((String)"location", (Object)location);
        if (location.getItemHandle() instanceof IBuildResultHandle) {
            return (IBuildResultHandle)location.getItemHandle();
        }
        return null;
    }
}

