/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.BuildJob;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildDefinitionHandleHelper;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDefinitionLabelProvider
extends TypeLabelProvider {
    private static final String FETCH_LOCK = "lock";
    private static BuildJob fFetchJob;
    private static Map<UUID, IBuildDefinitionHandle> fCurrentlyFetching;
    private Set<IBuildDefinition> fCachedBuildDefinitions = new HashSet<IBuildDefinition>();
    private Set<UUID> fDeletedBuildDefinitions = new HashSet<UUID>();
    private static FetchJobStatus fFetchJobStatus;
    private boolean fShowRepository;

    static {
        fCurrentlyFetching = new Hashtable<UUID, IBuildDefinitionHandle>();
        fFetchJobStatus = FetchJobStatus.NOT_RUNNING;
    }

    public BuildDefinitionLabelProvider() {
        this.fShowRepository = false;
    }

    public BuildDefinitionLabelProvider(boolean showRepository) {
        this.fShowRepository = showRepository;
    }

    public void updateLabel(ViewerLabel label, Object element) {
        Object[] labelObjects = this.getBuildDefinitionLabelObjects(element);
        String definitionId = (String)labelObjects[0];
        IBuildDefinitionHandle handle = (IBuildDefinitionHandle)labelObjects[1];
        if (handle != null) {
            label.setImage(this.getDefinitionImage());
            if (definitionId != null) {
                label.setText(this.getLabel(handle, definitionId));
            } else if (this.fDeletedBuildDefinitions.contains(handle.getItemId())) {
                label.setText(BuildUIMessages.BUILD_DEFINITION_LABEL_DELETED);
            } else {
                this.fetchDefinition(handle, element);
            }
        }
    }

    protected Object[] getBuildDefinitionLabelObjects(Object element) {
        ITeamRepository repository;
        IBuildDefinition buildDefinition;
        String definitionId = null;
        IBuildDefinition handle = null;
        if (element instanceof IBuildDefinitionStatusRecord) {
            handle = ((IBuildDefinitionStatusRecord)element).getBuildDefinition();
            definitionId = ((IBuildDefinitionStatusRecord)element).getBuildDefinition().getId();
        } else if (element instanceof IBuildDefinition) {
            handle = (IBuildDefinition)element;
            definitionId = ((IBuildDefinition)element).getId();
        } else if (element instanceof BuildDefinitionHandleHelper) {
            BuildDefinitionHandleHelper helper = (BuildDefinitionHandleHelper)element;
            handle = helper.getBuildDefinitionHandle();
            definitionId = helper.getBuildDefinitionId();
        } else if (element instanceof IBuildDefinitionHandle && (buildDefinition = (IBuildDefinition)(repository = this.getOrigin((IBuildDefinitionHandle)(handle = (IBuildDefinitionHandle)element))).itemManager().getSharedItemIfKnown((IItemHandle)handle)) != null && buildDefinition.isPropertySet(IBuildDefinition.PROPERTY_ID)) {
            definitionId = buildDefinition.getId();
        }
        return new Object[]{definitionId, handle};
    }

    protected Image getDefinitionImage() {
        return BuildUIPlugin.getImage("icons/obj16/build_type_obj.gif");
    }

    protected IBuildDefinition getBuildDefinition(IBuildDefinitionHandle handle) {
        ITeamRepository repository = this.getOrigin(handle);
        IBuildDefinition buildDefinition = (IBuildDefinition)repository.itemManager().getSharedItemIfKnown((IItemHandle)handle);
        if (buildDefinition == null || !buildDefinition.isPropertySet(IBuildDefinition.PROPERTY_ID)) {
            return null;
        }
        this.fCachedBuildDefinitions.add(buildDefinition);
        return buildDefinition;
    }

    protected String getLabel(IBuildDefinitionHandle definitionHandle, String id) {
        if (this.fShowRepository && this.getOrigin(definitionHandle) != null) {
            ITeamRepository repo = this.getOrigin(definitionHandle);
            String repoId = repo.getName();
            if (repoId == null || repoId.length() == 0) {
                repoId = repo.getRepositoryURI();
            }
            return NLS.bind((String)BuildUIMessages.BUILD_DEFINITION_LABEL_WITH_REPOSITORY, (Object)id, (Object)repoId);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchDefinition(IBuildDefinitionHandle handle, Object element) {
        String string = FETCH_LOCK;
        synchronized (FETCH_LOCK) {
            if (fCurrentlyFetching.containsKey(handle.getItemId())) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            fCurrentlyFetching.put(handle.getItemId(), handle);
            if (fFetchJob == null) {
                fFetchJob = this.createFetchJob();
            }
            if (fFetchJobStatus == FetchJobStatus.NOT_RUNNING) {
                this.scheduleFetchJob(fFetchJob);
                fFetchJobStatus = FetchJobStatus.SCHEDULED;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected void scheduleFetchJob(BuildJob fetchJob) {
        fetchJob.scheduleJob();
    }

    protected BuildJob createFetchJob() {
        return new BuildJob(BuildUIMessages.BuildDefinitionLabelProvider_FETCH_BUILD_DEFINITION_JOB_TITLE){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    BuildDefinitionLabelProvider.this.fetchBuildItems(monitor);
                }
                finally {
                    fFetchJobStatus = FetchJobStatus.NOT_RUNNING;
                }
                return Status.OK_STATUS;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void fetchBuildItems(IProgressMonitor monitor) {
        definitionsToResolve = new ArrayList<IBuildDefinitionHandle>();
        resolvedDefinitions = new ArrayList<IBuildDefinition>();
        teamRepository = null;
        while (true) {
            block33: {
                var5_5 = "lock";
                // MONITORENTER : "lock"
                if (BuildDefinitionLabelProvider.fCurrentlyFetching.size() <= 0) {
                    BuildDefinitionLabelProvider.fFetchJobStatus = FetchJobStatus.NOT_RUNNING;
                    // MONITOREXIT : var5_5
                    return;
                }
                BuildDefinitionLabelProvider.fFetchJobStatus = FetchJobStatus.RUNNING;
                definitionsToResolve.clear();
                var7_8 = BuildDefinitionLabelProvider.fCurrentlyFetching.values().iterator();
                while (true) {
                    if (!var7_8.hasNext()) {
                        // MONITOREXIT : var5_5
                        break;
                    }
                    handle = var7_8.next();
                    if (teamRepository == null) {
                        definitionsToResolve.add(handle);
                        teamRepository = this.getOrigin(handle);
                        continue;
                    }
                    if (!teamRepository.getId().equals((Object)this.getOrigin(handle).getId())) continue;
                    definitionsToResolve.add(handle);
                }
                try {
                    try {
                        definitionsToFetch = new ArrayList<IBuildDefinitionHandle>();
                        var7_8 = definitionsToResolve.iterator();
                        while (true) {
                            block35: {
                                if (var7_8.hasNext()) break block35;
                                if (definitionsToFetch.size() <= 0) break block33;
                                fetchedDefinitions = teamRepository.itemManager().fetchPartialItems(definitionsToFetch, 0, (Collection)Collections.singleton(IBuildDefinition.PROPERTY_ID), monitor);
                                i = 0;
                                if (true) ** GOTO lbl98
                            }
                            handle = (IBuildDefinitionHandle)var7_8.next();
                            definition = this.getBuildDefinition(handle);
                            if (definition == null) {
                                definitionsToFetch.add(handle);
                                continue;
                            }
                            resolvedDefinitions.add(definition);
                        }
                    }
                    catch (TeamRepositoryException exception) {
                        BuildUIPlugin.log((IStatus)new Status(4, BuildUIPlugin.getUniqueIdentifier(), BuildUIMessages.BuildResultLabelProvider_FETCH_ERROR, (Throwable)exception));
                        var10_11 = "lock";
                        // MONITORENTER : "lock"
                        var12_13 = definitionsToResolve.iterator();
                        while (true) {
                            if (!var12_13.hasNext()) {
                                // MONITOREXIT : var10_11
                            }
                            handle = (IBuildDefinitionHandle)var12_13.next();
                            BuildDefinitionLabelProvider.fCurrentlyFetching.remove(handle.getItemId());
                        }
                    }
                    this.fireLabelProviderChangeEvent(definitionsToResolve);
                    continue;
                }
                catch (Throwable var9_14) {
                    var10_11 = "lock";
                    // MONITORENTER : "lock"
                    var12_13 = definitionsToResolve.iterator();
                    while (true) {
                        if (!var12_13.hasNext()) {
                            // MONITOREXIT : var10_11
                        }
                        handle = (IBuildDefinitionHandle)var12_13.next();
                        BuildDefinitionLabelProvider.fCurrentlyFetching.remove(handle.getItemId());
                    }
                }
                this.fireLabelProviderChangeEvent(definitionsToResolve);
                throw var9_14;
                do {
                    if ((fetchedDefinition = (IBuildDefinition)fetchedDefinitions.get(i)) != null) {
                        resolvedDefinitions.add(fetchedDefinition);
                    } else {
                        this.fDeletedBuildDefinitions.add(((IBuildDefinitionHandle)definitionsToFetch.get(i)).getItemId());
                    }
                    ++i;
lbl98:
                    // 2 sources

                } while (i < fetchedDefinitions.size());
            }
            this.fCachedBuildDefinitions.addAll(resolvedDefinitions);
            var10_11 = "lock";
            // MONITORENTER : "lock"
            var12_13 = definitionsToResolve.iterator();
            while (true) {
                if (!var12_13.hasNext()) {
                    // MONITOREXIT : var10_11
                    break;
                }
                handle = (IBuildDefinitionHandle)var12_13.next();
                BuildDefinitionLabelProvider.fCurrentlyFetching.remove(handle.getItemId());
            }
            this.fireLabelProviderChangeEvent(definitionsToResolve);
        }
    }

    protected void fireLabelProviderChangeEvent(Collection<IBuildDefinitionHandle> buildDefinitionHandles) {
        final ArrayList<IBuildDefinitionHandle> buildDefinitions = new ArrayList<IBuildDefinitionHandle>();
        buildDefinitions.addAll(buildDefinitionHandles);
        this.asyncExec(new Runnable(){

            public void run() {
                BuildDefinitionLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BuildDefinitionLabelProvider.this, (Object[])buildDefinitions.toArray(new IBuildDefinitionHandle[buildDefinitions.size()])));
            }
        });
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected ITeamRepository getOrigin(IBuildDefinitionHandle buildItemHandle) {
        return (ITeamRepository)buildItemHandle.getOrigin();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FetchJobStatus {
        SCHEDULED,
        RUNNING,
        NOT_RUNNING;

    }
}

