/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.scm;

import com.ibm.team.build.internal.scm.AcceptReport;
import com.ibm.team.build.internal.scm.FolderEntry;
import com.ibm.team.build.internal.scm.ScmMessages;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.query.BaseWorkspaceQueryModel;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceControlUtility {
    static {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
            new SourceControlUtility();
        }
    }

    private SourceControlUtility() {
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, String workspaceName) throws TeamRepositoryException {
        BaseWorkspaceQueryModel.WorkspaceQueryModel queryModel = BaseWorkspaceQueryModel.WorkspaceQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        query.filter(queryModel.name()._eq((IString)query.newStringArg()));
        List workspaces = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).findItems(query, new Object[]{workspaceName});
        if (workspaces.size() > 0) {
            return (IWorkspace)workspaces.get(0);
        }
        return null;
    }

    public static void updateFileCopyArea(ITeamRepository repository, String workspaceName, String destinationPath, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        File localRoot = new File(destinationPath);
        localRoot.mkdirs();
        IWorkspace workspaceHandle = SourceControlUtility.getWorkspace(repository, workspaceName);
        SourceControlUtility.updateFileCopyArea(repository, (IWorkspaceHandle)workspaceHandle, destinationPath, Collections.EMPTY_LIST, monitor);
    }

    public static void updateFileCopyArea(ITeamRepository repository, IWorkspaceHandle workspaceHandle, String destinationPath, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SourceControlUtility.updateFileCopyArea(repository, workspaceHandle, destinationPath, Collections.EMPTY_LIST, monitor);
    }

    public static void updateFileCopyArea(ITeamRepository repository, IWorkspaceHandle workspaceHandle, String destinationPath, Collection<ILoadRule> loadRules, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        Path rootPath;
        IWorkspaceConnection workspaceConnection = null;
        File localRoot = new File(destinationPath);
        try {
            rootPath = new Path(localRoot.getCanonicalPath());
        }
        catch (IOException e) {
            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_INVALID_ROOT_PATH, (Object[])new Object[]{localRoot}), (Throwable)e);
        }
        localRoot.mkdirs();
        workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection(workspaceHandle, monitor);
        LoadDilemmaHandler handler = new LoadDilemmaHandler(){

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                for (ICollision collision : collisions) {
                    if (collision.getLocations().size() > 1) {
                        return 2;
                    }
                    collision.setLoadLocation((ILoadLocation)collision.getLocations().iterator().next());
                }
                for (IRemovedShare removedShare : removedShares) {
                    removedShare.isToBeDeleted(true);
                }
                return 0;
            }
        };
        ILoadOperation loadOp = FileSystemCore.getFileSystemManager((ITeamRepository)repository).getLocalFileSystemLoadOperation((IPath)rootPath, 2, handler);
        HashSet<UUID> componentIds = new HashSet<UUID>();
        for (ILoadRule loadRule : loadRules) {
            componentIds.add(loadRule.getComponent().getItemId());
        }
        loadOp.requestLoad(loadRules, monitor);
        for (IComponentHandle component : workspaceConnection.getComponents()) {
            if (componentIds.contains(component.getItemId())) continue;
            IConfiguration configuration = workspaceConnection.configuration(component);
            Map children = configuration.childEntriesForRoot(null);
            ArrayList<IFolderHandle> foldersToLoad = new ArrayList<IFolderHandle>(children.size());
            for (IVersionableHandle child : children.values()) {
                if (!(child instanceof IFolderHandle)) continue;
                foldersToLoad.add((IFolderHandle)child);
            }
            loadOp.requestLoad(workspaceConnection, component, foldersToLoad);
        }
        try {
            loadOp.run(monitor);
        }
        catch (FileSystemClientException exception) {
            throw new FileSystemClientException(exception.getStatus()){
                private static final long serialVersionUID = 1L;

                public String getMessage() {
                    StringBuffer messages = new StringBuffer(super.getMessage());
                    messages.append(System.getProperty("line.separator"));
                    SourceControlUtility.getChildStatusMessages(new IStatus[]{exception.getStatus()}, messages);
                    return messages.toString();
                }
            };
        }
    }

    private static void getChildStatusMessages(IStatus[] children, StringBuffer messages) {
        String newLine = System.getProperty("line.separator");
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            messages.append(status.getMessage());
            messages.append(newLine);
            SourceControlUtility.getChildStatusMessages(status.getChildren(), messages);
            ++n2;
        }
    }

    public static Map<String, Date> getLastModifiedTimes(ITeamRepository repository, File sourceDirectory, IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<FolderEntry, IBaseline> lastModifiedBaselines = SourceControlUtility.fetchLastModified(repository, sourceDirectory, workspace, monitor);
        HashMap<String, Date> lastModifiedTimes = new HashMap<String, Date>(lastModifiedBaselines.size());
        for (FolderEntry entry : lastModifiedBaselines.keySet()) {
            IBaseline baseline = lastModifiedBaselines.get(entry);
            lastModifiedTimes.put(entry.getFolderName(), baseline.getCreationDate());
        }
        return lastModifiedTimes;
    }

    public static Map<IFolderHandle, IBaseline> getLastModifiedBaselines(ITeamRepository repository, File sourceDirectory, IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<FolderEntry, IBaseline> lastModifiedBaselines = SourceControlUtility.fetchLastModified(repository, sourceDirectory, workspace, monitor);
        HashMap<IFolderHandle, IBaseline> lastModifiedTimes = new HashMap<IFolderHandle, IBaseline>(lastModifiedBaselines.size());
        for (FolderEntry entry : lastModifiedBaselines.keySet()) {
            IBaseline baseline = lastModifiedBaselines.get(entry);
            lastModifiedTimes.put(entry.getFolderHandle(), baseline);
        }
        return lastModifiedTimes;
    }

    private static Map<FolderEntry, IBaseline> fetchLastModified(ITeamRepository repository, File sourceDirectory, IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!sourceDirectory.exists()) {
            throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_DIRECTORY_DOES_NOT_EXIST, (Object[])new Object[]{sourceDirectory.getAbsolutePath()}));
        }
        File[] rootFolders = sourceDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().startsWith(".jazz");
            }
        });
        IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection(workspace, monitor);
        IComponentHandle startComponent = null;
        HashMap<UUID, ArrayList<IFolderHandle>> entriesGroupedByComponent = new HashMap<UUID, ArrayList<IFolderHandle>>();
        HashMap<UUID, String> folderNames = new HashMap<UUID, String>();
        int i = 0;
        while (i < rootFolders.length) {
            File folder = rootFolders[i];
            Map<IComponentHandle, IVersionableHandle> location = SourceControlUtility.locateFolder(connection, startComponent, folder);
            if (location == null) {
                throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_ERROR_CANNOT_FIND_FILE, (Object[])new Object[]{folder.getAbsolutePath(), sourceDirectory.getAbsolutePath()}));
            }
            startComponent = location.keySet().iterator().next();
            IVersionableHandle folderHandle = location.values().iterator().next();
            ArrayList<IFolderHandle> entries = (ArrayList<IFolderHandle>)entriesGroupedByComponent.get(startComponent.getItemId());
            if (entries == null) {
                entries = new ArrayList<IFolderHandle>();
                entriesGroupedByComponent.put(startComponent.getItemId(), entries);
            }
            entries.add((IFolderHandle)folderHandle);
            folderNames.put(folderHandle.getItemId(), folder.getName());
            ++i;
        }
        HashMap<FolderEntry, IBaseline> lastModifiedTimes = new HashMap<FolderEntry, IBaseline>(rootFolders.length);
        for (UUID componentUUID : entriesGroupedByComponent.keySet()) {
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentUUID, null);
            List folders = (List)entriesGroupedByComponent.get(componentUUID);
            List baselines = connection.getMostRecentBaselinesAffecting(componentHandle, folders, monitor);
            int i2 = 0;
            while (i2 < baselines.size()) {
                IBaseline baseline = (IBaseline)baselines.get(i2);
                FolderEntry entry = new FolderEntry((IFolderHandle)folders.get(i2), baseline.getComponent(), (String)folderNames.get(((IFolderHandle)folders.get(i2)).getItemId()));
                lastModifiedTimes.put(entry, baseline);
                ++i2;
            }
        }
        return lastModifiedTimes;
    }

    private static Map<IComponentHandle, IVersionableHandle> locateFolder(IWorkspaceConnection connection, IComponentHandle startComponent, File folder) {
        ISharingManager manager = FileSystemCore.getSharingManager();
        IShareable shareable = manager.findShareable((IPath)new Path(folder.getParentFile().getAbsolutePath()), (IPath)new Path(folder.getName()), true);
        if (shareable == null) {
            return null;
        }
        IVersionableHandle versionableHandle = shareable.getVersionable();
        if (versionableHandle == null) {
            return null;
        }
        IComponentHandle componentHandle = shareable.getShare().getSharingDescriptor().getComponent();
        HashMap<IComponentHandle, IVersionableHandle> returnVersionable = new HashMap<IComponentHandle, IVersionableHandle>(1);
        returnVersionable.put(componentHandle, versionableHandle);
        return returnVersionable;
    }

    public static AcceptReport checkForIncoming(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection(workspaceHandle, monitor);
        return SourceControlUtility.acceptAllIncoming(repository, workspaceConnection, "", true, monitor);
    }

    public static AcceptReport acceptAllIncoming(ITeamRepository repository, IWorkspaceHandle workspaceHandle, String snapshotName, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection(workspaceHandle, null);
        return SourceControlUtility.acceptAllIncoming(repository, workspaceConnection, snapshotName, false, monitor);
    }

    private static AcceptReport acceptAllIncoming(ITeamRepository repository, IWorkspaceConnection workspaceConnection, String snapshotName, boolean checkOnly, IProgressMonitor monitor) throws TeamRepositoryException {
        AcceptReport acceptReport = new AcceptReport();
        IFlowTable flowTable = workspaceConnection.getFlowTable();
        Iterator acceptSourceIter = flowTable.acceptSources().iterator();
        HashSet<UUID> incomingComponentIds = new HashSet<UUID>(workspaceConnection.getComponents().size());
        while (acceptSourceIter.hasNext()) {
            IChangeHistorySyncReport report;
            IFlowEntry flowEntry = (IFlowEntry)acceptSourceIter.next();
            IFlowNodeHandle source = flowEntry.getFlowNode();
            if (!(source instanceof IWorkspaceHandle)) continue;
            IWorkspaceConnection sourceWorkspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection((IWorkspaceHandle)source, monitor);
            ArrayList componentScopes = new ArrayList();
            componentScopes.addAll(flowTable.getComponentScopes(source));
            if (componentScopes.isEmpty()) {
                report = workspaceConnection.compareTo((IFlowNodeConnection)sourceWorkspaceConnection, WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY, Collections.EMPTY_LIST, monitor);
                componentScopes.addAll(report.remoteComponents());
            } else {
                HashSet<UUID> helper = new HashSet<UUID>();
                ArrayList<IComponentHandle> exclusions = new ArrayList<IComponentHandle>();
                for (IComponentHandle component : componentScopes) {
                    helper.add(component.getItemId());
                }
                for (IComponentHandle component : workspaceConnection.getComponents()) {
                    if (helper.contains(component.getItemId())) continue;
                    exclusions.add(component);
                }
                report = workspaceConnection.compareTo((IFlowNodeConnection)sourceWorkspaceConnection, WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY, exclusions, monitor);
            }
            for (IComponentHandle componentHandle : componentScopes) {
                if (incomingComponentIds.add(componentHandle.getItemId())) continue;
                String componentName = "";
                try {
                    IComponentHandle component;
                    component = (IComponent)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, monitor);
                    componentName = component.getName();
                }
                catch (TeamRepositoryException teamRepositoryException) {}
                throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_MULTIPLE_COMPONENT_ACCEPT_FLOWS, (Object[])new Object[]{componentName}));
            }
            SourceControlUtility.addComponents(report, workspaceConnection, (IFlowNodeConnection)sourceWorkspaceConnection, componentScopes, checkOnly, acceptReport, monitor);
            SourceControlUtility.acceptAllFromComponents(report, workspaceConnection, sourceWorkspaceConnection, componentScopes, checkOnly, acceptReport, monitor);
        }
        if (!flowTable.acceptSources().isEmpty()) {
            SourceControlUtility.removeComponents(workspaceConnection, incomingComponentIds, checkOnly, acceptReport, monitor);
        }
        if (!checkOnly) {
            if (snapshotName != null && snapshotName.length() > 0) {
                IBaselineSetHandle snapshot = workspaceConnection.createBaselineSet((Collection)Collections.EMPTY_LIST, snapshotName, ScmMessages.SourceControlUtility_SNAPSHOT_CREATED_BY_BUILD, true, monitor);
                acceptReport.addSnapshot((IBaselineSet)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)snapshot, 0, monitor));
            }
            for (IComponentHandle componentHandle : workspaceConnection.getComponents()) {
                IBaselineHandle baselineHandle = workspaceConnection.getComponentInfo(componentHandle).basis();
                SourceControlUtility.calculateBaseline(workspaceConnection, componentHandle, baselineHandle, acceptReport, monitor);
            }
        }
        return acceptReport;
    }

    private static void removeComponents(IWorkspaceConnection workspaceConnection, HashSet<UUID> incomingComponentIds, boolean checkOnly, AcceptReport acceptReport, IProgressMonitor monitor) throws TeamRepositoryException {
        List components = workspaceConnection.getComponents();
        ArrayList<IFlowNodeConnection.IComponentDeletionOp> dropOps = new ArrayList<IFlowNodeConnection.IComponentDeletionOp>();
        for (IComponentHandle componentHandle : components) {
            if (incomingComponentIds.contains(componentHandle.getItemId())) continue;
            if (!checkOnly) {
                dropOps.add(workspaceConnection.componentOpFactory().removeComponent(componentHandle, false));
            }
            acceptReport.componentRemoval(componentHandle);
        }
        if (!dropOps.isEmpty()) {
            workspaceConnection.applyComponentOperations(dropOps, monitor);
        }
    }

    private static void acceptAllFromComponents(IChangeHistorySyncReport syncReport, IWorkspaceConnection workspaceConnection, IWorkspaceConnection sourceWorkspaceConnection, List components, boolean checkOnly, AcceptReport acceptReport, IProgressMonitor monitor) throws TeamRepositoryException {
        acceptReport.addAcceptChangeSets(syncReport.incomingChangeSets());
        acceptReport.addDiscardChangeSets(syncReport.outgoingChangeSets());
        if (checkOnly) {
            return;
        }
        ArrayList<IComponentHandle> replaceComponents = new ArrayList<IComponentHandle>();
        ArrayList<IWorkspaceConnection> replaceSource = new ArrayList<IWorkspaceConnection>();
        for (IComponentHandle componentHandle : components) {
            List incomingChanges = syncReport.incomingChangeSets(componentHandle);
            List outgoingChanges = syncReport.outgoingChangeSets(componentHandle);
            if (incomingChanges.isEmpty() && outgoingChanges.isEmpty()) continue;
            replaceComponents.add(componentHandle);
            replaceSource.add(sourceWorkspaceConnection);
        }
        if (!replaceComponents.isEmpty()) {
            ArrayList<Boolean> falses = new ArrayList<Boolean>(replaceComponents.size());
            int i = 0;
            while (i < replaceComponents.size()) {
                falses.add(false);
                ++i;
            }
            workspaceConnection.replaceComponents(replaceComponents, replaceSource, falses, false, monitor);
        }
    }

    private static void addComponents(IChangeHistorySyncReport report, IWorkspaceConnection workspaceConnection, IFlowNodeConnection sourceWorkspaceConnection, List components, boolean checkOnly, AcceptReport acceptReport, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IFlowNodeConnection.IComponentAdditionOp> addOps = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
        Iterator iter = components.iterator();
        while (iter.hasNext()) {
            IComponentHandle componentHandle = (IComponentHandle)iter.next();
            if (SourceControlUtility.componentExists(componentHandle, report.localComponents())) continue;
            if (!checkOnly) {
                addOps.add(workspaceConnection.componentOpFactory().addComponent(componentHandle, (IConnection)sourceWorkspaceConnection, false));
            }
            acceptReport.componentAdd(componentHandle);
            iter.remove();
        }
        if (!addOps.isEmpty()) {
            workspaceConnection.applyComponentOperations(addOps, monitor);
        }
        if (!checkOnly) {
            for (IComponentHandle componentHandle : components) {
                List activeCS = workspaceConnection.activeChangeSets(componentHandle);
                if (activeCS.isEmpty()) continue;
                workspaceConnection.closeChangeSets((Collection)activeCS, monitor);
            }
        }
    }

    private static void calculateBaseline(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IBaselineHandle baselineHandle, AcceptReport acceptReport, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)baselineHandle);
        IBaseline baselineOfComponent = (IBaseline)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineHandle, 0, monitor);
        acceptReport.addComponentBaseline(baselineOfComponent);
    }

    private static boolean componentExists(IComponentHandle componentHandle, Collection components) {
        for (IComponentHandle existingComponentHandle : components) {
            if (!existingComponentHandle.getItemId().equals((Object)componentHandle.getItemId())) continue;
            return true;
        }
        return false;
    }
}

