/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.publishing;

import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.workitem.WorkItemHelper;
import com.ibm.team.build.internal.common.ChangeSetInfo;
import com.ibm.team.build.internal.common.helper.ItemHelper;
import com.ibm.team.build.internal.publishing.PublishingMessages;
import com.ibm.team.build.internal.publishing.workitem.WorkItemPublishStatus;
import com.ibm.team.build.publishing.workitem.FileTypes;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.ILinkFactory;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.links.internal.links.LinksPackage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IHelperType;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemPublisher {
    private static final IWorkItemHandle[] EMPTY_WORKITEM_ARRAY = new IWorkItemHandle[0];

    public WorkItemPublishStatus publish(IBuildResultHandle buildResult, String inputFilePath, ITeamRepository teamRepository, FileTypes inputFileType) throws TeamRepositoryException {
        try {
            if (inputFileType == null || inputFileType.equals((Object)FileTypes.CHANGESET)) {
                IChangeSetHandle[] changeSetHandles = this.getChangeSetHandles(inputFilePath);
                return new WorkItemPublishStatus(this.publish(buildResult, changeSetHandles, teamRepository));
            }
            WorkItemPublishStatus status = this.getWorkItemHandles(inputFilePath, teamRepository);
            this.publish(buildResult, status.getWorkItemHandles(), teamRepository);
            return status;
        }
        catch (IOException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    public IWorkItemHandle[] publish(IBuildResultHandle buildResult, IChangeSetHandle[] changeSetHandles, ITeamRepository teamRepository) throws TeamRepositoryException {
        IWorkItemHandle[] workItemHandles = null;
        workItemHandles = this.getWorkItemHandles(changeSetHandles, teamRepository);
        this.publish(buildResult, workItemHandles, teamRepository);
        return workItemHandles;
    }

    public void publish(IBuildResultHandle buildResult, IWorkItemHandle[] workItemHandles, ITeamRepository teamRepository) throws TeamRepositoryException {
        IBuildResult result = WorkItemHelper.setFixedInBuild((ITeamRepository)teamRepository, (IBuildResultHandle)buildResult, (IWorkItemHandle[])workItemHandles);
        this.tagWorkItems(workItemHandles, result, teamRepository);
    }

    private IWorkItemHandle[] getWorkItemHandles(IChangeSetHandle[] changeSetHandles, ITeamRepository teamRepository) throws TeamRepositoryException {
        Hashtable<String, IWorkItemHandle> workItemHandles = new Hashtable<String, IWorkItemHandle>();
        if (this.isLinkTypeRegistered()) {
            int i = 0;
            while (i < changeSetHandles.length) {
                IChangeSetHandle changeSetHandle = changeSetHandles[i];
                List links = ChangeSetLinks.findLinks((ProviderFactory)((ProviderFactory)teamRepository.getClientLibrary(ProviderFactory.class)), (IChangeSetHandle)changeSetHandle, (IProgressMonitor)new NullProgressMonitor());
                for (ILink link : links) {
                    IReference targetRef = link.getTargetRef();
                    if (!targetRef.isItemReference() || !(((IItemReference)targetRef).getReferencedItem() instanceof IWorkItemHandle)) continue;
                    IWorkItemHandle workItemHandle = (IWorkItemHandle)((IItemReference)targetRef).getReferencedItem();
                    workItemHandles.put(workItemHandle.getItemId().getUuidValue(), workItemHandle);
                }
                ++i;
            }
        }
        return workItemHandles.values().toArray(new IWorkItemHandle[workItemHandles.size()]);
    }

    protected boolean isLinkTypeRegistered() {
        return ILinkTypeRegistry.INSTANCE.isRegistered("com.ibm.team.filesystem.workitems.change_set");
    }

    private void tagWorkItems(IWorkItemHandle[] workItemHandles, IBuildResult buildResult, ITeamRepository teamRepository) throws TeamRepositoryException {
        ILinkManager linkManager = (ILinkManager)teamRepository.getClientLibrary(ILinkManager.class);
        List unlinkedWorkItems = this.findUnlinkedWorkItems(workItemHandles, buildResult, linkManager);
        ArrayList<ILink> links = new ArrayList<ILink>();
        List workItems = teamRepository.itemManager().fetchCompleteItems(unlinkedWorkItems, 1, null);
        for (IWorkItem workItem : workItems) {
            links.add(this.createLink(teamRepository, workItem, buildResult));
        }
        linkManager.saveLinks(links, null);
    }

    private List findUnlinkedWorkItems(IWorkItemHandle[] workItemHandles, IBuildResult buildResult, ILinkManager linkManager) throws TeamRepositoryException {
        ILinkQueryPage results = linkManager.findLinksByTarget("com.ibm.team.build.linktype.includedWorkItems", (IReference)IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)buildResult), null);
        ILinkCollection linkCollection = results.getAllLinksFromHereOn();
        HashMap<UUID, IWorkItemHandle> unlinked = new HashMap<UUID, IWorkItemHandle>();
        int i = 0;
        while (i < workItemHandles.length) {
            unlinked.put(workItemHandles[i].getItemId(), workItemHandles[i]);
            ++i;
        }
        Iterator iter = linkCollection.iterator();
        while (iter.hasNext()) {
            IReference reference = ((ILink)iter.next()).getSourceRef();
            if (!reference.isItemReference() || ((IItemReference)reference).getReferencedItem() == null) continue;
            unlinked.remove(((IItemReference)reference).getReferencedItem().getItemId());
        }
        return new ArrayList(unlinked.values());
    }

    private ILink createLink(ITeamRepository teamRepository, IWorkItem workItem, IBuildResult result) throws TeamRepositoryException {
        IBuildDefinition definition = (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)result.getBuildDefinition(), 0, null);
        IHelperType helperType = IHelperType.IRegistry.INSTANCE.getHelperType(LinksPackage.eINSTANCE.getReference().getName(), "com.ibm.team.links");
        String sourceComment = ItemHelper.validateStringAttributeLength((String)(String.valueOf(definition.getId()) + " " + result.getLabel()), (IType)helperType, (String)LinksPackage.eINSTANCE.getReference_Comment().getName());
        IItemReference source = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)result, sourceComment);
        String targetComment = ItemHelper.validateStringAttributeLength((String)WorkItemTextUtilities.getWorkItemText((IWorkItem)workItem), (IType)helperType, (String)LinksPackage.eINSTANCE.getReference_Comment().getName());
        IItemReference target = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)workItem, targetComment);
        return ILinkFactory.INSTANCE.createLink("com.ibm.team.build.linktype.includedWorkItems", (IReference)source, (IReference)target);
    }

    private WorkItemPublishStatus getWorkItemHandles(String inputFilePath, ITeamRepository teamRepository) throws TeamBuildException, TeamRepositoryException, IOException {
        ArrayList<Integer> workItemIds = new ArrayList<Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(inputFilePath));
        String workItemId = reader.readLine();
        while (workItemId != null) {
            workItemId = workItemId.trim();
            try {
                if (!workItemId.equals("")) {
                    workItemIds.add(Integer.valueOf(workItemId));
                }
            }
            catch (NumberFormatException exception) {
                throw new TeamBuildException(NLS.bind((String)PublishingMessages.WorkItemPublisher_BAD_WORKITEM_ID, (Object)workItemId, (Object)inputFilePath), (Throwable)exception);
            }
            workItemId = reader.readLine();
        }
        IWorkItemHandle[] foundWorkItems = this.getWorkItemHandles(workItemIds, teamRepository);
        return new WorkItemPublishStatus(foundWorkItems, workItemIds.size());
    }

    private IWorkItemHandle[] getWorkItemHandles(List<Integer> workItemIds, ITeamRepository teamRepository) throws TeamRepositoryException {
        if (workItemIds.size() == 0) {
            return EMPTY_WORKITEM_ARRAY;
        }
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        List handles = workItemClient.findWorkItemsById(workItemIds, null);
        return handles.toArray(new IWorkItemHandle[handles.size()]);
    }

    private IChangeSetHandle[] getChangeSetHandles(String changeSetFilePath) throws IOException, TeamRepositoryException {
        ChangeSetInfo changeSetInfo = new ChangeSetInfo(new File(changeSetFilePath));
        IChangeSetHandle[] changeSetHandles = changeSetInfo.getChangeSets();
        return changeSetHandles;
    }
}

