/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.parser.ParserMessages;
import com.ibm.team.build.internal.parser.SkipElementException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractParserHandlerBase
extends DefaultHandler2 {
    private File fFileToParse;
    private String fStringToParse;
    private Stack<ElementContext> fElementContext = new Stack();
    private List<String> fParseErrors = new LinkedList<String>();

    protected AbstractParserHandlerBase(File fileToParse) {
        ValidationHelper.validateNotNull((String)"fileToParse", (Object)fileToParse);
        this.fFileToParse = fileToParse;
    }

    protected AbstractParserHandlerBase(String stringToParse) {
        ValidationHelper.validateNotEmpty((String)"stringToParse", (String)stringToParse);
        this.fStringToParse = stringToParse;
    }

    public void parse() throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        BufferedInputStream bufferedInputStream = null;
        InputSource source = new InputSource();
        try {
            if (this.fFileToParse != null) {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(this.fFileToParse));
                source.setByteStream(bufferedInputStream);
            } else {
                source.setCharacterStream(new StringReader(this.fStringToParse));
            }
            xmlReader.parse(source);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    protected void error(String errorMessage) {
        this.addParseError(errorMessage);
    }

    protected void error(String errorMessage, boolean fatal) throws SkipElementException {
        this.addParseError(errorMessage);
        if (fatal) {
            throw new SkipElementException();
        }
    }

    public void error(SAXParseException e) {
        this.addParseError(e.getLocalizedMessage());
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.fElementContext.peek().addCharacterData(ch, start, length);
    }

    protected StringBuffer getCurrentCharacterData() {
        return this.fElementContext.peek().characterData;
    }

    public String[] getParseErrors() {
        return this.fParseErrors.toArray(new String[this.fParseErrors.size()]);
    }

    public void addParseError(String message) {
        this.fParseErrors.add(message);
    }

    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name;
        String string = name = localName.equals("") ? qName : localName;
        if (!this.startNewContext(name)) {
            return;
        }
        if (this.getCurrentContext() == BaseContextType.PARSING_IGNORED_NODE) {
            return;
        }
        try {
            this.startChildElement(attributes);
        }
        catch (SkipElementException skipElementException) {
            this.endCurrentContext();
            this.startNewIgnoredElementContext();
            return;
        }
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        if (!(this.getCurrentContext() instanceof BaseContextType)) {
            try {
                this.endChildElement();
            }
            catch (SkipElementException skipElementException) {}
        }
        this.endCurrentContext();
    }

    protected abstract void startChildElement(Attributes var1) throws SAXException, SkipElementException;

    protected abstract void endChildElement() throws SAXException, SkipElementException;

    protected abstract ContextType getContextForElement(String var1);

    protected abstract ContextType getValidChildElementContext(ContextType var1, ContextType var2);

    protected abstract ContextType getValidRootElementContext(ContextType var1) throws SAXParseException;

    public final void startDocument() {
        this.startNewContext(BaseContextType.PARSING_NONE, null);
    }

    protected String getCurrentContextName() {
        return this.fElementContext.peek().contextName;
    }

    protected ContextType getCurrentContext() {
        return this.fElementContext.peek().contextType;
    }

    protected ContextType getParentContext() {
        return this.fElementContext.peek().parentContext == null ? null : this.fElementContext.peek().parentContext.contextType;
    }

    protected String getParentContextName() {
        return this.fElementContext.peek().parentContext == null ? null : this.fElementContext.peek().parentContext.contextName;
    }

    private ContextType endCurrentContext() {
        return this.fElementContext.pop().contextType;
    }

    private void startNewContext(ContextType newContext, String contextName) {
        ElementContext parentContext = null;
        if (this.fElementContext.size() > 0) {
            parentContext = this.fElementContext.peek();
        }
        this.fElementContext.push(new ElementContext(newContext, contextName, parentContext));
    }

    private boolean startNewContext(String elementName) throws SAXParseException {
        ContextType newContext = null;
        boolean rootContext = false;
        if (this.getCurrentContext() instanceof BaseContextType) {
            switch ((BaseContextType)this.getCurrentContext()) {
                case PARSING_IGNORED_NODE: {
                    this.startNewIgnoredElementContext();
                    return false;
                }
                case PARSING_EMPTY_NODE: {
                    this.unexpectedElementError(elementName);
                    this.startNewIgnoredElementContext();
                    return false;
                }
                case PARSING_NONE: {
                    rootContext = true;
                }
            }
        }
        if ((newContext = this.getContextForElement(elementName)) != null) {
            newContext = rootContext ? this.getValidRootElementContext(newContext) : this.getValidChildElementContext(newContext, this.getCurrentContext());
        }
        if (newContext == null) {
            this.unexpectedElementError(elementName);
            this.startNewIgnoredElementContext();
            return false;
        }
        this.startNewContext(newContext, elementName);
        return true;
    }

    private void startNewIgnoredElementContext() {
        this.startNewContext(BaseContextType.PARSING_IGNORED_NODE, null);
    }

    protected ContextType getIgnoreContext() {
        return BaseContextType.PARSING_IGNORED_NODE;
    }

    protected ContextType getEmptyContext() {
        return BaseContextType.PARSING_EMPTY_NODE;
    }

    protected void verifySubElement(String subElementName, boolean isSet, boolean necessary) throws SkipElementException {
        if (!isSet) {
            this.error(NLS.bind((String)ParserMessages.MISSING_REQUIRED_CHILD_ELEMENT, (Object)subElementName, (Object)this.getCurrentContextName()), necessary);
        }
    }

    protected String getOptionalAttribute(Attributes attributes, String attributeName) throws SkipElementException {
        return this.getOptionalAttribute(attributes, attributeName, true);
    }

    protected String getOptionalAttribute(Attributes attributes, String attributeName, boolean mayBeEmpty) throws SkipElementException {
        return this.doGetAttribute(attributes, attributeName, false, false, mayBeEmpty);
    }

    protected String getRequiredAttribute(Attributes attributes, String attributeName, boolean necessary) throws SkipElementException {
        String value = this.doGetAttribute(attributes, attributeName, necessary, true);
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected String getRequiredAttribute(Attributes attributes, String attributeName, boolean necessary, boolean mayBeEmpty) throws SkipElementException {
        return this.doGetAttribute(attributes, attributeName, necessary, true, mayBeEmpty);
    }

    private String doGetAttribute(Attributes attributes, String attributeName, boolean necessary, boolean required) throws SkipElementException {
        return this.doGetAttribute(attributes, attributeName, necessary, required, false);
    }

    private String doGetAttribute(Attributes attributes, String attributeName, boolean necessary, boolean required, boolean mayBeEmpty) throws SkipElementException {
        String attributeValue = attributes.getValue(attributeName);
        String errorMessage = null;
        if (attributeValue == null) {
            if (required) {
                errorMessage = NLS.bind((String)ParserMessages.MISSING_REQUIRED_ATTRIBUTE, (Object)attributeName, (Object)this.getCurrentContextName());
            }
        } else if (attributeValue.length() == 0 && !mayBeEmpty) {
            errorMessage = NLS.bind((String)ParserMessages.INVALID_ATTRIBUTE_VALUE, (Object[])new String[]{attributeValue, attributeName, this.getCurrentContextName()});
            if (required) {
                attributeValue = null;
            }
        }
        if (errorMessage != null) {
            this.error(errorMessage, necessary);
        }
        return attributeValue;
    }

    protected String getOptionalAttribute(Attributes attributes, String attributeName, String[] validValues) throws SkipElementException {
        return this.doGetAttribute(attributes, attributeName, validValues, false, false);
    }

    protected String getRequiredAttribute(Attributes attributes, String attributeName, String[] validValues, boolean necessary) throws SkipElementException {
        return this.doGetAttribute(attributes, attributeName, validValues, necessary, true);
    }

    private String doGetAttribute(Attributes attributes, String attributeName, String[] validValues, boolean necessary, boolean required) throws SkipElementException {
        String attributeValue = this.doGetAttribute(attributes, attributeName, necessary, required);
        if (attributeValue != null) {
            boolean valid = false;
            String[] stringArray = validValues;
            int n = validValues.length;
            int n2 = 0;
            while (n2 < n) {
                String validValue = stringArray[n2];
                if (validValue.equals(attributeValue)) {
                    valid = true;
                }
                ++n2;
            }
            if (!valid) {
                this.error(NLS.bind((String)ParserMessages.INVALID_ATTRIBUTE_VALUE, (Object[])new String[]{attributeValue, attributeName, this.getCurrentContextName()}), necessary);
                attributeValue = "";
            }
        }
        return attributeValue;
    }

    protected Float getOptionalNumericAttribute(Attributes attributes, String attributeName, boolean positive, boolean nonZero) throws SkipElementException {
        return this.doGetNumericAttribute(attributes, attributeName, positive, nonZero, false, false);
    }

    protected Float getOptionalNumericAttribute(Attributes attributes, String attributeName, boolean positive, boolean nonZero, float defaultValue) throws SkipElementException {
        Float value = this.doGetNumericAttribute(attributes, attributeName, positive, nonZero, false, false);
        return Float.valueOf(value == null ? defaultValue : value.floatValue());
    }

    protected Float getRequiredNumericAttribute(Attributes attributes, String attributeName, boolean positive, boolean nonZero) throws SkipElementException {
        return this.doGetNumericAttribute(attributes, attributeName, positive, nonZero, true, true);
    }

    protected float getRequiredNumericAttribute(Attributes attributes, String attributeName, boolean positive, boolean nonZero, float defaultValue) throws SkipElementException {
        Float value = this.doGetNumericAttribute(attributes, attributeName, positive, nonZero, false, true);
        return value == null ? defaultValue : value.floatValue();
    }

    private Float doGetNumericAttribute(Attributes attributes, String attributeName, boolean positive, boolean nonZero, boolean necessary, boolean required) throws SkipElementException {
        Float value = null;
        String attributeValue = this.doGetAttribute(attributes, attributeName, necessary, required);
        if (attributeValue != null) {
            boolean invalid = false;
            try {
                value = Float.valueOf(Float.parseFloat(attributeValue));
            }
            catch (NumberFormatException numberFormatException) {
                invalid = true;
            }
            if (invalid || positive && value.floatValue() < 0.0f || nonZero && value.floatValue() == 0.0f) {
                this.error(NLS.bind((String)ParserMessages.INVALID_ATTRIBUTE_VALUE, (Object[])new String[]{attributeValue, attributeName, this.getCurrentContextName()}), necessary);
                value = null;
            }
        }
        return value;
    }

    protected Long getOptionalWholeNumberAttribute(Attributes attributes, String attributeName, boolean positive, boolean nonZero) throws SkipElementException {
        return this.doGetWholeNumberAttribute(attributes, attributeName, positive, nonZero, false, false);
    }

    protected Long getOptionalWholeNumberAttribute(Attributes attributes, String attributeName, boolean positive, boolean nonZero, long defaultValue) throws SkipElementException {
        Long value = this.doGetWholeNumberAttribute(attributes, attributeName, positive, nonZero, false, false);
        return value == null ? defaultValue : value;
    }

    protected Long getRequiredWholeNumberAttribute(Attributes attributes, String attributeName, boolean positive, boolean nonZero) throws SkipElementException {
        return this.doGetWholeNumberAttribute(attributes, attributeName, positive, nonZero, true, true);
    }

    protected long getRequiredWholeNumberAttribute(Attributes attributes, String attributeName, boolean positive, boolean nonZero, long defaultValue) throws SkipElementException {
        Long value = this.doGetWholeNumberAttribute(attributes, attributeName, positive, nonZero, false, true);
        return value == null ? defaultValue : value;
    }

    private Long doGetWholeNumberAttribute(Attributes attributes, String attributeName, boolean positive, boolean nonZero, boolean necessary, boolean required) throws SkipElementException {
        Long value = null;
        String attributeValue = this.doGetAttribute(attributes, attributeName, necessary, required);
        if (attributeValue != null) {
            boolean invalid = false;
            try {
                value = Long.parseLong(attributeValue);
            }
            catch (NumberFormatException numberFormatException) {
                invalid = true;
            }
            if (invalid || positive && value < 0L || nonZero && value == 0L) {
                this.error(NLS.bind((String)ParserMessages.INVALID_ATTRIBUTE_VALUE, (Object[])new String[]{attributeValue, attributeName, this.getCurrentContextName()}), necessary);
                value = null;
            }
        }
        return value;
    }

    protected void unexpectedElementError() {
        this.unexpectedElementError(this.getCurrentContextName(), this.getParentContextName());
    }

    protected void unexpectedElementError(String unexpectedElementName) {
        this.unexpectedElementError(unexpectedElementName, this.getCurrentContextName());
    }

    protected void unexpectedElementError(String unexpectedElementName, String parentElementName) {
        if (parentElementName == null) {
            this.error(NLS.bind((String)ParserMessages.UNEXPECTED_ELEMENT, (Object)unexpectedElementName));
        } else {
            this.error(NLS.bind((String)ParserMessages.UNEXPECTED_CHILD_ELEMENT, (Object)unexpectedElementName, (Object)parentElementName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum BaseContextType implements ContextType
    {
        PARSING_NONE,
        PARSING_IGNORED_NODE,
        PARSING_EMPTY_NODE;

    }

    protected static interface ContextType {
    }

    protected class ElementContext {
        ContextType contextType;
        String contextName;
        StringBuffer characterData;
        ElementContext parentContext;

        ElementContext(ContextType type, String name, ElementContext parent) {
            this.contextType = type;
            this.contextName = name;
            this.parentContext = parent;
        }

        void addCharacterData(char[] ch, int start, int length) {
            if (this.characterData == null) {
                this.characterData = new StringBuffer();
            }
            this.characterData.append(new String(ch, start, length));
        }
    }
}

