/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.helper;

import com.ibm.team.build.internal.common.l10n.Messages;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsHelper {
    public static final String TAG_STRING_SEPARATOR = ",";
    public static final String SPACE = " ";

    public static Collection<String> parseTags(String value) {
        ArrayList<String> result = new ArrayList<String>();
        TagsHelper.parseTags(result, value);
        return result;
    }

    public static void parseTags(Collection<String> result, String value) {
        if (value.length() > 0) {
            String[] tags = value.split(TAG_STRING_SEPARATOR);
            int j = 0;
            while (j < tags.length) {
                String part = tags[j].trim();
                if (part.length() > 0 && !result.contains(part)) {
                    result.add(part);
                }
                ++j;
            }
        }
    }

    public static String normalizeTags(String tags) {
        String result = "";
        if (tags.length() > 0) {
            String[] parsed;
            String[] stringArray = parsed = TagsHelper.normalizeAndParseTags(tags);
            int n = parsed.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                if (entry.length() > 0) {
                    result = String.valueOf(result) + ", " + entry;
                }
                ++n2;
            }
            if (result.length() > 0) {
                result = result.substring(2);
            }
        }
        return result;
    }

    public static String[] normalizeAndParseTags(String tags) {
        if (tags.length() > 0) {
            tags = tags.replaceAll(SPACE, TAG_STRING_SEPARATOR);
            tags = tags.toLowerCase();
            Collection<String> parsed = TagsHelper.parseTags(tags);
            return parsed.toArray(new String[parsed.size()]);
        }
        return new String[0];
    }

    public static void validateOnlyOneTag(String parameterName, String tag) throws IllegalArgumentException {
        if (!TagsHelper.isOnlyOneTag(tag)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("TagsHelper.0"), (Object)parameterName));
        }
    }

    public static boolean isOnlyOneTag(String tag) {
        return !tag.contains(SPACE) && !tag.contains(TAG_STRING_SEPARATOR);
    }
}

