/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.setup.ui.internal.wizard;

import com.ibm.team.apt.setup.ui.internal.wizard.Messages;
import com.ibm.team.apt.setup.ui.internal.wizard.SampleRepositorySetupContext;
import com.ibm.team.apt.setup.ui.internal.wizard.SetupUIPlugin;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class SummaryWizardPage
extends WizardPage {
    private SampleRepositorySetupContext fContext;
    ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Label fSummaryText;
    private Button fShowGettingStarted;
    private Group fContainer;

    protected SummaryWizardPage(SampleRepositorySetupContext context) {
        super("com.ibm.team.apt.setup.ui.internal.wizard.summaryPage", Messages.SummaryWizardPage_TITLE, SetupUIPlugin.WIZARD_BANNER);
        this.fContext = context;
        this.setDescription(Messages.SummaryWizardPage_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fContainer = new Group(parent, 0);
        this.fContainer.setText(Messages.SummaryWizardPage_SUMMARY_LABEL);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(0, this.convertHeightInCharsToPixels(2)).applyTo((Composite)this.fContainer);
        this.fSummaryText = new Label((Composite)this.fContainer, 64);
        GridDataFactory.fillDefaults().grab(true, false).hint(this.convertWidthInCharsToPixels(80), -1).align(4, 128).applyTo((Control)this.fSummaryText);
        this.fShowGettingStarted = new Button((Composite)this.fContainer, 32);
        this.fShowGettingStarted.setText(Messages.SummaryWizardPage_OPEN_GETTING_STARTED_LABEL);
        this.fShowGettingStarted.setSelection(this.fContext.isShowGettingStarted());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)this.fShowGettingStarted);
        this.fShowGettingStarted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SummaryWizardPage.this.fContext.setShowGettingStarted(SummaryWizardPage.this.fShowGettingStarted.getSelection());
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)this.fContainer);
        Dialog.applyDialogFont((Control)this.fContainer);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            ITeamRepository teamRepository = this.fContext.getTeamRepository();
            String repositoryLabel = teamRepository.getRepositoryURI();
            if (teamRepository.getName() != null && !"".equals(teamRepository.getName())) {
                repositoryLabel = NLS.bind((String)"{0}  [{1}]", (Object[])new Object[]{teamRepository.getName(), teamRepository.getRepositoryURI()});
            }
            String text = NLS.bind((String)Messages.SummaryWizardPage_SUMMARY_MESSAGE, (Object[])new Object[]{this.fContext.getSetupDefinition().getName(), repositoryLabel});
            this.fSummaryText.setText(text);
            boolean showGettingStrated = this.fContext.getSetupDefinition().getGettingStartedHelpHref() != null;
            this.fShowGettingStarted.setVisible(showGettingStrated);
            ((GridData)this.fShowGettingStarted.getLayoutData()).exclude = !showGettingStrated;
            this.fContainer.layout(true, true);
        }
        this.setPageComplete(visible);
        super.setVisible(visible);
    }

    public void dispose() {
        this.fResourceManager.dispose();
    }
}

