/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.setup.ui.internal.wizard;

import com.ibm.team.apt.setup.ui.internal.wizard.MessageWizardPage;
import com.ibm.team.apt.setup.ui.internal.wizard.Messages;
import com.ibm.team.apt.setup.ui.internal.wizard.SampleRepositorySetupContext;
import com.ibm.team.apt.setup.ui.internal.wizard.SampleSetupSelectionWizardPage;
import com.ibm.team.apt.setup.ui.internal.wizard.SetupUIPlugin;
import com.ibm.team.apt.setup.ui.internal.wizard.SummaryWizardPage;
import com.ibm.team.apt.setup.ui.internal.wizard.WelcomeWizardPage;
import com.ibm.team.foundation.setup.client.ProjectSetupException;
import com.ibm.team.foundation.setup.client.internal.ProjectSetupExecutor;
import com.ibm.team.foundation.setup.client.internal.registry.ProjectSetupDefinition;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.rcp.ui.RepositoryCreationPage;
import com.ibm.team.process.rcp.ui.RepositorySelectionPage;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.IExternalUserRegistryManager;
import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;

public class SetupSampleRepositoryWizard
extends Wizard
implements INewWizard {
    private WelcomeWizardPage fWelcomePage;
    private RepositorySelectionPage fRepositorySelectionPage;
    private RepositoryCreationPage fRepositoryCreationPage;
    private MessageWizardPage fMessagePage;
    private SampleSetupSelectionWizardPage fSetupTypePage;
    private SampleRepositorySetupContext fContext = new SampleRepositorySetupContext();
    private SummaryWizardPage fSummaryWizardPage;

    public SetupSampleRepositoryWizard() {
        this.setWindowTitle(Messages.SetupSampleRepositoryWizard_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.fWelcomePage = new WelcomeWizardPage();
        this.addPage((IWizardPage)this.fWelcomePage);
        this.fRepositoryCreationPage = new RepositoryCreationPage(Messages.SetupSampleRepositoryWizard_CREATE_CONNECTION_TITLE);
        this.fRepositoryCreationPage.setImageDescriptor(SetupUIPlugin.WIZARD_BANNER);
        this.addPage((IWizardPage)this.fRepositoryCreationPage);
        this.fRepositorySelectionPage = new RepositorySelectionPage(Messages.SetupSampleRepositoryWizard_SELECT_CREATE_CONNECTION_TITLE);
        this.fRepositorySelectionPage.setImageDescriptor(SetupUIPlugin.WIZARD_BANNER);
        this.addPage((IWizardPage)this.fRepositorySelectionPage);
        this.fMessagePage = new MessageWizardPage();
        this.addPage((IWizardPage)this.fMessagePage);
        this.fSetupTypePage = new SampleSetupSelectionWizardPage(this.fContext);
        this.addPage((IWizardPage)this.fSetupTypePage);
        this.fSummaryWizardPage = new SummaryWizardPage(this.fContext);
        this.addPage((IWizardPage)this.fSummaryWizardPage);
    }

    public boolean performFinish() {
        if (!this.fContext.isComplete()) {
            return false;
        }
        try {
            final ITeamRepository teamRepository = this.fContext.getTeamRepository();
            final ProjectSetupDefinition setupDefinition = this.fContext.getSetupDefinition();
            IRunnableWithProgress setup = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        try {
                            Object projectSetupResult = ProjectSetupExecutor.executeSetup((ITeamRepository)teamRepository, (ProjectSetupDefinition)setupDefinition, (IProgressMonitor)progress.newChild(98));
                            SetupSampleRepositoryWizard.this.getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    IIntroURL introUrl = IntroURLFactory.createIntroURL((String)"http://org.eclipse.ui.intro/switchToLaunchBar");
                                    if (introUrl != null) {
                                        introUrl.execute();
                                    }
                                    if (SetupSampleRepositoryWizard.this.fContext.isShowGettingStarted() && setupDefinition.getGettingStartedHelpHref() != null) {
                                        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(setupDefinition.getGettingStartedHelpHref());
                                    }
                                }
                            });
                            if (projectSetupResult instanceof IProjectArea) {
                                TeamPlatform.getTeamRepositoryService().addTeamRepository(teamRepository);
                                ConnectedProjectAreaRegistry.getDefault().addConnectedProjectArea((IProjectArea)projectSetupResult);
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.getContainer().run(true, false, setup);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            if (exception instanceof ProjectSetupException) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.SetupSampleRepositoryWizard_PROJECT_SETUP_FAILED_TITLE, (String)exception.getLocalizedMessage());
            } else {
                Throwable exceptionToShow = exception != null ? exception : e;
                SetupUIPlugin.log(exceptionToShow);
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.SetupSampleRepositoryWizard_ERROR_DIALOG_TITLE, null, (IStatus)new Status(4, SetupUIPlugin.getPluginId(), Messages.SetupSampleRepositoryWizard_ERROR_DIALOG_MESSAGE, exceptionToShow));
            }
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fWelcomePage) {
            ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            boolean hasTeamRepository = repositories.length > 0;
            return hasTeamRepository ? this.fRepositorySelectionPage : this.fRepositoryCreationPage;
        }
        if (page == this.fRepositoryCreationPage) {
            ITeamRepository repo = this.fRepositoryCreationPage.createRepository(true);
            if (repo != null) {
                this.fContext.setTeamRepository(repo);
                return this.checkPreconditions(repo, (IWizardPage)this.fSetupTypePage);
            }
            return null;
        }
        if (page == this.fRepositorySelectionPage) {
            ITeamRepository repo = this.fRepositorySelectionPage.getTeamRepository();
            if (repo == null) {
                return this.fRepositoryCreationPage;
            }
            this.fContext.setTeamRepository(repo);
            return this.checkPreconditions(repo, (IWizardPage)this.fSetupTypePage);
        }
        if (page == this.fSetupTypePage && !this.fContext.isBuildPresent()) {
            return this.fSummaryWizardPage;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        if (!this.fContext.isComplete()) {
            return false;
        }
        IWizardPage[] iWizardPageArray = new IWizardPage[]{this.fMessagePage, this.fSetupTypePage, this.fSummaryWizardPage};
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (!page.isPageComplete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private IWizardPage checkPreconditions(final ITeamRepository repo, IWizardPage successPage) {
        final boolean[] hasDeveloperCAL = new boolean[1];
        final boolean[] isJazzAdmin = new boolean[1];
        final boolean[] canCreateUsers = new boolean[1];
        try {
            IRunnableWithProgress setup = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 1000);
                    try {
                        try {
                            if (!repo.loggedIn()) {
                                repo.login((IProgressMonitor)new SubProgressMonitor(monitor, 500));
                            } else {
                                monitor.worked(500);
                            }
                            ILicenseClient licenseClient = (ILicenseClient)repo.getClientLibrary(ILicenseClient.class);
                            licenseClient.flushCache();
                            try {
                                licenseClient.assertLicense("com.ibm.team.process.server.saveProjectArea", (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                                hasDeveloperCAL[0] = true;
                            }
                            catch (LicenseNotGrantedException licenseNotGrantedException) {
                                hasDeveloperCAL[0] = false;
                            }
                            IExternalUserRegistryManager userRegistryManager = repo.externalUserRegistryManager();
                            isJazzAdmin[0] = userRegistryManager.isMember(repo.getUserId(), "JazzAdmins", (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                            canCreateUsers[0] = userRegistryManager.isExternalRegistryWriteable((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        }
                        catch (PermissionDeniedException permissionDeniedException) {
                            isJazzAdmin[0] = false;
                            monitor.done();
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.getContainer().run(true, false, setup);
        }
        catch (InvocationTargetException e) {
            SetupUIPlugin.log(e.getTargetException());
            this.fMessagePage.setException(e.getTargetException());
            return this.fMessagePage;
        }
        catch (InterruptedException interruptedException) {
            if (!repo.loggedIn()) {
                this.fMessagePage.setMessage(MessageWizardPage.Style.ERROR, Messages.SetupSampleRepositoryWizard_TITLE_NOTLOGGEDIN, Messages.SetupSampleRepositoryWizard_DESCRIPTION_NOTLOGGEDIN, NLS.bind((String)Messages.SetupSampleRepositoryWizard_MESSAGE_NOTLOGGEDIN, (Object[])new Object[]{repo.getName()}));
                return this.fMessagePage;
            }
            this.fMessagePage.setMessage(MessageWizardPage.Style.WARNING, Messages.SetupSampleRepositoryWizard_TITLE_OPCANCELLED, Messages.SetupSampleRepositoryWizard_DESCRIPTION_OPCANCELLED, Messages.SetupSampleRepositoryWizard_MESSAGE_OPCANCELLED);
            return this.fMessagePage;
        }
        if (!isJazzAdmin[0]) {
            this.fMessagePage.setMessage(MessageWizardPage.Style.ERROR, Messages.SetupSampleRepositoryWizard_TITLE_NOPERMISSIONS, Messages.SetupSampleRepositoryWizard_DESCRIPTION_NOPERMISSIONS, NLS.bind((String)Messages.SetupSampleRepositoryWizard_MESSAGE_NOPERMISSIONS, (Object[])new Object[]{repo.loggedInContributor().getName(), "JazzAdmins"}));
            return this.fMessagePage;
        }
        if (!hasDeveloperCAL[0]) {
            this.fMessagePage.setMessage(MessageWizardPage.Style.ERROR, Messages.SetupSampleRepositoryWizard_TITLE_NOLICENSE, Messages.SetupSampleRepositoryWizard_DESCRIPTION_NOLICENSE, NLS.bind((String)Messages.SetupSampleRepositoryWizard_MESSAGE_NOLICENSE, (Object[])new Object[]{repo.loggedInContributor().getName()}));
            return this.fMessagePage;
        }
        if (!canCreateUsers[0]) {
            this.fMessagePage.setMessage(MessageWizardPage.Style.ERROR, Messages.SetupSampleRepositoryWizard_TITLE_CANTCREATEUSERS, Messages.SetupSampleRepositoryWizard_DESCRIPTION_CANTCREATEUSERS, Messages.SetupSampleRepositoryWizard_MESSAGE_CANTCREATEUSERS);
            return this.fMessagePage;
        }
        return successPage;
    }

    private boolean repositoryExists(String uri) {
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repos.length) {
            ITeamRepository repository = repos[i];
            Collection aliases = repository.getAliasRepositoryURIs();
            String repoUri = repository.getRepositoryURI();
            if (repoUri.equalsIgnoreCase(uri)) {
                return true;
            }
            for (String alias : aliases) {
                if (!uri.equalsIgnoreCase(alias)) continue;
                return true;
            }
            ++i;
        }
        return false;
    }
}

