/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.setup.ui.internal.wizard;

import com.ibm.team.apt.setup.ui.internal.wizard.Messages;
import com.ibm.team.apt.setup.ui.internal.wizard.SampleRepositorySetupContext;
import com.ibm.team.apt.setup.ui.internal.wizard.SetupUIPlugin;
import com.ibm.team.foundation.setup.client.internal.registry.ProjectSetupDefinition;
import com.ibm.team.foundation.setup.client.internal.registry.ProjectSetupDefinitionRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SampleSetupSelectionWizardPage
extends WizardPage {
    private SampleRepositorySetupContext fContext;
    private TableViewer fViewer;
    ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Text fDescriptionText;

    protected SampleSetupSelectionWizardPage(SampleRepositorySetupContext context) {
        super("com.ibm.team.apt.setup.ui.internal.wizard.sampleSelection", Messages.SampleSetupSelectionWizardPage_TITLE, SetupUIPlugin.WIZARD_BANNER);
        this.fContext = context;
        this.setDescription(Messages.SampleSetupSelectionWizardPage_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(container);
        Label label = new Label(container, 0);
        label.setText(Messages.SampleSetupSelectionWizardPage_EXAMPLE_LIST_LABEL);
        this.fViewer = new TableViewer(container, 2820);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.fViewer.getControl());
        this.fViewer.setContentProvider((IContentProvider)new SimpleContentProvider());
        this.fViewer.setSorter(new ViewerSorter());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ProjectSetupDefinition) {
                    return ((ProjectSetupDefinition)element).getName();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return "";
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IWizardContainer container = SampleSetupSelectionWizardPage.this.getContainer();
                if (container instanceof WizardDialog) {
                    WizardDialog dialog = (WizardDialog)container;
                    if (SampleSetupSelectionWizardPage.this.getWizard().canFinish()) {
                        try {
                            SampleSetupSelectionWizardPage.this.getWizard().performFinish();
                        }
                        finally {
                            dialog.close();
                        }
                    }
                }
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SampleSetupSelectionWizardPage.this.updateSelection((IStructuredSelection)event.getSelection());
            }
        });
        Label descTitle = new Label(container, 16384);
        descTitle.setText(Messages.SampleSetupSelectionWizardPage_DESCRIPTION_BOX_LABEL);
        this.fDescriptionText = new Text(container, 2632);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, this.convertHeightInCharsToPixels(8)).applyTo((Control)this.fDescriptionText);
        this.setPageComplete(false);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.computeAvailableSetupDefinitions();
        }
        super.setVisible(visible);
    }

    private void computeAvailableSetupDefinitions() {
        this.setErrorMessage(null);
        ITeamRepository teamRepository = this.fContext.getTeamRepository();
        if (!teamRepository.loggedIn()) {
            this.fViewer.setInput((Object)Messages.SampleSetupSelectionWizardPage_ERROR_NOT_LOGGED_IN);
        } else {
            Collection availableSetupDefinitions = ProjectSetupDefinitionRegistry.getAvailableSetupDefinitions();
            ArrayList<ProjectSetupDefinition> setupDefinitions = new ArrayList<ProjectSetupDefinition>();
            for (String definitionId : availableSetupDefinitions) {
                setupDefinitions.add(ProjectSetupDefinitionRegistry.getSetupDefinition((String)definitionId));
            }
            if (setupDefinitions.size() == 0) {
                this.fViewer.setInput((Object)Messages.SampleSetupSelectionWizardPage_ERROR_NO_EXAMPLES_FOUND);
                this.setMessage(Messages.SampleSetupSelectionWizardPage_ERROR_NO_EXAMPLES_FOUND_MESSAGE, 1);
            } else {
                this.setMessage(null, 0);
                this.fViewer.setInput(setupDefinitions);
                ProjectSetupDefinition setupDefinition = this.fContext.getSetupDefinition();
                if (setupDefinition != null && setupDefinitions.contains(setupDefinition)) {
                    this.fViewer.setSelection((ISelection)new StructuredSelection((Object)setupDefinition));
                } else {
                    this.fViewer.setSelection((ISelection)new StructuredSelection(this.fViewer.getElementAt(0)));
                }
            }
        }
    }

    public void dispose() {
        this.fResourceManager.dispose();
    }

    private void updateSelection(IStructuredSelection selection) {
        Object selectedObject;
        ProjectSetupDefinition setupDescription = null;
        if (selection != null && (selectedObject = selection.getFirstElement()) instanceof ProjectSetupDefinition) {
            setupDescription = (ProjectSetupDefinition)selectedObject;
        }
        this.fContext.setSetupDefinition(setupDescription);
        this.setPageComplete(setupDescription != null);
        this.fDescriptionText.setText(setupDescription != null ? setupDescription.getDescription() : "");
    }

    private static class SimpleContentProvider
    implements IStructuredContentProvider {
        private SimpleContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[]{inputElement};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

