/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.setup.ui.internal.wizard;

import com.ibm.team.apt.setup.ui.internal.wizard.Messages;
import com.ibm.team.apt.setup.ui.internal.wizard.SetupUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class MessageWizardPage
extends WizardPage {
    private Label fIconLabel;
    private Label fMessageLabel;
    private Composite fContainer;

    protected MessageWizardPage() {
        super("com.ibm.team.apt.setup.ui.internal.wizard.messagePage", null, SetupUIPlugin.WIZARD_BANNER);
    }

    public void setMessage(Style style, String title, String description, String message) {
        this.setTitle(title);
        this.setDescription(description);
        this.fMessageLabel.setText(message);
        this.fIconLabel.setImage(Display.getCurrent().getSystemImage(style.fImageId));
        this.fContainer.layout(true, true);
    }

    public void setException(Throwable exception) {
        this.setTitle(Messages.MessageWizardPage_TITLE_EXCEPTION);
        this.setDescription(Messages.MessageWizardPage_TITLE_DESCRIPTION);
        String messageText = exception.getLocalizedMessage();
        this.fMessageLabel.setText(messageText);
        this.fIconLabel.setImage(Display.getCurrent().getSystemImage(Style.ERROR.fImageId));
        this.fContainer.layout(true, true);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).spacing(this.convertWidthInCharsToPixels(3), LayoutConstants.getSpacing().y).applyTo(this.fContainer);
        this.fIconLabel = new Label(this.fContainer, 0);
        GridDataFactory.fillDefaults().grab(false, false).align(16384, 0x1000000).applyTo((Control)this.fIconLabel);
        this.fMessageLabel = new Label(this.fContainer, 64);
        GridDataFactory.fillDefaults().grab(true, false).hint(this.convertWidthInCharsToPixels(80), -1).align(4, 0x1000000).applyTo((Control)this.fMessageLabel);
        this.setPageComplete(true);
        this.setControl((Control)this.fContainer);
        Dialog.applyDialogFont((Control)this.fContainer);
    }

    public void setVisible(boolean visible) {
        this.setPageComplete(!visible);
        super.setVisible(visible);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        ERROR(1),
        WARNING(8);

        private final int fImageId;

        private Style(int imageId) {
            this.fImageId = imageId;
        }
    }
}

