/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.wizards;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanSaveResult;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.core.PlanAddedEvent;
import com.ibm.team.apt.internal.ide.core.PlanEvent;
import com.ibm.team.apt.internal.ide.core.PlanModel;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.navigator.AbstractIterationFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.DevelopmentLineFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningDomainFolder;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.wizards.AbstractIterationPlanWizard;
import com.ibm.team.apt.internal.ide.ui.wizards.AbstractIterationPlanWizardPage;
import com.ibm.team.apt.internal.ide.ui.wizards.Messages;
import com.ibm.team.apt.internal.ide.ui.wizards.NewIterationPlanWizardPage;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewIterationPlanWizard
extends AbstractIterationPlanWizard
implements INewWizard {
    private AbstractIterationPlanWizardPage fNewIterationPlanPage;
    private IWorkbench fWorkbench;
    private boolean fCanFinish = true;

    public NewIterationPlanWizard() {
        this(new IterationPlanWizardContext(ProjectAreaPicker.getAllConnectedProjectAreas((boolean)true)));
    }

    public NewIterationPlanWizard(IterationPlanWizardContext context) {
        super(context);
        this.setWindowTitle(Messages.NewIterationPlanWizard_NEW_PLAN);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        if (selection != null) {
            this.processSelection(selection);
        }
        super.init(workbench, selection);
        if (!this.hasTeamRepository()) {
            this.fRepositorySelectionPage.setMessage(Messages.NewIterationPlanWizard_MSG_CONNECT_TO_REPOSITORY, 2);
        }
        if (!this.hasProjectArea() && this.hasMultipleTeamRepositories()) {
            this.fRepositorySelectionPage.setMessage(Messages.NewIterationPlanWizard_MSG_CONNECT_TO_PROJECT_AREA_SELECTION_REPOSITORY, 2);
        }
        if (!this.hasProjectArea() && !this.hasMultipleTeamRepositories()) {
            this.fProjectAreaSelectionPage.setMessage(Messages.NewIterationPlanWizard_MSG_CONNECT_TO_PROJECT_AREA, 2);
        }
        this.fNewIterationPlanPage = new NewIterationPlanWizardPage(this.fWizardContext);
        this.addPage((IWizardPage)this.fNewIterationPlanPage);
        this.setImageForAllPages(ImagePool.WIZBAN_CRT_ITERATION_PLAN);
    }

    private void processSelection(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof AbstractIterationFolder) {
            this.fWizardContext.clear();
            IIteration interval = ((AbstractIterationFolder)element).getIteration();
            this.fWizardContext.setIteration((IIterationHandle)interval);
        } else if (element instanceof DevelopmentLineFolder) {
            this.fWizardContext.clear();
            DevelopmentLineFolder folder = (DevelopmentLineFolder)element;
            this.fWizardContext.setDevelopmentLineHandle((IDevelopmentLineHandle)folder.getDevelopmentLine());
        } else if (element instanceof PlanningDomainFolder) {
            this.fWizardContext.clear();
            Object categoryElement = ((PlanningDomainFolder)element).getRoot().getDomainSubtreeRoot().getCategoryElement();
            this.processCategoryElement(categoryElement);
        } else if (element instanceof IProjectAreaHandle) {
            this.fWizardContext.clear();
            IProjectAreaHandle projectArea = (IProjectAreaHandle)element;
            this.fWizardContext.setSelectedProjectArea(projectArea);
        } else if (element instanceof DomainSubtreeRoot) {
            this.fWizardContext.clear();
            Object categoryElement = ((DomainSubtreeRoot)element).getCategoryElement();
            this.processCategoryElement(categoryElement);
        } else if (element instanceof ITeamArea) {
            this.fWizardContext.clear();
            ITeamArea teamArea = (ITeamArea)element;
            this.fWizardContext.setSelectedProjectArea(teamArea.getProjectArea());
            this.fWizardContext.setTeamArea((ITeamAreaHandle)teamArea);
        } else if (element instanceof IIterationPlanRecord) {
            this.fWizardContext.clear();
            IIterationPlanRecord plan = (IIterationPlanRecord)element;
            ITeamArea teamArea = (ITeamArea)((ITeamRepository)plan.getOrigin()).itemManager().getSharedItemIfKnown((IItemHandle)plan.getTeamArea());
            this.fWizardContext.setIteration(plan.getIteration());
            this.fWizardContext.setSelectedProjectArea(teamArea.getProjectArea());
            this.fWizardContext.setTeamArea((ITeamAreaHandle)teamArea);
        }
    }

    private void processCategoryElement(Object categoryElement) {
        ITeamAreaHandle handle;
        ITeamArea teamArea;
        if (categoryElement instanceof IProjectAreaHandle) {
            this.fWizardContext.setSelectedProjectArea((IProjectAreaHandle)categoryElement);
        } else if (categoryElement instanceof ITeamAreaHandle && (teamArea = (ITeamArea)((ITeamRepository)(handle = (ITeamAreaHandle)categoryElement).getOrigin()).itemManager().getSharedItemIfKnown((IItemHandle)handle)) != null) {
            this.fWizardContext.setSelectedProjectArea(teamArea.getProjectArea());
            this.fWizardContext.setTeamArea((ITeamAreaHandle)teamArea);
        }
    }

    public boolean canFinish() {
        return this.fCanFinish && super.canFinish();
    }

    public boolean performFinish() {
        try {
            final IIterationPlanRecord[] result = new IIterationPlanRecord[1];
            this.getContainer().run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.NewIterationPlanWizard_MONITOR_CREATE_PLAN, 4);
                    IIterationPlanRecord plan = NewIterationPlanWizard.this.fNewIterationPlanPage.getResult();
                    ITeamRepository teamRepository = ((NewIterationPlanWizard)NewIterationPlanWizard.this).fNewIterationPlanPage.fContext.getTeamRepository();
                    IProjectAreaHandle projectAreaHandle = NewIterationPlanWizard.this.fNewIterationPlanPage.getContext().getSelectedProjectArea();
                    IProjectArea projectArea = (IProjectArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (!ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(teamRepository, false).contains(projectAreaHandle)) {
                        ConnectedProjectAreaRegistry.getDefault().addConnectedProjectArea(projectArea);
                    }
                    monitor.worked(1);
                    IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((ITeamRepository)teamRepository);
                    final IterationPlanSaveResult saveResult = ((IterationPlanClient)client).create(plan, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (saveResult.getStatus().getSeverity() == 0) {
                        IIterationPlanRecord savedPlan = saveResult.getPlanRecord();
                        monitor.worked(1);
                        PlanModel.INSTANCE.firePlanEvent((PlanEvent)new PlanAddedEvent(teamRepository, savedPlan));
                        monitor.worked(1);
                        result[0] = savedPlan;
                    } else if (saveResult.getStatus().getSeverity() == 4) {
                        UI.syncExec(NewIterationPlanWizard.this.fNewIterationPlanPage.getControl(), new Runnable(){

                            public void run() {
                                NewIterationPlanWizard.this.fNewIterationPlanPage.setPageComplete(false);
                                NewIterationPlanWizard.this.fNewIterationPlanPage.setMessage(saveResult.getStatus().getDetails(), 3);
                            }
                        });
                    }
                    monitor.done();
                }
            });
            if (result[0] != null) {
                PlanningUI.openIterationPlanEditor((IIterationPlanRecordHandle)result[0], this.fWorkbench.getActiveWorkbenchWindow().getActivePage());
                return true;
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), Messages.NewIterationPlanWizard_FAILURE_PLAN, e.getLocalizedMessage());
            this.fCanFinish = false;
        }
        catch (InterruptedException interruptedException) {}
        this.getContainer().updateButtons();
        return false;
    }
}

